/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class DocumentLoader {
    protected SVGDocumentFactory documentFactory;
    protected HashMap cacheMap = new HashMap();
    protected UserAgent userAgent;
    protected BridgeContext bridgeContext;

    protected DocumentLoader() {
    }

    public DocumentLoader(UserAgent userAgent) {
        this.userAgent = userAgent;
        this.documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
        this.documentFactory.setValidating(userAgent.isXMLParserValidating());
    }

    public Document checkCache(String string) {
        DocumentState documentState;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = 0;
        }
        if ((n = string.indexOf(35, n)) != -1) {
            string = string.substring(0, n);
        }
        if ((documentState = (DocumentState)this.cacheMap.get(string)) != null) {
            return documentState.document;
        }
        return null;
    }

    public Document loadDocument(String string) throws IOException {
        Document document = this.checkCache(string);
        if (document != null) {
            return document;
        }
        SVGDocument sVGDocument = this.documentFactory.createSVGDocument(string);
        if (this.bridgeContext != null) {
            this.bridgeContext.initializeDocument((Document)sVGDocument);
        }
        DocumentDescriptor documentDescriptor = this.documentFactory.getDocumentDescriptor();
        DocumentState documentState = new DocumentState(string, (Document)sVGDocument, documentDescriptor);
        this.cacheMap.put(string, documentState);
        return documentState.document;
    }

    public Document loadDocument(String string, InputStream inputStream) throws IOException {
        Document document = this.checkCache(string);
        if (document != null) {
            return document;
        }
        SVGDocument sVGDocument = this.documentFactory.createSVGDocument(string, inputStream);
        if (this.bridgeContext != null) {
            this.bridgeContext.initializeDocument((Document)sVGDocument);
        }
        DocumentDescriptor documentDescriptor = this.documentFactory.getDocumentDescriptor();
        DocumentState documentState = new DocumentState(string, (Document)sVGDocument, documentDescriptor);
        this.cacheMap.put(string, documentState);
        return documentState.document;
    }

    public void setBridgeContext(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public void dispose() {
        this.cacheMap.clear();
    }

    public int getLineNumber(Element element) {
        String string = ((SVGDocument)element.getOwnerDocument()).getURL();
        DocumentState documentState = (DocumentState)this.cacheMap.get(string);
        if (documentState == null) {
            return -1;
        }
        return documentState.desc.getLocationLine(element);
    }

    private static class DocumentState {
        private String uri;
        private Document document;
        private DocumentDescriptor desc;

        public DocumentState(String string, Document document, DocumentDescriptor documentDescriptor) {
            this.uri = string;
            this.document = document;
            this.desc = documentDescriptor;
        }

        public DocumentDescriptor getDocumentDescriptor() {
            return this.desc;
        }

        public String getURI() {
            return this.uri;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

