/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.File;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.mail.EmailReceiver;
import org.apache.axis2.transport.mail.MailWorker;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleMailListener
implements Runnable,
TransportListener {
    private static final Log log = LogFactory.getLog((Class)SimpleMailListener.class);
    private static boolean doThreads = true;
    private ConfigurationContext configurationContext = null;
    private boolean stopped = false;
    private String host;
    private String password;
    private String port;
    private String replyTo;
    private String user;

    public SimpleMailListener() {
    }

    public SimpleMailListener(String host, String port, String userid, String password, String dir) throws AxisFault {
        this.host = host;
        this.port = port;
        this.user = userid;
        this.password = password;
        try {
            File repo = new File(dir);
            if (!repo.exists()) {
                throw new Exception("repository not found");
            }
            File axis2xml = new File(repo, "axis2.xml");
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(dir, axis2xml.getName());
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
        }
        try {
            log.info((Object)"Sleeping for a bit to let the engine start up.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            log.debug((Object)e1.getMessage(), (Throwable)e1);
        }
        ListenerManager listenerManager = this.configurationContext.getListenerManager();
        TransportInDescription trsIn = new TransportInDescription(new QName("mail"));
        trsIn.setReceiver(this);
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
            listenerManager.init(this.configurationContext);
        }
        listenerManager.addListener(trsIn, true);
    }

    public void init(ConfigurationContext configurationContext, TransportInDescription transportIn) throws AxisFault {
        this.configurationContext = configurationContext;
        this.user = Utils.getParameterValue(transportIn.getParameter("transport.mail.pop3.user"));
        this.host = Utils.getParameterValue(transportIn.getParameter("transport.mail.pop3.host"));
        this.password = Utils.getParameterValue(transportIn.getParameter("transport.mail.pop3.password"));
        this.port = Utils.getParameterValue(transportIn.getParameter("transport.mail.pop3.port"));
        this.replyTo = Utils.getParameterValue(transportIn.getParameter("transport.mail.replyToAddress"));
        if (this.user == null || this.host == null || this.password == null || this.port == null) {
            if (this.user == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "User"));
            }
            if (this.host == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Host"));
            }
            if (this.port == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Port"));
            }
            if (this.password == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Password"));
            }
        }
    }

    public static void main(String[] args) throws AxisFault {
        if (args.length != 1) {
            log.info((Object)"java SimpleMailListener <repository>");
        } else {
            String dir = args[0];
            File repo = new File(dir);
            if (!repo.exists()) {
                throw new AxisFault("repository not found");
            }
            File axis2xml = new File(repo, "axis2.xml");
            ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(dir, axis2xml.getName());
            SimpleMailListener sas = new SimpleMailListener();
            TransportInDescription transportIn = configurationContext.getAxisConfiguration().getTransportIn(new QName("mail"));
            if (transportIn != null) {
                sas.init(configurationContext, transportIn);
                log.info((Object)("Starting the SimpleMailListener with repository " + new File(args[0]).getAbsolutePath()));
                sas.start();
            } else {
                log.info((Object)"Startup failed, mail transport not configured, Configure the mail trnasport in the axis2.xml file");
            }
        }
    }

    public void run() {
        if (!this.stopped) {
            String logMessage = "Mail listner is being setup to listen to the address " + this.user + "@" + this.host + " On port " + this.port;
            log.info((Object)logMessage);
        }
        while (!this.stopped) {
            try {
                EmailReceiver receiver = new EmailReceiver(this.user, this.host, this.port, this.password);
                receiver.connect();
                Message[] msgs = receiver.receive();
                if (msgs != null && msgs.length > 0) {
                    log.info((Object)(msgs.length + " Message Found"));
                    for (int i = 0; i < msgs.length; ++i) {
                        MimeMessage msg = (MimeMessage)msgs[i];
                        if (msg != null) {
                            MailWorker worker = new MailWorker(msg, this.configurationContext);
                            worker.run();
                        }
                        msg.setFlag(Flags.Flag.DELETED, true);
                    }
                }
                receiver.disconnect();
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                log.debug((Object)("An error occured when running the mail listner." + e.getMessage()), (Throwable)e);
                break;
            }
        }
        log.info((Object)"Mail listener has been stoped.");
    }

    public void start() throws AxisFault {
        this.start(false);
    }

    public void start(boolean daemon) throws AxisFault {
        if (this.user == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "User"));
        }
        if (this.host == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "Host"));
        }
        if (this.port == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "Port"));
        }
        if (this.password == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "Password"));
        }
        if (doThreads) {
            this.configurationContext.getThreadPool().execute(this);
        } else {
            this.run();
        }
    }

    public void stop() {
        this.stopped = true;
        log.info((Object)"Quiting the mail listner");
    }

    public boolean getDoThreads() {
        return doThreads;
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference(this.replyTo + "/services/" + serviceName);
    }

    public void setDoThreads(boolean value) {
        doThreads = value;
    }
}

