/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.axis2.transport.jms.JMSVendorAdapter;
import org.apache.axis2.util.Loader;

public abstract class BeanVendorAdapter
extends JMSVendorAdapter {
    protected static final String CONNECTION_FACTORY_CLASS = "transport.jms.ConnectionFactoryClass";

    private void callSetters(HashMap cfConfig, Class factoryClass, ConnectionFactory factory) throws Exception {
        PropertyDescriptor[] bpd = Introspector.getBeanInfo(factoryClass).getPropertyDescriptors();
        for (int i = 0; i < bpd.length; ++i) {
            Object value;
            PropertyDescriptor thisBPD = bpd[i];
            String propName = thisBPD.getName();
            if (!cfConfig.containsKey(propName) || (value = cfConfig.get(propName)) == null) continue;
            String validType = thisBPD.getName();
            if (!value.getClass().getName().equals(validType)) {
                throw new IllegalArgumentException("badType");
            }
            if (thisBPD.getWriteMethod() == null) {
                throw new IllegalArgumentException("notWriteable");
            }
            thisBPD.getWriteMethod().invoke((Object)factory, value);
        }
    }

    private ConnectionFactory getConnectionFactory(HashMap cfConfig) throws Exception {
        String classname = (String)cfConfig.get(CONNECTION_FACTORY_CLASS);
        if (classname == null || classname.trim().length() == 0) {
            throw new IllegalArgumentException("noCFClass");
        }
        Class factoryClass = Loader.loadClass(classname);
        ConnectionFactory factory = (ConnectionFactory)factoryClass.newInstance();
        this.callSetters(cfConfig, factoryClass, factory);
        return factory;
    }

    public QueueConnectionFactory getQueueConnectionFactory(HashMap cfConfig) throws Exception {
        return (QueueConnectionFactory)this.getConnectionFactory(cfConfig);
    }

    public TopicConnectionFactory getTopicConnectionFactory(HashMap cfConfig) throws Exception {
        return (TopicConnectionFactory)this.getConnectionFactory(cfConfig);
    }
}

