/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;

public class RequestLine {
    private HttpVersion httpversion = null;
    private String method = null;
    private String uri = null;

    public RequestLine(String method, String uri, HttpVersion httpversion) {
        if (method == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null");
        }
        if (httpversion == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        this.method = method;
        this.uri = uri;
        this.httpversion = httpversion;
    }

    public RequestLine(String method, String uri, String httpversion) throws ProtocolException {
        this(method, uri, HttpVersion.parse((String)httpversion));
    }

    public static RequestLine parseLine(String l) throws HttpException {
        String method = null;
        String uri = null;
        String protocol = null;
        try {
            StringTokenizer st = new StringTokenizer(l, " ");
            method = st.nextToken();
            uri = st.nextToken();
            protocol = st.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new ProtocolException("Invalid request line: " + l);
        }
        return new RequestLine(method, uri, protocol);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.method);
        sb.append(" ");
        sb.append(this.uri);
        sb.append(" ");
        sb.append(this.httpversion);
        return sb.toString();
    }

    public HttpVersion getHttpVersion() {
        return this.httpversion;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }
}

