/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RESTSender
extends AbstractHTTPSender {
    private static final Log log = LogFactory.getLog((Class)RESTSender.class);

    public RequestData createRequest(MessageContext msgContext, OMElement dataout) {
        RequestData data = new RequestData();
        Iterator iter1 = dataout.getChildElements();
        ArrayList<String> paraList = new ArrayList<String>();
        ArrayList<String> urlList = new ArrayList<String>();
        String[] urlParameterList = new String[]{};
        if (msgContext.getProperty("URLParameterList") != null) {
            urlParameterList = (String[])msgContext.getProperty("URLParameterList");
        }
        OMElement bodypara = OMAbstractFactory.getOMFactory().createOMElement("temp", null);
        while (iter1.hasNext()) {
            OMElement ele = (OMElement)iter1.next();
            boolean has = false;
            for (int i = 0; i < urlParameterList.length; ++i) {
                if (!urlParameterList[i].equals(ele.getLocalName())) continue;
                has = true;
                break;
            }
            if (has) {
                String parameter1 = ele.getLocalName() + "=" + ele.getText();
                urlList.add(parameter1);
                continue;
            }
            bodypara.addChild((OMNode)ele);
        }
        String urlString = "";
        for (int i = 0; i < urlList.size(); ++i) {
            String c = (String)urlList.get(i);
            urlString = "".equals(urlString) ? c : urlString + "&" + c;
            data.urlRequest = urlString;
        }
        Iterator it = bodypara.getChildElements();
        while (it.hasNext()) {
            OMElement ele1 = (OMElement)it.next();
            String parameter2 = ele1.getLocalName() + "=" + ele1.getText();
            paraList.add(parameter2);
        }
        String paraString = "";
        for (int j = 0; j < paraList.size(); ++j) {
            String b = (String)paraList.get(j);
            paraString = "".equals(paraString) ? b : paraString + "&" + b;
            data.bodyRequest = paraString;
        }
        return data;
    }

    public void send(MessageContext msgContext, OMElement dataout, URL url, String soapActionString) {
        try {
            String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
            if (httpMethod != null && "GET".equalsIgnoreCase(httpMethod)) {
                this.sendViaGet(msgContext, url);
                return;
            }
            this.sendViaPost(msgContext, dataout, url, soapActionString);
        }
        catch (Exception e) {
            log.error((Object)"Error in extracting transport properties from message context", (Throwable)e);
        }
    }

    private void sendViaGet(MessageContext msgContext, URL url) throws MalformedURLException, AxisFault, IOException {
        String param = this.getParam(msgContext);
        GetMethod getMethod = new GetMethod();
        getMethod.setPath(url.getFile() + "?" + param);
        String charEncoding = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncoding == null) {
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        } else {
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + charEncoding);
        }
        HttpClient httpClient = this.getHttpClient(msgContext);
        this.executeMethod(httpClient, msgContext, url, (HttpMethod)getMethod);
        if (getMethod.getStatusCode() == 200) {
            this.processResponse((HttpMethodBase)getMethod, msgContext);
        } else {
            if (getMethod.getStatusCode() == 202) {
                return;
            }
            if (getMethod.getStatusCode() == 500) {
                Header contenttypeHheader = getMethod.getResponseHeader("Content-Type");
                String value = contenttypeHheader.getValue();
                if (value != null && (value.indexOf("text/xml") >= 0 || value.indexOf("application/soap+xml") >= 0)) {
                    this.processResponse((HttpMethodBase)getMethod, msgContext);
                }
            } else {
                throw new AxisFault(Messages.getMessage("transportError", String.valueOf(getMethod.getStatusCode()), getMethod.getResponseBodyAsString()));
            }
        }
    }

    private void sendViaPost(MessageContext msgContext, OMElement dataout, URL url, String soapActionString) {
        HttpClient httpClient = this.getHttpClient(msgContext);
        PostMethod postMethod = new PostMethod(url.toString());
        String httpContentType = msgContext.getProperty("ContentType") != null ? (String)msgContext.getProperty("ContentType") : "application/xml";
        String charEncoding = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        if (httpContentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            RequestData reqData = this.createRequest(msgContext, dataout);
            postMethod.setPath(url.getPath() + (reqData.urlRequest != null ? "?" + reqData.urlRequest : ""));
            if (reqData.bodyRequest == null) {
                reqData.bodyRequest = "0";
            }
            postMethod.setRequestEntity((RequestEntity)new AxisRESTRequestEntity(reqData.bodyRequest, charEncoding, msgContext, httpContentType));
        } else {
            postMethod.setPath(url.getPath());
            postMethod.setRequestEntity((RequestEntity)new AbstractHTTPSender.AxisRequestEntity(this, dataout, this.chunked, msgContext, charEncoding, soapActionString));
        }
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            postMethod.setContentChunked(true);
        }
        postMethod.setRequestHeader("User-Agent", "Axis/2.0");
        if (msgContext.isSOAP11() && !msgContext.isDoingREST()) {
            postMethod.setRequestHeader("SOAPAction", soapActionString);
        }
        postMethod.setRequestHeader("Host", url.getHost());
        if (this.httpVersion != null) {
            if (this.httpVersion.equals("HTTP/1.0")) {
                httpClient.getParams().setVersion(HttpVersion.HTTP_1_0);
                postMethod.setRequestHeader("Connection", HTTPConstants.HEADER_CONNECTION_KEEPALIVE);
            } else {
                postMethod.setRequestHeader("Connection", HTTPConstants.HEADER_CONNECTION_KEEPALIVE);
                postMethod.setRequestHeader("Expect", "100-continue");
            }
        }
        try {
            String value;
            Header contenttypeHheader;
            this.executeMethod(httpClient, msgContext, url, (HttpMethod)postMethod);
            if (postMethod.getStatusCode() == 200) {
                this.processResponse((HttpMethodBase)postMethod, msgContext);
                return;
            }
            if (postMethod.getStatusCode() == 202) {
                return;
            }
            if (postMethod.getStatusCode() == 500 && (contenttypeHheader = postMethod.getResponseHeader("Content-Type")) != null && ((value = contenttypeHheader.getValue()).indexOf("text/xml") >= 0 || value.indexOf("application/soap+xml") >= 0)) {
                this.processResponse((HttpMethodBase)postMethod, msgContext);
                return;
            }
            throw new AxisFault(Messages.getMessage("transportError", String.valueOf(postMethod.getStatusCode()), postMethod.getResponseBodyAsString()));
        }
        catch (Exception e) {
            log.error((Object)"Error in processing POST request", (Throwable)e);
            return;
        }
    }

    public String getParam(MessageContext msgContext) {
        OMElement dataOut = msgContext.getEnvelope().getBody().getFirstElement();
        Iterator iter1 = dataOut.getChildElements();
        ArrayList<String> paraList = new ArrayList<String>();
        while (iter1.hasNext()) {
            OMElement ele = (OMElement)iter1.next();
            String parameter = ele.getLocalName() + "=" + ele.getText();
            paraList.add(parameter);
        }
        String paraString = "";
        int count = paraList.size();
        for (int i = 0; i < count; ++i) {
            String c = (String)paraList.get(i);
            paraString = "".equals(paraString) ? c : paraString + "&" + c;
        }
        return paraString;
    }

    private class RequestData {
        private String bodyRequest;
        private String urlRequest;

        private RequestData() {
        }
    }

    public class AxisRESTRequestEntity
    implements RequestEntity {
        private String charSetEnc;
        private String contentType;
        private MessageContext msgCtxt;
        private String postRequestBody;

        public AxisRESTRequestEntity(String postRequestBody, String charSetEnc, MessageContext msgCtxt, String contentType) {
            this.postRequestBody = postRequestBody;
            this.charSetEnc = charSetEnc;
            this.msgCtxt = msgCtxt;
            this.contentType = contentType;
        }

        public void writeRequest(OutputStream output) throws IOException {
            output.write(this.postRequestBody.getBytes());
        }

        public long getContentLength() {
            return this.postRequestBody.getBytes().length;
        }

        public String getContentType() {
            return this.contentType;
        }

        public boolean isRepeatable() {
            return true;
        }
    }
}

