/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.UUIDGenerator;

class OutInAxisOperationClient
implements OperationClient {
    private OutInAxisOperation axisOp;
    private ServiceContext sc;
    private Options options;
    private OperationContext oc;
    private Callback callback;
    boolean completed;

    OutInAxisOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
        this.axisOp = axisOp;
        this.sc = sc;
        this.options = options;
        this.completed = false;
        this.oc = new OperationContext(axisOp);
        this.oc.setParent(this.sc);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void addMessageContext(MessageContext mc) throws AxisFault {
        mc.setServiceContext(this.sc);
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        this.axisOp.registerOperationContext(mc, this.oc);
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        return this.oc.getMessageContext(messageLabel);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    private void setMessageID(MessageContext mc) {
        String messageId = this.options.getMessageId();
        if (messageId == null || "".equals(messageId)) {
            messageId = UUIDGenerator.getUUID();
        }
        mc.setMessageID(messageId);
    }

    public void execute(boolean block) throws AxisFault {
        Parameter soapaction;
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        MessageContext mc = this.oc.getMessageContext("Out");
        if (mc == null) {
            throw new AxisFault(Messages.getMessage("outmsgctxnull"));
        }
        mc.setOptions(this.options);
        TransportOutDescription transportOut = this.options.getTransportOut();
        if (transportOut == null) {
            EndpointReference toEPR = this.options.getTo() != null ? this.options.getTo() : mc.getTo();
            transportOut = ClientUtils.inferOutTransport(cc.getAxisConfiguration(), toEPR, mc);
        }
        mc.setTransportOut(transportOut);
        if (this.options.getTransportIn() == null && mc.getTransportIn() == null) {
            mc.setTransportIn(ClientUtils.inferInTransport(cc.getAxisConfiguration(), this.options, mc));
        } else if (mc.getTransportIn() == null) {
            mc.setTransportIn(this.options.getTransportIn());
        }
        if ((mc.getSoapAction() == null || "".equals(mc.getSoapAction())) && (soapaction = this.axisOp.getParameter("soapaction")) != null) {
            mc.setSoapAction((String)soapaction.getValue());
        }
        this.addReferenceParameters(mc);
        if (this.options.isUseSeparateListener()) {
            CallbackReceiver callbackReceiver = (CallbackReceiver)this.axisOp.getMessageReceiver();
            callbackReceiver.addCallback(mc.getMessageID(), this.callback);
            EndpointReference replyToFromTransport = mc.getConfigurationContext().getListenerManager().getEPRforService(this.sc.getAxisService().getName(), this.axisOp.getName().getLocalPart(), mc.getTransportIn().getName().getLocalPart());
            if (mc.getReplyTo() == null) {
                mc.setReplyTo(replyToFromTransport);
            } else {
                mc.getReplyTo().setAddress(replyToFromTransport.getAddress());
            }
            mc.setProperty("transportNonBlocking", Boolean.TRUE);
            AxisEngine engine = new AxisEngine(cc);
            engine.send(mc);
        } else if (block) {
            MessageContext response = this.send(mc);
            SOAPEnvelope resEnvelope = response.getEnvelope();
            if (resEnvelope.getBody().hasFault()) {
                SOAPFault soapFault = resEnvelope.getBody().getFault();
                if (this.options.isExceptionToBeThrownOnSOAPFault()) {
                    throw new AxisFault(soapFault.getCode(), soapFault.getReason(), soapFault.getNode(), soapFault.getRole(), soapFault.getDetail());
                }
            }
            this.completed = true;
        } else {
            this.sc.getConfigurationContext().getThreadPool().execute(new NonBlockingInvocationWorker(this.callback, mc));
        }
    }

    private void addReferenceParameters(MessageContext msgctx) {
        EndpointReference tepr;
        EndpointReference to = msgctx.getTo();
        if (this.options.isManageSession() && (tepr = this.sc.getTargetEPR()) != null) {
            Map map = tepr.getAllReferenceParameters();
            Iterator valuse = map.values().iterator();
            while (valuse.hasNext()) {
                Object refparaelement = valuse.next();
                if (!(refparaelement instanceof OMElement)) continue;
                to.addReferenceParameter((OMElement)refparaelement);
            }
        }
    }

    private MessageContext send(MessageContext msgctx) throws AxisFault {
        AxisEngine engine = new AxisEngine(msgctx.getConfigurationContext());
        engine.send(msgctx);
        MessageContext responseMessageContext = new MessageContext();
        responseMessageContext.setTransportIn(msgctx.getTransportIn());
        responseMessageContext.setTransportOut(msgctx.getTransportOut());
        responseMessageContext.setOptions(this.options);
        responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
        responseMessageContext.setServerSide(false);
        responseMessageContext.setDoingREST(msgctx.isDoingREST());
        this.addMessageContext(responseMessageContext);
        SOAPEnvelope resenvelope = TransportUtils.createSOAPMessage(responseMessageContext, msgctx.getEnvelope().getNamespace().getName());
        if (resenvelope != null) {
            responseMessageContext.setEnvelope(resenvelope);
            engine = new AxisEngine(msgctx.getConfigurationContext());
            engine.receive(responseMessageContext);
            if (responseMessageContext.getReplyTo() != null) {
                this.sc.setTargetEPR(responseMessageContext.getReplyTo());
            }
        } else {
            throw new AxisFault(Messages.getMessage("blockingInvocationExpectsResponse"));
        }
        return responseMessageContext;
    }

    public void reset() throws AxisFault {
        if (!this.completed) {
            throw new AxisFault(Messages.getMessage("cannotreset"));
        }
        this.oc = null;
        this.completed = false;
    }

    public void complete(MessageContext msgCtxt) throws AxisFault {
        TransportOutDescription trsout = msgCtxt.getTransportOut();
        if (trsout != null) {
            trsout.getSender().cleanup(msgCtxt);
        }
    }

    public OperationContext getOperationContext() {
        return this.oc;
    }

    private class NonBlockingInvocationWorker
    implements Runnable {
        private Callback callback;
        private MessageContext msgctx;

        public NonBlockingInvocationWorker(Callback callback, MessageContext msgctx) {
            this.callback = callback;
            this.msgctx = msgctx;
        }

        public void run() {
            try {
                MessageContext response = OutInAxisOperationClient.this.send(this.msgctx);
                SOAPEnvelope resenvelope = response.getEnvelope();
                SOAPBody body = resenvelope.getBody();
                if (body.hasFault()) {
                    Exception ex = body.getFault().getException();
                    if (ex != null) {
                        this.callback.onError(ex);
                    } else {
                        this.callback.onError(new Exception(body.getFault().getReason().getText()));
                    }
                } else {
                    AsyncResult asyncResult = new AsyncResult(response);
                    this.callback.onComplete(asyncResult);
                }
                this.callback.setComplete(true);
            }
            catch (Exception e) {
                this.callback.onError(e);
            }
        }
    }
}

