/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServiceGroup
extends AxisDescription {
    private static final Log log = LogFactory.getLog((Class)AxisServiceGroup.class);
    private ArrayList modulesList = new ArrayList();
    private ArrayList engagedModules;
    private HashMap moduleConfigmap = new HashMap();
    private ClassLoader serviceGroupClassLoader;
    private String serviceGroupName;

    public AxisServiceGroup() {
        this.engagedModules = new ArrayList();
    }

    public AxisServiceGroup(AxisConfiguration axisDescription) {
        this();
        this.setParent(axisDescription);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        if (this.moduleConfigmap == null) {
            this.moduleConfigmap = new HashMap();
        }
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleref(QName moduleref) {
        this.modulesList.add(moduleref);
    }

    public void addService(AxisService service) throws AxisFault {
        service.setParent(this);
        AxisConfiguration axisConfig = (AxisConfiguration)this.getParent();
        if (axisConfig != null) {
            Iterator modules = this.getEngagedModules().iterator();
            while (modules.hasNext()) {
                QName moduleName = (QName)modules.next();
                AxisModule axisModule = axisConfig.getModule(moduleName);
                if (axisModule != null) {
                    Module moduleImpl = axisModule.getModule();
                    if (moduleImpl != null) {
                        moduleImpl.engageNotify(service);
                    }
                    service.engageModule(axisModule, axisConfig);
                    continue;
                }
                throw new AxisFault(Messages.getMessage("modulenotavailble", moduleName.getLocalPart()));
            }
        }
        service.setLastupdate();
        this.addChild(service);
    }

    public void addToengagedModules(QName moduleName) {
        this.engagedModules.add(moduleName);
    }

    public void removeFromEngageList(QName moduleName) {
        this.engagedModules.remove(moduleName);
    }

    public void engageModule(AxisModule module) throws AxisFault {
        QName moduleName = module.getName();
        Iterator iterator = this.engagedModules.iterator();
        while (iterator.hasNext()) {
            QName modu = (QName)iterator.next();
            if (!modu.getLocalPart().equals(moduleName.getLocalPart())) continue;
            log.debug((Object)Messages.getMessage("modulealredyengagedtoservicegroup", moduleName.getLocalPart()));
            throw new AxisFault(Messages.getMessage("modulealredyengagedtoservicegroup", moduleName.getLocalPart()));
        }
        Iterator srevice = this.getServices();
        while (srevice.hasNext()) {
            AxisService axisService = (AxisService)srevice.next();
            axisService.engageModule(module, (AxisConfiguration)this.getParent());
        }
        this.addToengagedModules(moduleName);
    }

    public void removeService(String name) throws AxisFault {
        AxisService service = this.getService(name);
        if (service != null) {
            ((AxisConfiguration)this.getParent()).notifyObservers(1, service);
        }
        this.removeChild(name);
    }

    public AxisConfiguration getAxisDescription() {
        return (AxisConfiguration)this.getParent();
    }

    public ArrayList getEngagedModules() {
        return this.engagedModules;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModuleRefs() {
        return this.modulesList;
    }

    public AxisService getService(String name) throws AxisFault {
        return (AxisService)this.getChild(name);
    }

    public ClassLoader getServiceGroupClassLoader() {
        return this.serviceGroupClassLoader;
    }

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public Iterator getServices() {
        return this.getChildren();
    }

    public void setAxisDescription(AxisConfiguration axisDescription) {
        this.setParent(axisDescription);
    }

    public void setServiceGroupClassLoader(ClassLoader serviceGroupClassLoader) {
        this.serviceGroupClassLoader = serviceGroupClassLoader;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    public Object getKey() {
        return this.getServiceGroupName();
    }

    public boolean isEngaged(QName moduleName) {
        AxisModule module = this.getAxisDescription().getModule(moduleName);
        if (module == null) {
            return false;
        }
        Iterator engagedModuleItr = this.engagedModules.iterator();
        while (engagedModuleItr.hasNext()) {
            QName axisModule = (QName)engagedModuleItr.next();
            if (!axisModule.getLocalPart().equals(module.getName().getLocalPart())) continue;
            return true;
        }
        return false;
    }
}

