/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.i18n.Messages;

public class ServiceGroupContext
extends AbstractContext {
    private transient AxisServiceGroup axisServiceGroup;
    private String id;
    private Map serviceContextMap;

    public ServiceGroupContext(ConfigurationContext parent, AxisServiceGroup axisServiceGroup) {
        super(parent);
        this.axisServiceGroup = axisServiceGroup;
        this.serviceContextMap = new HashMap();
    }

    public AxisServiceGroup getDescription() {
        return this.axisServiceGroup;
    }

    public String getId() {
        return this.id;
    }

    public ServiceContext getServiceContext(AxisService service) throws AxisFault {
        AxisService axisService = this.axisServiceGroup.getService(service.getName());
        if (axisService == null) {
            throw new AxisFault(Messages.getMessage("invalidserviceinagroup", service.getName(), this.axisServiceGroup.getServiceGroupName()));
        }
        ServiceContext serviceContext = (ServiceContext)this.serviceContextMap.get(service.getName());
        if (serviceContext == null) {
            serviceContext = new ServiceContext(service, this);
            this.serviceContextMap.put(service.getName(), serviceContext);
        }
        return serviceContext;
    }

    public Iterator getServiceContexts() {
        return this.serviceContextMap.values().iterator();
    }

    public void setId(String id) {
        this.id = id;
    }
}

