/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.CallbackReceiver;

public class ServiceClient {
    public static final String ANON_SERVICE = "__ANONYMOUS_SERVICE__";
    public static final QName ANON_OUT_ONLY_OP = new QName("__OPERATION_OUT_ONLY__");
    public static final QName ANON_ROBUST_OUT_ONLY_OP = new QName("__OPERATION_ROBUST_OUT_ONLY__");
    public static final QName ANON_OUT_IN_OP = new QName("__OPERATION_OUT_IN__");
    private AxisService axisService;
    private AxisConfiguration axisConfig;
    private ConfigurationContext configContext;
    private ServiceContext serviceContext;
    private Options options = new Options();
    private Options overrideOptions;
    private ArrayList headers;
    private CallbackReceiver callbackReceiver;

    public ServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        this.initializeTransports(configContext);
        this.axisConfig = this.configContext.getAxisConfiguration();
        this.axisService = axisService != null ? axisService : (this.axisConfig.getService(ANON_SERVICE) != null ? this.axisConfig.getService(ANON_SERVICE) : this.createAnonymousService());
        if (this.axisConfig.getService(this.axisService.getName()) == null) {
            this.axisConfig.addService(this.axisService);
        }
        ServiceGroupContext sgc = new ServiceGroupContext(this.configContext, (AxisServiceGroup)this.axisService.getParent());
        this.serviceContext = sgc.getServiceContext(this.axisService);
    }

    public ServiceClient(ConfigurationContext configContext, Definition wsdl4jDefinition, QName wsdlServiceName, String portName) throws AxisFault {
        this.initializeTransports(configContext);
        try {
            this.axisConfig = this.configContext.getAxisConfiguration();
            this.axisService = AxisService.createClientSideAxisService(wsdl4jDefinition, wsdlServiceName, portName, this.options);
            if (this.axisConfig.getService(this.axisService.getName()) == null) {
                this.axisConfig.addService(this.axisService);
            }
            ServiceGroupContext sgc = new ServiceGroupContext(this.configContext, (AxisServiceGroup)this.axisService.getParent());
            this.serviceContext = sgc.getServiceContext(this.axisService);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public ServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        this.initializeTransports(configContext);
        try {
            this.axisConfig = this.configContext.getAxisConfiguration();
            this.axisService = AxisService.createClientSideAxisService(wsdlURL, wsdlServiceName, portName, this.options);
            if (this.axisConfig.getService(this.axisService.getName()) != null) {
                throw new AxisFault(Messages.getMessage("twoservicecannothavesamename", this.axisService.getName()));
            }
            this.axisConfig.addService(this.axisService);
            ServiceGroupContext sgc = new ServiceGroupContext(this.configContext, (AxisServiceGroup)this.axisService.getParent());
            this.serviceContext = sgc.getServiceContext(this.axisService);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    private void initializeTransports(ConfigurationContext configContext) throws AxisFault {
        if (configContext != null) {
            this.configContext = configContext;
            ListenerManager trsManager = configContext.getListenerManager();
            if (trsManager == null) {
                trsManager = new ListenerManager();
                trsManager.init(this.configContext);
            }
        } else {
            this.configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            ListenerManager trsManager = new ListenerManager();
            trsManager.init(this.configContext);
        }
    }

    public ServiceClient() throws AxisFault {
        this(null, null);
    }

    private AxisService createAnonymousService() {
        AxisService axisService = new AxisService(ANON_SERVICE);
        RobustOutOnlyAxisOperation robustoutoonlyOperation = new RobustOutOnlyAxisOperation(ANON_ROBUST_OUT_ONLY_OP);
        axisService.addOperation(robustoutoonlyOperation);
        OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ANON_OUT_ONLY_OP);
        axisService.addOperation(outOnlyOperation);
        OutInAxisOperation outInOperation = new OutInAxisOperation(ANON_OUT_IN_OP);
        axisService.addOperation(outInOperation);
        return axisService;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOverrideOptions(Options overrideOptions) {
        this.overrideOptions = overrideOptions;
    }

    public Options getOverrideOptions() {
        return this.overrideOptions;
    }

    public void engageModule(QName moduleName) throws AxisFault {
        this.axisService.engageModule(this.axisConfig.getModule(moduleName), this.axisConfig);
    }

    public void disEngageModule(QName moduleName) {
        AxisModule module = this.axisConfig.getModule(moduleName);
        if (module != null) {
            this.axisService.disEngageModule(module);
        }
    }

    public void addHeader(OMElement header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void addStringHeader(QName headerName, String headerText) {
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(headerName, null);
        omElement.setText(headerText);
        this.addHeader(omElement);
    }

    public void sendRobust(OMElement elem) throws AxisFault {
        this.sendRobust(ANON_ROBUST_OUT_ONLY_OP, elem);
    }

    public void sendRobust(QName operation, OMElement elem) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
    }

    public void fireAndForget(OMElement elem) throws AxisFault {
        this.fireAndForget(ANON_OUT_ONLY_OP, elem);
    }

    public void fireAndForget(QName operation, OMElement elem) throws AxisFault {
        OperationClient mepClient = this.createClient(operation);
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public OMElement sendReceive(OMElement elem) throws AxisFault {
        return this.sendReceive(ANON_OUT_IN_OP, elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement sendReceive(QName operation, OMElement elem) throws AxisFault {
        if (this.options.isUseSeparateListener()) {
            long timeout;
            SyncCallBack callback = new SyncCallBack();
            this.sendReceiveNonBlocking(operation, elem, callback);
            long waitTime = timeout = this.options.getTimeOutInMilliSeconds();
            long startTime = System.currentTimeMillis();
            SyncCallBack syncCallBack = callback;
            synchronized (syncCallBack) {
                while (!callback.isComplete() && waitTime >= 0L) {
                    try {
                        callback.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waitTime = timeout - (System.currentTimeMillis() - startTime);
                }
            }
            if (callback.envelope != null) {
                callback.envelope.build();
                return callback.envelope.getBody().getFirstElement();
            }
            if (callback.error instanceof AxisFault) {
                throw (AxisFault)callback.error;
            }
            if (callback.error != null) {
                throw new AxisFault(callback.error);
            }
            if (!callback.isComplete()) {
                throw new AxisFault(Messages.getMessage("responseTimeOut"));
            }
            throw new AxisFault("Callback completed but there was no envelope or error");
        }
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
        MessageContext response = mepClient.getMessageContext("In");
        return response.getEnvelope().getBody().getFirstElement();
    }

    public void sendReceiveNonBlocking(OMElement elem, Callback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, Callback callback) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        if (this.options.isUseSeparateListener()) {
            if (this.callbackReceiver == null) {
                this.callbackReceiver = new CallbackReceiver();
            }
            this.axisService.getOperation(operation).setMessageReceiver(this.callbackReceiver);
        }
        mepClient.execute(false);
    }

    public OperationClient createClient(QName operation) throws AxisFault {
        AxisOperation axisOp = this.axisService.getOperation(operation);
        if (axisOp == null) {
            throw new AxisFault(Messages.getMessage("operationnotfound", operation.getLocalPart()));
        }
        OperationClient oc = axisOp.createClient(this.serviceContext, this.options);
        if (this.overrideOptions != null) {
            this.overrideOptions.setParent(oc.getOptions());
            oc.setOptions(this.overrideOptions);
        }
        return oc;
    }

    public void finalizeInvoke() throws AxisFault {
        this.configContext.getListenerManager().stop();
    }

    private SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.options.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    private void fillSoapEnvelope(MessageContext mc, OMElement elem) throws AxisFault {
        mc.setServiceContext(this.serviceContext);
        SOAPFactory sf = this.getSOAPFactory();
        SOAPEnvelope se = sf.getDefaultEnvelope();
        if (elem != null) {
            se.getBody().addChild((OMNode)elem);
        }
        if (this.headers != null) {
            SOAPHeader sh = se.getHeader();
            for (int i = 0; i < this.headers.size(); ++i) {
                sh.addChild((OMNode)((OMElement)this.headers.get(i)));
            }
        }
        mc.setEnvelope(se);
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        return this.serviceContext.getMyEPR(transport);
    }

    public EndpointReference getTargetEPR() {
        return this.serviceContext.getTargetEPR();
    }

    public void setTargetEPR(EndpointReference targetEpr) {
        this.serviceContext.setTargetEPR(targetEpr);
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    private class SyncCallBack
    extends Callback {
        private SOAPEnvelope envelope;
        private MessageContext msgctx;
        private Exception error;

        private SyncCallBack() {
        }

        public void onComplete(AsyncResult result) {
            this.envelope = result.getResponseEnvelope();
            this.msgctx = result.getResponseMessageContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComplete(boolean complete) {
            super.setComplete(complete);
            SyncCallBack syncCallBack = this;
            synchronized (syncCallBack) {
                this.notify();
            }
        }

        public void onError(Exception e) {
            this.error = e;
        }

        public MessageContext getMsgctx() {
            return this.msgctx;
        }
    }
}

