/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import aws.smithy.kotlin.runtime.util.OperatingSystem;
import aws.smithy.kotlin.runtime.util.OsFamily;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000f\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0017\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"", "isAndroid", "()Z", "", "value", "normalize", "(Ljava/lang/String;)Ljava/lang/String;", "Laws/smithy/kotlin/runtime/util/OperatingSystem;", "getOsInfo", "()Laws/smithy/kotlin/runtime/util/OperatingSystem;", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nPlatformJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformJVM.kt\naws/smithy/kotlin/runtime/util/PlatformJVMKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class PlatformJVMKt {
    private static final boolean isAndroid() {
        boolean bl;
        try {
            Class.forName("android.os.Build");
            bl = true;
        }
        catch (ClassNotFoundException ex) {
            bl = false;
        }
        return bl;
    }

    private static final String normalize(String value) {
        CharSequence charSequence = value;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string = charSequence.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        charSequence = string;
        Regex regex = new Regex("[^a-z0-9+]");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    private static final OperatingSystem getOsInfo() {
        Object object;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String name = PlatformJVMKt.normalize(string);
        OsFamily family = PlatformJVMKt.isAndroid() ? OsFamily.Android : (StringsKt.contains$default((CharSequence)name, (CharSequence)"windows", (boolean)false, (int)2, null) ? OsFamily.Windows : (StringsKt.contains$default((CharSequence)name, (CharSequence)"linux", (boolean)false, (int)2, null) ? OsFamily.Linux : (StringsKt.contains$default((CharSequence)name, (CharSequence)"macosx", (boolean)false, (int)2, null) ? OsFamily.MacOs : OsFamily.Unknown)));
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)System.getProperty("os.version"));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String version = (String)(Result.isFailure-impl((Object)object) ? null : object);
        return new OperatingSystem(family, version);
    }

    public static final /* synthetic */ OperatingSystem access$getOsInfo() {
        return PlatformJVMKt.getOsInfo();
    }

    public static final /* synthetic */ boolean access$isAndroid() {
        return PlatformJVMKt.isAndroid();
    }
}

