/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.time;

import aws.smithy.kotlin.runtime.time.InstantJVMKt;
import aws.smithy.kotlin.runtime.time.InstantKt;
import aws.smithy.kotlin.runtime.time.ParsedDatetime;
import aws.smithy.kotlin.runtime.time.ParsersKt;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013H\u0086\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013H\u0086\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u0011\u0010&\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010(\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000b\u00a8\u0006*"}, d2={"Laws/smithy/kotlin/runtime/time/Instant;", "", "Ljava/time/Instant;", "value", "<init>", "(Ljava/time/Instant;)V", "other", "", "compareTo", "(Laws/smithy/kotlin/runtime/time/Instant;)I", "hashCode", "()I", "", "", "equals", "(Ljava/lang/Object;)Z", "", "toString", "()Ljava/lang/String;", "Lkotlin/time/Duration;", "duration", "plus-LRDsOJo", "(J)Laws/smithy/kotlin/runtime/time/Instant;", "plus", "minus-LRDsOJo", "minus", "minus-5sfh64U", "(Laws/smithy/kotlin/runtime/time/Instant;)J", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "fmt", "format", "(Laws/smithy/kotlin/runtime/time/TimestampFormat;)Ljava/lang/String;", "Ljava/time/Instant;", "getValue$runtime_core", "()Ljava/time/Instant;", "", "getEpochSeconds", "()J", "epochSeconds", "getNanosecondsOfSecond", "nanosecondsOfSecond", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nInstantJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstantJVM.kt\naws/smithy/kotlin/runtime/time/Instant\n+ 2 Duration.kt\nkotlin/time/Duration\n*L\n1#1,242:1\n548#2:243\n*S KotlinDebug\n*F\n+ 1 InstantJVM.kt\naws/smithy/kotlin/runtime/time/Instant\n*L\n52#1:243\n*E\n"})
public final class Instant
implements Comparable<Instant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.Instant value;
    @NotNull
    private static final DateTimeFormatter RFC_5322_FIXED_DATE_TIME = InstantJVMKt.access$buildRfc5322Formatter();
    private static final ZoneId utcZone = ZoneId.of("Z");
    @NotNull
    private static final DateTimeFormatter ISO_8601_CONDENSED;
    @NotNull
    private static final DateTimeFormatter ISO_8601_CONDENSED_DATE;
    @NotNull
    private static final Instant MIN_VALUE;
    @NotNull
    private static final Instant MAX_VALUE;

    public Instant(@NotNull java.time.Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final java.time.Instant getValue$runtime_core() {
        return this.value;
    }

    public final long getEpochSeconds() {
        return this.value.getEpochSecond();
    }

    public final int getNanosecondsOfSecond() {
        return this.value.getNano();
    }

    @Override
    public int compareTo(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Instant && Intrinsics.areEqual((Object)this.value, (Object)((Instant)other).value);
    }

    @NotNull
    public String toString() {
        return this.format(TimestampFormat.ISO_8601);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Instant plus-LRDsOJo(long duration) {
        void nanoseconds;
        long arg0$iv = duration;
        boolean bl = false;
        int n = Duration.getNanosecondsComponent-impl((long)arg0$iv);
        long seconds = Duration.getInWholeSeconds-impl((long)arg0$iv);
        boolean bl2 = false;
        return Companion.fromEpochSeconds(this.getEpochSeconds() + seconds, this.getNanosecondsOfSecond() + nanoseconds);
    }

    @NotNull
    public final Instant minus-LRDsOJo(long duration) {
        return this.plus-LRDsOJo(Duration.unaryMinus-UwyO8pc((long)duration));
    }

    public final long minus-5sfh64U(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.time.Duration duration = java.time.Duration.between(other.value, this.value);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        java.time.Duration duration2 = duration;
        return Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
    }

    @NotNull
    public final String format(@NotNull TimestampFormat fmt) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)fmt), (String)"fmt");
        switch (WhenMappings.$EnumSwitchMapping$0[fmt.ordinal()]) {
            case 1: {
                String string2 = DateTimeFormatter.ISO_INSTANT.format(this.value.truncatedTo(ChronoUnit.MICROS));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                break;
            }
            case 2: {
                String string3 = ISO_8601_CONDENSED.format(this.value);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                break;
            }
            case 3: {
                String string4 = ISO_8601_CONDENSED_DATE.format(this.value);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                break;
            }
            case 4: {
                String string5 = DateTimeFormatter.ISO_INSTANT.format(this.value);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                break;
            }
            case 5: {
                String string6 = RFC_5322_FIXED_DATE_TIME.format(ZonedDateTime.ofInstant(this.value, ZoneOffset.UTC));
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                break;
            }
            case 6: {
                StringBuffer sb = new StringBuffer(String.valueOf(this.getEpochSeconds()));
                if (this.getNanosecondsOfSecond() > 0) {
                    sb.append(".");
                    String ns = String.valueOf(this.getNanosecondsOfSecond());
                    String leadingZeros = StringsKt.repeat((CharSequence)"0", (int)(9 - ns.length()));
                    sb.append(leadingZeros);
                    sb.append(ns);
                    char[] cArray = new char[]{'0'};
                    string = ((Object)StringsKt.trimEnd((CharSequence)sb, (char[])cArray)).toString();
                    break;
                }
                String string7 = sb.toString();
                Intrinsics.checkNotNull((Object)string7);
                string = string7;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(utcZone);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        ISO_8601_CONDENSED = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(utcZone);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"withZone(...)");
        ISO_8601_CONDENSED_DATE = dateTimeFormatter2;
        MIN_VALUE = InstantKt.fromEpochMilliseconds(Companion, kotlinx.datetime.Instant.Companion.getDISTANT_PAST().toEpochMilliseconds());
        MAX_VALUE = InstantKt.fromEpochMilliseconds(Companion, kotlinx.datetime.Instant.Companion.getDISTANT_FUTURE().toEpochMilliseconds());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u001f\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\bJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0014R\u0017\u0010\u001b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001c\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006 "}, d2={"Laws/smithy/kotlin/runtime/time/Instant$Companion;", "", "<init>", "()V", "", "ts", "Laws/smithy/kotlin/runtime/time/Instant;", "fromIso8601", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/time/Instant;", "fromRfc5322", "", "seconds", "", "ns", "fromEpochSeconds", "(JI)Laws/smithy/kotlin/runtime/time/Instant;", "now", "()Laws/smithy/kotlin/runtime/time/Instant;", "Ljava/time/format/DateTimeFormatter;", "RFC_5322_FIXED_DATE_TIME", "Ljava/time/format/DateTimeFormatter;", "Ljava/time/ZoneId;", "kotlin.jvm.PlatformType", "utcZone", "Ljava/time/ZoneId;", "ISO_8601_CONDENSED", "ISO_8601_CONDENSED_DATE", "MIN_VALUE", "Laws/smithy/kotlin/runtime/time/Instant;", "getMIN_VALUE", "MAX_VALUE", "getMAX_VALUE", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Instant fromIso8601(@NotNull String ts) {
            Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
            ParsedDatetime parsed = ParsersKt.parseIso8601(ts);
            return InstantJVMKt.access$fromParsedDateTime(parsed);
        }

        @NotNull
        public final Instant fromRfc5322(@NotNull String ts) {
            Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
            ParsedDatetime parsed = ParsersKt.parseRfc5322(ts);
            return InstantJVMKt.access$fromParsedDateTime(parsed);
        }

        @NotNull
        public final Instant fromEpochSeconds(long seconds, int ns) {
            java.time.Instant instant = java.time.Instant.ofEpochSecond(seconds, ns);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
            return new Instant(instant);
        }

        public static /* synthetic */ Instant fromEpochSeconds$default(Companion companion, long l, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromEpochSeconds(l, n);
        }

        @NotNull
        public final Instant fromEpochSeconds(@NotNull String ts) {
            Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
            return ParsersKt.parseEpoch(ts);
        }

        @NotNull
        public final Instant now() {
            java.time.Instant instant = java.time.Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return new Instant(instant);
        }

        @NotNull
        public final Instant getMIN_VALUE() {
            return MIN_VALUE;
        }

        @NotNull
        public final Instant getMAX_VALUE() {
            return MAX_VALUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            try {
                nArray[TimestampFormat.ISO_8601.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_CONDENSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_CONDENSED_DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_FULL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.RFC_5322.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.EPOCH_SECONDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

