/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net.url;

import aws.smithy.kotlin.runtime.text.encoding.Encodable;
import aws.smithy.kotlin.runtime.text.encoding.Encoding;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0018\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0018\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0019\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001e"}, d2={"Laws/smithy/kotlin/runtime/net/url/UserInfo;", "", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "userName", "password", "<init>", "(Laws/smithy/kotlin/runtime/text/encoding/Encodable;Laws/smithy/kotlin/runtime/text/encoding/Encodable;)V", "Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "toBuilder", "()Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "getUserName", "()Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "getPassword", "isEmpty", "Z", "()Z", "isNotEmpty", "Companion", "Builder", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nUserInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserInfo.kt\naws/smithy/kotlin/runtime/net/url/UserInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class UserInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Encodable userName;
    @NotNull
    private final Encodable password;
    private final boolean isEmpty;
    private final boolean isNotEmpty;
    @NotNull
    private static final UserInfo Empty = new UserInfo(Encodable.Companion.getEmpty(), Encodable.Companion.getEmpty());

    private UserInfo(Encodable userName, Encodable password) {
        this.userName = userName;
        this.password = password;
        if (!(this.password.isEmpty() || this.userName.isNotEmpty())) {
            boolean bl = false;
            String string = "Cannot have a password without a user name";
            throw new IllegalArgumentException(string.toString());
        }
        this.isEmpty = this.userName.isEmpty() && this.password.isEmpty();
        this.isNotEmpty = !this.isEmpty;
    }

    @NotNull
    public final Encodable getUserName() {
        return this.userName;
    }

    @NotNull
    public final Encodable getPassword() {
        return this.password;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final boolean isNotEmpty() {
        return this.isNotEmpty;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UserInfo cfr_ignored_0 = (UserInfo)other;
        if (!Intrinsics.areEqual((Object)this.userName, (Object)((UserInfo)other).userName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.password, (Object)((UserInfo)other).password);
    }

    public int hashCode() {
        int result = this.userName.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.userName.isEmpty() ? "" : (this.password.isEmpty() ? this.userName.getEncoded() : this.userName.getEncoded() + ':' + this.password.getEncoded());
    }

    public /* synthetic */ UserInfo(Encodable userName, Encodable password, DefaultConstructorMarker $constructor_marker) {
        this(userName, password);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000bJ+\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0005J\u0015\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR$\u0010!\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\u000bR$\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010\u000bR\u0016\u0010%\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\u001cR$\u0010(\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010\u000bR$\u0010+\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010\u000b\u00a8\u0006,"}, d2={"Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "userInfo", "<init>", "(Laws/smithy/kotlin/runtime/net/url/UserInfo;)V", "()V", "", "decoded", "", "parseDecoded$runtime_core", "(Ljava/lang/String;)V", "parseDecoded", "encoded", "parseEncoded$runtime_core", "parseEncoded", "text", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "toEncodable", "parse", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "build", "()Laws/smithy/kotlin/runtime/net/url/UserInfo;", "other", "copyFrom", "(Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;)V", "userName", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "value", "getDecodedUserName", "()Ljava/lang/String;", "setDecodedUserName", "decodedUserName", "getEncodedUserName", "setEncodedUserName", "encodedUserName", "password", "getDecodedPassword", "setDecodedPassword", "decodedPassword", "getEncodedPassword", "setEncodedPassword", "encodedPassword", "runtime-core"})
    public static final class Builder {
        @NotNull
        private Encodable userName;
        @NotNull
        private Encodable password;

        public Builder(@Nullable UserInfo userInfo) {
            Object object;
            Object object2 = userInfo;
            if (object2 == null || (object2 = ((UserInfo)object2).getUserName()) == null) {
                object2 = this.userName = Encodable.Companion.getEmpty();
            }
            if ((object = userInfo) == null || (object = ((UserInfo)object).getPassword()) == null) {
                object = Encodable.Companion.getEmpty();
            }
            this.password = object;
        }

        public Builder() {
            this(null);
        }

        @NotNull
        public final String getDecodedUserName() {
            return this.userName.getDecoded();
        }

        public final void setDecodedUserName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.userName = PercentEncoding.Companion.getUserInfo().encodableFromDecoded(value);
        }

        @NotNull
        public final String getEncodedUserName() {
            return this.userName.getEncoded();
        }

        public final void setEncodedUserName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.userName = PercentEncoding.Companion.getUserInfo().encodableFromEncoded(value);
        }

        @NotNull
        public final String getDecodedPassword() {
            return this.password.getDecoded();
        }

        public final void setDecodedPassword(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.password = PercentEncoding.Companion.getUserInfo().encodableFromDecoded(value);
        }

        @NotNull
        public final String getEncodedPassword() {
            return this.password.getEncoded();
        }

        public final void setEncodedPassword(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.password = PercentEncoding.Companion.getUserInfo().encodableFromEncoded(value);
        }

        public final void parseDecoded$runtime_core(@NotNull String decoded) {
            Intrinsics.checkNotNullParameter((Object)decoded, (String)"decoded");
            this.parse(decoded, (Function1<? super String, Encodable>)((Function1)new Function1<String, Encodable>((Object)PercentEncoding.Companion.getUserInfo()){

                public final Encodable invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Encoding)this.receiver).encodableFromDecoded(p0);
                }
            }));
        }

        public final void parseEncoded$runtime_core(@NotNull String encoded) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            this.parse(encoded, (Function1<? super String, Encodable>)((Function1)new Function1<String, Encodable>((Object)PercentEncoding.Companion.getUserInfo()){

                public final Encodable invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Encoding)this.receiver).encodableFromEncoded(p0);
                }
            }));
        }

        private final void parse(String text, Function1<? super String, Encodable> toEncodable) {
            if (((CharSequence)text).length() == 0) {
                this.userName = Encodable.Companion.getEmpty();
                this.password = Encodable.Companion.getEmpty();
            } else {
                Encodable encodable;
                String[] stringArray = new String[]{":"};
                List parts = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                this.userName = (Encodable)toEncodable.invoke(parts.get(0));
                switch (parts.size()) {
                    case 1: {
                        encodable = Encodable.Companion.getEmpty();
                        break;
                    }
                    case 2: {
                        encodable = (Encodable)toEncodable.invoke(parts.get(1));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid user info string " + text);
                    }
                }
                this.password = encodable;
            }
        }

        @NotNull
        public final UserInfo build() {
            return new UserInfo(this.userName, this.password, null);
        }

        public final void copyFrom(@NotNull UserInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.userName = other.getUserName();
            this.password = other.getPassword();
        }

        public final void copyFrom(@NotNull Builder other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.userName = other.userName;
            this.password = other.password;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/net/url/UserInfo$Companion;", "", "<init>", "()V", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "", "Lkotlin/ExtensionFunctionType;", "block", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "invoke", "(Lkotlin/jvm/functions/Function1;)Laws/smithy/kotlin/runtime/net/url/UserInfo;", "", "decoded", "parseDecoded", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/net/url/UserInfo;", "encoded", "parseEncoded", "Empty", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "getEmpty", "()Laws/smithy/kotlin/runtime/net/url/UserInfo;", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UserInfo getEmpty() {
            return Empty;
        }

        @NotNull
        public final UserInfo invoke(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.build();
        }

        @NotNull
        public final UserInfo parseDecoded(@NotNull String decoded) {
            Intrinsics.checkNotNullParameter((Object)decoded, (String)"decoded");
            return Companion.invoke((Function1<? super Builder, Unit>)((Function1)arg_0 -> Companion.parseDecoded$lambda$0(decoded, arg_0)));
        }

        @NotNull
        public final UserInfo parseEncoded(@NotNull String encoded) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            return Companion.invoke((Function1<? super Builder, Unit>)((Function1)arg_0 -> Companion.parseEncoded$lambda$1(encoded, arg_0)));
        }

        private static final Unit parseDecoded$lambda$0(String $decoded, Builder $this$UserInfo) {
            Intrinsics.checkNotNullParameter((Object)$this$UserInfo, (String)"$this$UserInfo");
            $this$UserInfo.parseDecoded$runtime_core($decoded);
            return Unit.INSTANCE;
        }

        private static final Unit parseEncoded$lambda$1(String $encoded, Builder $this$UserInfo) {
            Intrinsics.checkNotNullParameter((Object)$this$UserInfo, (String)"$this$UserInfo");
            $this$UserInfo.parseEncoded$runtime_core($encoded);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

