/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/net/Scheme;", "", "", "protocolName", "", "defaultPort", "<init>", "(Ljava/lang/String;I)V", "component1", "()Ljava/lang/String;", "component2", "()I", "copy", "(Ljava/lang/String;I)Laws/smithy/kotlin/runtime/net/Scheme;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getProtocolName", "I", "getDefaultPort", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nScheme.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scheme.kt\naws/smithy/kotlin/runtime/net/Scheme\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1208#2,2:60\n1236#2,4:62\n*S KotlinDebug\n*F\n+ 1 Scheme.kt\naws/smithy/kotlin/runtime/net/Scheme\n*L\n41#1:60,2\n41#1:62,4\n*E\n"})
public final class Scheme {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String protocolName;
    private final int defaultPort;
    @NotNull
    private static final Scheme HTTPS;
    @NotNull
    private static final Scheme HTTP;
    @NotNull
    private static final Scheme WS;
    @NotNull
    private static final Scheme WSS;
    @NotNull
    private static final Map<String, Scheme> byName;

    public Scheme(@NotNull String protocolName, int defaultPort) {
        Intrinsics.checkNotNullParameter((Object)protocolName, (String)"protocolName");
        this.protocolName = protocolName;
        this.defaultPort = defaultPort;
    }

    @NotNull
    public final String getProtocolName() {
        return this.protocolName;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @NotNull
    public final String component1() {
        return this.protocolName;
    }

    public final int component2() {
        return this.defaultPort;
    }

    @NotNull
    public final Scheme copy(@NotNull String protocolName, int defaultPort) {
        Intrinsics.checkNotNullParameter((Object)protocolName, (String)"protocolName");
        return new Scheme(protocolName, defaultPort);
    }

    public static /* synthetic */ Scheme copy$default(Scheme scheme, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = scheme.protocolName;
        }
        if ((n2 & 2) != 0) {
            n = scheme.defaultPort;
        }
        return scheme.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "Scheme(protocolName=" + this.protocolName + ", defaultPort=" + this.defaultPort + ')';
    }

    public int hashCode() {
        int result = this.protocolName.hashCode();
        result = result * 31 + Integer.hashCode(this.defaultPort);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Scheme)) {
            return false;
        }
        Scheme scheme = (Scheme)other;
        if (!Intrinsics.areEqual((Object)this.protocolName, (Object)scheme.protocolName)) {
            return false;
        }
        return this.defaultPort == scheme.defaultPort;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        HTTPS = new Scheme("https", 443);
        HTTP = new Scheme("http", 80);
        WS = new Scheme("ws", 80);
        WSS = new Scheme("wss", 443);
        Object[] objectArray = new Scheme[]{HTTP, HTTPS, WS, WSS};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Scheme scheme = (Scheme)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.protocolName, element$iv$iv);
        }
        byName = destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR#\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Laws/smithy/kotlin/runtime/net/Scheme$Companion;", "", "<init>", "()V", "", "scheme", "Laws/smithy/kotlin/runtime/net/Scheme;", "parse", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/net/Scheme;", "HTTPS", "Laws/smithy/kotlin/runtime/net/Scheme;", "getHTTPS", "()Laws/smithy/kotlin/runtime/net/Scheme;", "HTTP", "getHTTP", "WS", "getWS", "WSS", "getWSS", "", "byName", "Ljava/util/Map;", "getByName", "()Ljava/util/Map;", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Scheme getHTTPS() {
            return HTTPS;
        }

        @NotNull
        public final Scheme getHTTP() {
            return HTTP;
        }

        @NotNull
        public final Scheme getWS() {
            return WS;
        }

        @NotNull
        public final Scheme getWSS() {
            return WSS;
        }

        @NotNull
        public final Map<String, Scheme> getByName() {
            return byName;
        }

        @NotNull
        public final Scheme parse(@NotNull String scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Map<String, Scheme> map = this.getByName();
            String string = scheme.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Scheme scheme2 = map.get(string);
            if (scheme2 == null) {
                scheme2 = new Scheme(scheme, -1);
            }
            return scheme2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

