/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.net.IpAddr;
import aws.smithy.kotlin.runtime.net.IpV6Addr;
import aws.smithy.kotlin.runtime.net.TextKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0087\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\u001bR\u0014\u0010 \u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!R\u0014\u0010$\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000e\u00a8\u0006&"}, d2={"Laws/smithy/kotlin/runtime/net/IpV4Addr;", "Laws/smithy/kotlin/runtime/net/IpAddr;", "", "octets", "<init>", "([B)V", "Lkotlin/UByte;", "a", "b", "c", "d", "(BBBBLkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "toString", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Laws/smithy/kotlin/runtime/net/IpV6Addr;", "toMappedIpv6", "()Laws/smithy/kotlin/runtime/net/IpV6Addr;", "component1", "()[B", "copy", "([B)Laws/smithy/kotlin/runtime/net/IpV4Addr;", "[B", "getOctets", "isLoopBack", "()Z", "isUnspecified", "getAddress", "address", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nIpV4Addr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpV4Addr.kt\naws/smithy/kotlin/runtime/net/IpV4Addr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class IpV4Addr
extends IpAddr {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] octets;
    @NotNull
    private static final IpV4Addr LOCALHOST = new IpV4Addr(127, 0, 0, 1, null);
    @NotNull
    private static final IpV4Addr UNSPECIFIED = new IpV4Addr(0, 0, 0, 0, null);

    public IpV4Addr(@NotNull byte[] octets) {
        Intrinsics.checkNotNullParameter((Object)octets, (String)"octets");
        super(null);
        this.octets = octets;
        if (!(this.getOctets().length == 4)) {
            boolean bl = false;
            String string = "Invalid IPv4 repr: " + this.getOctets() + "; expected 4 bytes";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public byte[] getOctets() {
        return this.octets;
    }

    private IpV4Addr(byte a, byte b, byte c, byte d) {
        byte[] byArray = new byte[]{a, b, c, d};
        this(byArray);
    }

    @Override
    public boolean isLoopBack() {
        return this.getOctets()[0] == 127;
    }

    @Override
    public boolean isUnspecified() {
        return Intrinsics.areEqual((Object)this, (Object)UNSPECIFIED);
    }

    @Override
    @NotNull
    public String getAddress() {
        return ArraysKt.joinToString$default((byte[])this.getOctets(), (CharSequence)".", null, null, (int)0, null, IpV4Addr::_get_address_$lambda$1, (int)30, null);
    }

    @NotNull
    public String toString() {
        return this.getAddress();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IpV4Addr cfr_ignored_0 = (IpV4Addr)other;
        return Arrays.equals(this.getOctets(), ((IpV4Addr)other).getOctets());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    @NotNull
    public final IpV6Addr toMappedIpv6() {
        byte[] v6Octets = new byte[16];
        v6Octets[10] = -1;
        v6Octets[11] = -1;
        v6Octets[12] = this.getOctets()[0];
        v6Octets[13] = this.getOctets()[1];
        v6Octets[14] = this.getOctets()[2];
        v6Octets[15] = this.getOctets()[3];
        return new IpV6Addr(v6Octets, null, 2, null);
    }

    @NotNull
    public final byte[] component1() {
        return this.octets;
    }

    @NotNull
    public final IpV4Addr copy(@NotNull byte[] octets) {
        Intrinsics.checkNotNullParameter((Object)octets, (String)"octets");
        return new IpV4Addr(octets);
    }

    public static /* synthetic */ IpV4Addr copy$default(IpV4Addr ipV4Addr, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = ipV4Addr.octets;
        }
        return ipV4Addr.copy(byArray);
    }

    private static final CharSequence _get_address_$lambda$1(byte it) {
        return UByte.toString-impl((byte)UByte.constructor-impl((byte)it));
    }

    public /* synthetic */ IpV4Addr(byte a, byte b, byte c, byte d, DefaultConstructorMarker $constructor_marker) {
        this(a, b, c, d);
    }

    @InternalApi
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Laws/smithy/kotlin/runtime/net/IpV4Addr$Companion;", "", "<init>", "()V", "", "s", "Laws/smithy/kotlin/runtime/net/IpV4Addr;", "parse", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/net/IpV4Addr;", "LOCALHOST", "Laws/smithy/kotlin/runtime/net/IpV4Addr;", "getLOCALHOST", "()Laws/smithy/kotlin/runtime/net/IpV4Addr;", "UNSPECIFIED", "getUNSPECIFIED", "runtime-core"})
    @SourceDebugExtension(value={"SMAP\nIpV4Addr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpV4Addr.kt\naws/smithy/kotlin/runtime/net/IpV4Addr$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IpV4Addr getLOCALHOST() {
            return LOCALHOST;
        }

        @NotNull
        public final IpV4Addr getUNSPECIFIED() {
            return UNSPECIFIED;
        }

        @NotNull
        public final IpV4Addr parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            IpV4Addr ipV4Addr = TextKt.parseIpv4OrNull(s);
            if (ipV4Addr == null) {
                boolean bl = false;
                String string = "Invalid Ipv4 address: " + s;
                throw new IllegalArgumentException(string.toString());
            }
            return ipV4Addr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

