/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io.internal;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0010H\u0096\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/io/internal/SdkSourceObserver;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "delegate", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkSource;)V", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "sink", "", "limit", "read", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;J)J", "", "data", "", "offset", "length", "", "observe", "([BII)V", "close", "()V", "Laws/smithy/kotlin/runtime/io/SdkSource;", "Lokio/Buffer$UnsafeCursor;", "cursor", "Lokio/Buffer$UnsafeCursor;", "runtime-core"})
public abstract class SdkSourceObserver
implements SdkSource {
    @NotNull
    private final SdkSource delegate;
    @NotNull
    private final Buffer.UnsafeCursor cursor;

    public SdkSourceObserver(@NotNull SdkSource delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.cursor = new Buffer.UnsafeCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(@NotNull SdkBuffer sink, long limit) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Buffer okioBuffer = ConvertKt.toOkio(sink);
        long rc = this.delegate.read(sink, limit);
        if (rc <= 0L) {
            return rc;
        }
        okioBuffer.readUnsafe(this.cursor);
        try {
            int toObserve;
            int length = this.cursor.seek(sink.getSize() - rc);
            for (long remaining = rc; remaining > 0L && length > 0; remaining -= (long)toObserve) {
                byte[] data;
                toObserve = Math.min(length, (int)remaining);
                if (this.cursor.data == null) {
                    byte[] cfr_ignored_0 = this.cursor.data;
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this.observe(data, this.cursor.start, toObserve);
                length = this.cursor.next();
            }
        }
        finally {
            this.cursor.close();
        }
        return rc;
    }

    public abstract void observe(@NotNull byte[] var1, int var2, int var3);

    @Override
    public void close() {
        this.delegate.close();
    }
}

