/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.hashing;

import aws.smithy.kotlin.runtime.hashing.EcdsaJVMKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\b\n\u0002\u0010\u0012\n\u0002\b\b\u001a\u001d\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"", "key", "message", "ecdsaSecp256r1Rs", "([B[B)[B", "derSignature", "parseDerSignature", "([B)[B", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nEcdsa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ecdsa.kt\naws/smithy/kotlin/runtime/hashing/EcdsaKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,46:1\n3685#2,10:47\n3685#2,10:57\n*S KotlinDebug\n*F\n+ 1 Ecdsa.kt\naws/smithy/kotlin/runtime/hashing/EcdsaKt\n*L\n38#1:47,10\n39#1:57,10\n*E\n"})
public final class EcdsaKt {
    @NotNull
    public static final byte[] ecdsaSecp256r1Rs(@NotNull byte[] key, @NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] derSignature = EcdsaJVMKt.ecdsaSecp256r1(key, message);
        return EcdsaKt.parseDerSignature(derSignature);
    }

    private static final byte[] parseDerSignature(byte[] derSignature) {
        int index = 2;
        int n = ++index;
        int rLength = derSignature[n] & 0xFF;
        byte[] r = ArraysKt.sliceArray((byte[])derSignature, (IntRange)RangesKt.until((int)(++index), (int)(index + rLength)));
        index += rLength;
        int n2 = ++index;
        int sLength = derSignature[n2] & 0xFF;
        byte[] s = ArraysKt.sliceArray((byte[])derSignature, (IntRange)RangesKt.until((int)(++index), (int)(index + sLength)));
        byte[] $this$dropWhile$iv = r;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList<Byte> list$iv = new ArrayList<Byte>();
        int n3 = $this$dropWhile$iv.length;
        for (int i = 0; i < n3; ++i) {
            byte item$iv = $this$dropWhile$iv[i];
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            byte it = item$iv;
            boolean bl = false;
            if (it == 0) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        byte[] rFixed = CollectionsKt.toByteArray((Collection)list$iv);
        byte[] $this$dropWhile$iv2 = s;
        boolean $i$f$dropWhile2 = false;
        boolean yielding$iv2 = false;
        ArrayList<Byte> list$iv2 = new ArrayList<Byte>();
        for (byte item$iv : $this$dropWhile$iv2) {
            if (yielding$iv2) {
                list$iv2.add(item$iv);
                continue;
            }
            byte it = item$iv;
            boolean bl = false;
            if (it == 0) continue;
            list$iv2.add(item$iv);
            yielding$iv2 = true;
        }
        byte[] sFixed = CollectionsKt.toByteArray((Collection)list$iv2);
        byte[] rPadded = rFixed.length < 32 ? ArraysKt.plus((byte[])new byte[32 - rFixed.length], (byte[])rFixed) : rFixed;
        byte[] sPadded = sFixed.length < 32 ? ArraysKt.plus((byte[])new byte[32 - sFixed.length], (byte[])sFixed) : sFixed;
        return ArraysKt.plus((byte[])rPadded, (byte[])sPadded);
    }
}

