/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.collections.views;

import aws.smithy.kotlin.runtime.collections.views.CollectionView;
import aws.smithy.kotlin.runtime.collections.views.ConvertersKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\b\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00032\b\u0012\u0004\u0012\u00028\u00010\u0004B=\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0012J\u001d\u0010\u001a\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0012J\u0017\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u000eR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR \u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001d\u00a8\u0006\u001e"}, d2={"Laws/smithy/kotlin/runtime/collections/views/MutableCollectionView;", "Src", "Dest", "Laws/smithy/kotlin/runtime/collections/views/CollectionView;", "", "src", "Lkotlin/Function1;", "src2Dest", "dest2Src", "<init>", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "element", "", "add", "(Ljava/lang/Object;)Z", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "", "clear", "()V", "", "iterator", "()Ljava/util/Iterator;", "retainAll", "removeAll", "remove", "Ljava/util/Collection;", "Lkotlin/jvm/functions/Function1;", "runtime-core"})
public class MutableCollectionView<Src, Dest>
extends CollectionView<Src, Dest>
implements Collection<Dest>,
KMutableCollection {
    @NotNull
    private final Collection<Src> src;
    @NotNull
    private final Function1<Src, Dest> src2Dest;
    @NotNull
    private final Function1<Dest, Src> dest2Src;

    public MutableCollectionView(@NotNull Collection<Src> src, @NotNull Function1<? super Src, ? extends Dest> src2Dest, @NotNull Function1<? super Dest, ? extends Src> dest2Src) {
        Intrinsics.checkNotNullParameter(src, (String)"src");
        Intrinsics.checkNotNullParameter(src2Dest, (String)"src2Dest");
        Intrinsics.checkNotNullParameter(dest2Src, (String)"dest2Src");
        super(src, src2Dest, dest2Src);
        this.src = src;
        this.src2Dest = src2Dest;
        this.dest2Src = dest2Src;
    }

    @Override
    public boolean add(Dest element) {
        return this.src.add(this.dest2Src.invoke(element));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Dest> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.src.addAll(ConvertersKt.asView(elements, this.dest2Src, this.src2Dest));
    }

    @Override
    public void clear() {
        this.src.clear();
    }

    @Override
    @NotNull
    public Iterator<Dest> iterator() {
        return ConvertersKt.asView(this.src.iterator(), this.src2Dest);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.src.retainAll(ConvertersKt.asView(elements, this.dest2Src, this.src2Dest));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.src.removeAll(ConvertersKt.asView(elements, this.dest2Src, this.src2Dest));
    }

    @Override
    public boolean remove(Object element) {
        return this.src.remove(this.dest2Src.invoke(element));
    }
}

