/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import aws.smithy.kotlin.runtime.InternalApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\u000bR\u0014\u0010\u0019\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Laws/smithy/kotlin/runtime/util/Uuid;", "", "", "high", "low", "<init>", "(JJ)V", "", "toString", "()Ljava/lang/String;", "component1", "()J", "component2", "copy", "(JJ)Laws/smithy/kotlin/runtime/util/Uuid;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "J", "getHigh", "getLow", "stringRep", "Ljava/lang/String;", "Companion", "runtime-core"})
public final class Uuid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long high;
    private final long low;
    @NotNull
    private final String stringRep;
    @NotNull
    private static final char[] nibbleChars;
    @NotNull
    private static final Random.Default random;
    private static final long v4Mask;
    private static final long v4Set;
    private static final long type2Mask;
    private static final long type2Set;

    public Uuid(long high, long low) {
        this.high = high;
        this.low = low;
        this.stringRep = Uuid.Companion.toString(this.high, this.low);
    }

    public final long getHigh() {
        return this.high;
    }

    public final long getLow() {
        return this.low;
    }

    @NotNull
    public String toString() {
        return this.stringRep;
    }

    public final long component1() {
        return this.high;
    }

    public final long component2() {
        return this.low;
    }

    @NotNull
    public final Uuid copy(long high, long low) {
        return new Uuid(high, low);
    }

    public static /* synthetic */ Uuid copy$default(Uuid uuid, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = uuid.high;
        }
        if ((n & 2) != 0) {
            l2 = uuid.low;
        }
        return uuid.copy(l, l2);
    }

    public int hashCode() {
        int result = Long.hashCode(this.high);
        result = result * 31 + Long.hashCode(this.low);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        Uuid uuid = (Uuid)other;
        if (this.high != uuid.high) {
            return false;
        }
        return this.low == uuid.low;
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        nibbleChars = cArray;
        random = Random.Default;
        v4Mask = (long)61440 & 0xFFFFFFFFL;
        v4Set = (long)16384 & 0xFFFFFFFFL;
        type2Mask = -4611686018427387904L;
        type2Set = Long.MIN_VALUE;
    }

    @InternalApi
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001c\u00a8\u0006 "}, d2={"Laws/smithy/kotlin/runtime/util/Uuid$Companion;", "", "<init>", "()V", "Laws/smithy/kotlin/runtime/util/Uuid;", "random", "()Laws/smithy/kotlin/runtime/util/Uuid;", "", "high", "low", "", "toString", "(JJ)Ljava/lang/String;", "src", "", "srcOffset", "", "dest", "destOffset", "length", "", "writeDigits", "(JI[CII)V", "nibbleChars", "[C", "Lkotlin/random/Random$Default;", "Lkotlin/random/Random$Default;", "v4Mask", "J", "v4Set", "type2Mask", "type2Set", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Uuid random() {
            long high = random.nextLong() & (v4Mask ^ 0xFFFFFFFFFFFFFFFFL) | v4Set;
            long low = random.nextLong() & (type2Mask ^ 0xFFFFFFFFFFFFFFFFL) | type2Set;
            return new Uuid(high, low);
        }

        private final String toString(long high, long low) {
            char[] chars = new char[36];
            this.writeDigits(high, 0, chars, 0, 4);
            chars[8] = 45;
            this.writeDigits(high, 4, chars, 9, 2);
            chars[13] = 45;
            this.writeDigits(high, 6, chars, 14, 2);
            chars[18] = 45;
            this.writeDigits(low, 0, chars, 19, 2);
            chars[23] = 45;
            this.writeDigits(low, 2, chars, 24, 6);
            return StringsKt.concatToString((char[])chars);
        }

        private final void writeDigits(long src, int srcOffset, char[] dest, int destOffset, int length) {
            int shiftBits = 0;
            shiftBits = 64 - srcOffset * 8;
            int destIndex = 0;
            destIndex = destOffset;
            int n = length * 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                long nibble = src >> (shiftBits -= 4) & 0xFL;
                int n3 = destIndex;
                destIndex = n3 + 1;
                dest[n3] = nibbleChars[(int)nibble];
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

