/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import aws.smithy.kotlin.runtime.util.Filesystem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Laws/smithy/kotlin/runtime/util/MapFilesystem;", "Laws/smithy/kotlin/runtime/util/Filesystem;", "", "", "", "memFs", "filePathSeparator", "<init>", "(Ljava/util/Map;Ljava/lang/String;)V", "path", "readFileOrNull", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "data", "", "writeFile", "(Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "fileExists", "(Ljava/lang/String;)Z", "Ljava/util/Map;", "Ljava/lang/String;", "getFilePathSeparator", "()Ljava/lang/String;", "runtime-core"})
public final class MapFilesystem
implements Filesystem {
    @NotNull
    private final Map<String, byte[]> memFs;
    @NotNull
    private final String filePathSeparator;

    public MapFilesystem(@NotNull Map<String, byte[]> memFs, @NotNull String filePathSeparator) {
        Intrinsics.checkNotNullParameter(memFs, (String)"memFs");
        Intrinsics.checkNotNullParameter((Object)filePathSeparator, (String)"filePathSeparator");
        this.memFs = memFs;
        this.filePathSeparator = filePathSeparator;
    }

    @Override
    @NotNull
    public String getFilePathSeparator() {
        return this.filePathSeparator;
    }

    @Override
    @Nullable
    public Object readFileOrNull(@NotNull String path, @NotNull Continuation<? super byte[]> $completion) {
        return this.memFs.get(path);
    }

    @Override
    @Nullable
    public Object writeFile(@NotNull String path, @NotNull byte[] data, @NotNull Continuation<? super Unit> $completion) {
        this.memFs.put(path, data);
        return Unit.INSTANCE;
    }

    @Override
    public boolean fileExists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.memFs.get(path) != null;
    }
}

