/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.time;

import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.ParseException;
import aws.smithy.kotlin.runtime.time.ParseResult;
import aws.smithy.kotlin.runtime.time.ParsedDate;
import aws.smithy.kotlin.runtime.time.ParsedDatetime;
import aws.smithy.kotlin.runtime.time.ParsedTime;
import aws.smithy.kotlin.runtime.time.ParserCombinatorsKt;
import aws.smithy.kotlin.runtime.time.ParsersKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aO\u0010\t\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001aO\u0010\u000b\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\n\u001aY\u0010\r\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\b2\b\b\u0002\u0010\f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001aO\u0010\u0010\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00070\u0000j\b\u0012\u0004\u0012\u00020\u000f`\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\n\u001aO\u0010\u0011\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00070\u0000j\b\u0012\u0004\u0012\u00020\u000f`\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\n\u001aO\u0010\u0012\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\n\u001aO\u0010\u0013\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\n\u001aO\u0010\u0014\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\n\u001aO\u0010\u0015\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\n\u001aO\u0010\u0016\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\n\u001aO\u0010\u0017\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\n\u001aO\u0010\u0018\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\n\u001aO\u0010\u0019\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\n\u001aO\u0010\u001b\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00070\u0000j\b\u0012\u0004\u0012\u00020\u001a`\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\n\u001a\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0017\u0010 \u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b \u0010!\u001a1\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010%*\u00020\u00012\u0006\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b&\u0010'\u001a'\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050%*\u00020\u00012\u0006\u0010(\u001a\u00020#H\u0002\u00a2\u0006\u0004\b)\u0010*\u001a\u0017\u0010,\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b,\u0010-\u001aO\u0010.\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0001`\bH\u0002\u00a2\u0006\u0004\b.\u0010\n\u001a%\u0010/\u001a\b\u0012\u0004\u0012\u00020#0\u00072\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b/\u00100\u001aO\u00101\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b1\u0010\n\u001aO\u00102\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u0000j\b\u0012\u0004\u0012\u00020\u0005`\bH\u0002\u00a2\u0006\u0004\b2\u0010\n\u001aO\u00103\u001aB\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0002\u0012\b\b\u0003\u0012\u0004\b\b(\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00070\u0000j\b\u0012\u0004\u0012\u00020\u001a`\bH\u0002\u00a2\u0006\u0004\b3\u0010\n\u001a\u0017\u00104\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b4\u0010\u001f\"\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00068"}, d2={"Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "str", "", "pos", "Laws/smithy/kotlin/runtime/time/ParseResult;", "Laws/smithy/kotlin/runtime/time/Parser;", "dateYear", "()Lkotlin/jvm/functions/Function2;", "dateMonth", "minDigits", "dateDay", "(I)Lkotlin/jvm/functions/Function2;", "Laws/smithy/kotlin/runtime/time/ParsedDate;", "dateYmd", "date", "timeHour", "timeMin", "timeSec", "timeNanos", "signValue", "tzOffsetHoursMins", "tzUtc", "tzOffsetSecIso8601", "Laws/smithy/kotlin/runtime/time/ParsedTime;", "iso8601Time", "input", "Laws/smithy/kotlin/runtime/time/ParsedDatetime;", "parseIso8601", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/time/ParsedDatetime;", "expandExponent", "(Ljava/lang/String;)Ljava/lang/String;", "position", "", "padChar", "Lkotlin/Pair;", "splitAt", "(Ljava/lang/String;IC)Lkotlin/Pair;", "char", "removeChar", "(Ljava/lang/String;C)Lkotlin/Pair;", "Laws/smithy/kotlin/runtime/time/Instant;", "parseEpoch", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/time/Instant;", "dayName", "sp", "(Ljava/lang/String;I)Laws/smithy/kotlin/runtime/time/ParseResult;", "dateMonthName", "tzOffsetSecRfc5322", "rfc5322Time", "parseRfc5322", "Lkotlin/text/Regex;", "exponentialNotationNumber", "Lkotlin/text/Regex;", "runtime-core"})
public final class ParsersKt {
    @NotNull
    private static final Regex exponentialNotationNumber = new Regex("(-)?(\\d+(.(\\d+))?)E(-?\\d+)", RegexOption.IGNORE_CASE);

    private static final Function2<String, Integer, ParseResult<Integer>> dateYear() {
        return ParserCombinatorsKt.takeNDigits(4);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> dateMonth() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(1, 12));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> dateDay(int minDigits) {
        return ParserCombinatorsKt.mnDigitsInRange(minDigits, 2, new IntRange(1, 31));
    }

    static /* synthetic */ Function2 dateDay$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return ParsersKt.dateDay(n);
    }

    private static final Function2<String, Integer, ParseResult<ParsedDate>> dateYmd() {
        return ParsersKt::dateYmd$lambda$0;
    }

    private static final Function2<String, Integer, ParseResult<ParsedDate>> date() {
        return ParsersKt.dateYmd();
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeHour() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(0, 24));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeMin() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(0, 59));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeSec() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(0, 60));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeNanos() {
        return ParserCombinatorsKt.fraction(1, 9, 9);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> signValue() {
        return ParsersKt::signValue$lambda$2;
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzOffsetHoursMins() {
        return ParsersKt::tzOffsetHoursMins$lambda$3;
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzUtc() {
        return ParserCombinatorsKt.map(ParserCombinatorsKt.oneOf("Zz"), ParsersKt::tzUtc$lambda$4);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzOffsetSecIso8601() {
        return ParsersKt::tzOffsetSecIso8601$lambda$5;
    }

    private static final Function2<String, Integer, ParseResult<ParsedTime>> iso8601Time() {
        return ParsersKt::iso8601Time$lambda$6;
    }

    @NotNull
    public static final ParsedDatetime parseIso8601(@NotNull String input) {
        ParsedTime time;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ParseResult parseResult = (ParseResult)ParsersKt.date().invoke((Object)input, (Object)0);
        int pos0 = parseResult.component1();
        ParsedDate date = (ParsedDate)parseResult.component2();
        ParsedTime ts = pos0 == input.length() ? new ParsedTime(0, 0, 0, 0, 0) : (time = (ParsedTime)((ParseResult)ParserCombinatorsKt.preceded(ParserCombinatorsKt.oneOf("Tt"), ParsersKt.iso8601Time()).invoke((Object)input, (Object)pos0)).component2());
        return new ParsedDatetime(date.getYear(), date.getMonth(), date.getDay(), ts.getHour(), ts.getMin(), ts.getSec(), ts.getNs(), ts.getOffsetSec());
    }

    private static final String expandExponent(String input) {
        Object object;
        block5: {
            block4: {
                StringBuilder stringBuilder;
                object = exponentialNotationNumber.matchEntire((CharSequence)input);
                if (object == null) break block4;
                MatchResult match = object;
                boolean bl = false;
                MatchResult.Destructured destructured = match.getDestructured();
                String baseSign = (String)destructured.getMatch().getGroupValues().get(1);
                String base = (String)destructured.getMatch().getGroupValues().get(2);
                String exp = (String)destructured.getMatch().getGroupValues().get(5);
                StringBuilder $this$expandExponent_u24lambda_u248_u24lambda_u247 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$expandExponent_u24lambda_u248_u24lambda_u247.append(baseSign);
                Pair<String, Integer> pair = ParsersKt.removeChar(base, '.');
                String mantissa = (String)pair.component1();
                int oldDecimalPos = ((Number)pair.component2()).intValue();
                Integer n = StringsKt.toIntOrNull((String)exp);
                if (n == null) {
                    throw new ParseException(input, "Failed to read exponent", 0);
                }
                int shift = n;
                int newDecimalPos = oldDecimalPos + shift;
                Pair pair2 = ParsersKt.splitAt$default(mantissa, newDecimalPos, '\u0000', 2, null);
                String string = (String)pair2.component1();
                String frac = (String)pair2.component2();
                $this$expandExponent_u24lambda_u248_u24lambda_u247.append(string);
                $this$expandExponent_u24lambda_u248_u24lambda_u247.append('.');
                $this$expandExponent_u24lambda_u248_u24lambda_u247.append(frac);
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                object = string2;
                if (string2 != null) break block5;
            }
            object = input;
        }
        return object;
    }

    private static final Pair<String, String> splitAt(String $this$splitAt, int position, char padChar) {
        Pair pair;
        if (position <= 0) {
            pair = TuplesKt.to((Object)String.valueOf(padChar), (Object)StringsKt.padStart((String)$this$splitAt, (int)($this$splitAt.length() - position), (char)padChar));
        } else if (position >= $this$splitAt.length()) {
            pair = TuplesKt.to((Object)StringsKt.padEnd((String)$this$splitAt, (int)position, (char)padChar), (Object)String.valueOf(padChar));
        } else {
            String string = $this$splitAt.substring(0, position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = $this$splitAt.substring(position);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            pair = TuplesKt.to((Object)string, (Object)string2);
        }
        return pair;
    }

    static /* synthetic */ Pair splitAt$default(String string, int n, char c, int n2, Object object) {
        if ((n2 & 2) != 0) {
            c = (char)48;
        }
        return ParsersKt.splitAt(string, n, c);
    }

    private static final Pair<String, Integer> removeChar(String $this$removeChar, char c) {
        Pair pair;
        if (StringsKt.contains$default((CharSequence)$this$removeChar, (char)c, (boolean)false, (int)2, null)) {
            int pos = StringsKt.indexOf$default((CharSequence)$this$removeChar, (char)c, (int)0, (boolean)false, (int)6, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string = $this$removeChar.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            String string2 = $this$removeChar.substring(pos + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String removed = stringBuilder2.append(string2).toString();
            pair = TuplesKt.to((Object)removed, (Object)pos);
        } else {
            pair = TuplesKt.to((Object)$this$removeChar, (Object)$this$removeChar.length());
        }
        return pair;
    }

    @NotNull
    public static final Instant parseEpoch(@NotNull String input) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String expandedInput = ParsersKt.expandExponent(input);
        ParseResult parseResult = (ParseResult)ParserCombinatorsKt.takeMNDigitsLong(1, 19).invoke((Object)expandedInput, (Object)0);
        int pos0 = parseResult.component1();
        long secs = ((Number)parseResult.component2()).longValue();
        if (pos0 == expandedInput.length()) {
            instant = Instant.Companion.fromEpochSeconds(secs, 0);
        } else {
            int ns = ((Number)((ParseResult)ParserCombinatorsKt.preceded(ParserCombinatorsKt.char('.'), ParserCombinatorsKt.fraction(1, 9, 9)).invoke((Object)expandedInput, (Object)pos0)).component2()).intValue();
            instant = Instant.Companion.fromEpochSeconds(secs, ns);
        }
        return instant;
    }

    private static final Function2<String, Integer, ParseResult<String>> dayName() {
        Function2[] function2Array = new Function2[]{ParserCombinatorsKt.tag("Mon"), ParserCombinatorsKt.tag("Tue"), ParserCombinatorsKt.tag("Wed"), ParserCombinatorsKt.tag("Thu"), ParserCombinatorsKt.tag("Fri"), ParserCombinatorsKt.tag("Sat"), ParserCombinatorsKt.tag("Sun")};
        return ParserCombinatorsKt.alt(function2Array);
    }

    private static final ParseResult<Character> sp(String input, int pos) {
        return (ParseResult)ParserCombinatorsKt.char(' ').invoke((Object)input, (Object)pos);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> dateMonthName() {
        return ParsersKt::dateMonthName$lambda$9;
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzOffsetSecRfc5322() {
        return ParsersKt::tzOffsetSecRfc5322$lambda$11;
    }

    private static final Function2<String, Integer, ParseResult<ParsedTime>> rfc5322Time() {
        return ParsersKt::rfc5322Time$lambda$12;
    }

    @NotNull
    public static final ParsedDatetime parseRfc5322(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int pos0 = (!StringsKt.isBlank((CharSequence)input) && !ParserCombinatorsKt.isDigit(input.charAt(0)) ? (ParseResult)ParserCombinatorsKt.map(ParserCombinatorsKt.then(ParserCombinatorsKt.then(ParsersKt.dayName(), ParserCombinatorsKt.char(',')), parseRfc5322.1.INSTANCE), parseRfc5322.2.INSTANCE).invoke((Object)input, (Object)0) : new ParseResult(0, null)).component1();
        ParseResult parseResult = (ParseResult)ParsersKt.dateDay(1).invoke((Object)input, (Object)pos0);
        int pos1 = parseResult.component1();
        int day = ((Number)parseResult.component2()).intValue();
        ParseResult parseResult2 = (ParseResult)ParserCombinatorsKt.preceded(parseRfc5322.3.INSTANCE, ParsersKt.dateMonthName()).invoke((Object)input, (Object)pos1);
        int pos2 = parseResult2.component1();
        int month = ((Number)parseResult2.component2()).intValue();
        ParseResult parseResult3 = (ParseResult)ParserCombinatorsKt.preceded(parseRfc5322.4.INSTANCE, ParsersKt.dateYear()).invoke((Object)input, (Object)pos2);
        int pos3 = parseResult3.component1();
        int year = ((Number)parseResult3.component2()).intValue();
        ParsedTime ts = (ParsedTime)((ParseResult)ParserCombinatorsKt.preceded(parseRfc5322.5.INSTANCE, ParsersKt.rfc5322Time()).invoke((Object)input, (Object)pos3)).component2();
        return new ParsedDatetime(year, month, day, ts.getHour(), ts.getMin(), ts.getSec(), ts.getNs(), ts.getOffsetSec());
    }

    private static final ParseResult dateYmd$lambda$0(String str, int pos) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParseResult parseResult = (ParseResult)ParsersKt.dateYear().invoke((Object)str, (Object)pos);
        int pos0 = parseResult.component1();
        int year = ((Number)parseResult.component2()).intValue();
        int pos1 = ((ParseResult)ParserCombinatorsKt.optional(ParserCombinatorsKt.char('-')).invoke((Object)str, (Object)pos0)).component1();
        ParseResult parseResult2 = (ParseResult)ParsersKt.dateMonth().invoke((Object)str, (Object)pos1);
        int pos2 = parseResult2.component1();
        int month = ((Number)parseResult2.component2()).intValue();
        int pos3 = ((ParseResult)ParserCombinatorsKt.optional(ParserCombinatorsKt.char('-')).invoke((Object)str, (Object)pos2)).component1();
        ParseResult parseResult3 = (ParseResult)ParsersKt.dateDay$default(0, 1, null).invoke((Object)str, (Object)pos3);
        int pos4 = parseResult3.component1();
        int day = ((Number)parseResult3.component2()).intValue();
        return new ParseResult<ParsedDate>(pos4, new ParsedDate(year, month, day));
    }

    private static final int signValue$lambda$2$lambda$1(char chr) {
        return chr == '-' ? -1 : 1;
    }

    private static final ParseResult signValue$lambda$2(String str, int pos) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Function2[] function2Array = new Function2[]{ParserCombinatorsKt.char('+'), ParserCombinatorsKt.char('-')};
        ParseResult parseResult = (ParseResult)ParserCombinatorsKt.map(ParserCombinatorsKt.alt(function2Array), ParsersKt::signValue$lambda$2$lambda$1).invoke((Object)str, (Object)pos);
        int pos0 = parseResult.component1();
        int s = ((Number)parseResult.component2()).intValue();
        return new ParseResult<Integer>(pos0, s);
    }

    private static final ParseResult tzOffsetHoursMins$lambda$3(String str, int pos) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParseResult parseResult = (ParseResult)ParsersKt.signValue().invoke((Object)str, (Object)pos);
        int pos0 = parseResult.component1();
        int sign = ((Number)parseResult.component2()).intValue();
        ParseResult parseResult2 = (ParseResult)ParsersKt.timeHour().invoke((Object)str, (Object)pos0);
        int pos1 = parseResult2.component1();
        int hours = ((Number)parseResult2.component2()).intValue();
        int pos2 = ((ParseResult)ParserCombinatorsKt.optional(ParserCombinatorsKt.char(':')).invoke((Object)str, (Object)pos1)).component1();
        ParseResult<Integer> parseResult3 = pos2 < str.length() ? (ParseResult)ParsersKt.timeMin().invoke((Object)str, (Object)pos2) : new ParseResult<Integer>(pos2, 0);
        int pos3 = parseResult3.component1();
        int min = ((Number)parseResult3.component2()).intValue();
        int offsetSec = sign * (hours * 3600 + min * 60);
        return new ParseResult<Integer>(pos3, offsetSec);
    }

    private static final int tzUtc$lambda$4(char it) {
        return 0;
    }

    private static final ParseResult tzOffsetSecIso8601$lambda$5(String str, int pos) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        try {
            object = new Function2[]{ParsersKt.tzUtc(), ParsersKt.tzOffsetHoursMins()};
            object = (ParseResult)ParserCombinatorsKt.alt(object).invoke((Object)str, (Object)pos);
        }
        catch (ParseException parseException) {
            throw new ParseException(str, "invalid timezone offset; expected `Z|z` or `(+-)HH:MM`", pos);
        }
        return object;
    }

    private static final ParseResult iso8601Time$lambda$6(String str, int pos) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParseResult parseResult = (ParseResult)ParsersKt.timeHour().invoke((Object)str, (Object)pos);
        int pos0 = parseResult.component1();
        int hour = ((Number)parseResult.component2()).intValue();
        int pos1 = ((ParseResult)ParserCombinatorsKt.optional(ParserCombinatorsKt.char(':')).invoke((Object)str, (Object)pos0)).component1();
        ParseResult parseResult2 = (ParseResult)ParsersKt.timeMin().invoke((Object)str, (Object)pos1);
        int pos2 = parseResult2.component1();
        int min = ((Number)parseResult2.component2()).intValue();
        int pos3 = ((ParseResult)ParserCombinatorsKt.optional(ParserCombinatorsKt.char(':')).invoke((Object)str, (Object)pos2)).component1();
        ParseResult parseResult3 = (ParseResult)ParsersKt.timeSec().invoke((Object)str, (Object)pos3);
        int pos4 = parseResult3.component1();
        int sec = ((Number)parseResult3.component2()).intValue();
        ParseResult parseResult4 = (ParseResult)ParserCombinatorsKt.optionalOr(ParserCombinatorsKt.preceded(ParserCombinatorsKt.oneOf(".,"), ParsersKt.timeNanos()), 0).invoke((Object)str, (Object)pos4);
        int pos5 = parseResult4.component1();
        int ns = ((Number)parseResult4.component2()).intValue();
        ParseResult parseResult5 = (ParseResult)ParsersKt.tzOffsetSecIso8601().invoke((Object)str, (Object)pos5);
        int pos6 = parseResult5.component1();
        int offsetSec = ((Number)parseResult5.component2()).intValue();
        return new ParseResult<ParsedTime>(pos6, new ParsedTime(hour, min, sec, ns, offsetSec));
    }

    private static final ParseResult dateMonthName$lambda$9(String str, int pos) {
        int n;
        String name;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParserCombinatorsKt.precond(str, pos, 3);
        String string = str.substring(pos, pos + 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        switch (name = string) {
            case "Jan": {
                n = 1;
                break;
            }
            case "Feb": {
                n = 2;
                break;
            }
            case "Mar": {
                n = 3;
                break;
            }
            case "Apr": {
                n = 4;
                break;
            }
            case "May": {
                n = 5;
                break;
            }
            case "Jun": {
                n = 6;
                break;
            }
            case "Jul": {
                n = 7;
                break;
            }
            case "Aug": {
                n = 8;
                break;
            }
            case "Sep": {
                n = 9;
                break;
            }
            case "Oct": {
                n = 10;
                break;
            }
            case "Nov": {
                n = 11;
                break;
            }
            case "Dec": {
                n = 12;
                break;
            }
            default: {
                throw new ParseException(str, "invalid month `" + name + '`', pos);
            }
        }
        int monthNum = n;
        return new ParseResult<Integer>(pos + 3, monthNum);
    }

    private static final int tzOffsetSecRfc5322$lambda$11$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    private static final ParseResult tzOffsetSecRfc5322$lambda$11(String str, int pos) {
        ParseResult parseResult;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        try {
            Function2[] function2Array = new Function2[]{ParserCombinatorsKt.tag("GMT"), ParserCombinatorsKt.tag("UTC"), ParserCombinatorsKt.tag("UT"), ParserCombinatorsKt.tag("Z")};
            Function2 utcOffsets = ParserCombinatorsKt.map(ParserCombinatorsKt.alt(function2Array), ParsersKt::tzOffsetSecRfc5322$lambda$11$lambda$10);
            function2Array = new Function2[]{utcOffsets, ParsersKt.tzOffsetHoursMins()};
            parseResult = (ParseResult)ParserCombinatorsKt.alt(function2Array).invoke((Object)str, (Object)pos);
        }
        catch (ParseException parseException) {
            throw new ParseException(str, "invalid timezone offset; expected `GMT` or `(+-)HHMM`", pos);
        }
        return parseResult;
    }

    private static final ParseResult rfc5322Time$lambda$12(String str, int pos) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParseResult parseResult = (ParseResult)ParsersKt.timeHour().invoke((Object)str, (Object)pos);
        int pos0 = parseResult.component1();
        int hour = ((Number)parseResult.component2()).intValue();
        ParseResult parseResult2 = (ParseResult)ParserCombinatorsKt.preceded(ParserCombinatorsKt.char(':'), ParsersKt.timeMin()).invoke((Object)str, (Object)pos0);
        int pos1 = parseResult2.component1();
        int min = ((Number)parseResult2.component2()).intValue();
        ParseResult parseResult3 = pos1 < str.length() && str.charAt(pos1) == ':' ? (ParseResult)ParserCombinatorsKt.preceded(ParserCombinatorsKt.char(':'), ParsersKt.timeSec()).invoke((Object)str, (Object)pos1) : new ParseResult(pos1, 0);
        int pos2 = parseResult3.component1();
        int sec = ((Number)parseResult3.component2()).intValue();
        ParseResult parseResult4 = (ParseResult)ParserCombinatorsKt.optionalOr(ParserCombinatorsKt.preceded(ParserCombinatorsKt.oneOf("."), ParsersKt.timeNanos()), 0).invoke((Object)str, (Object)pos2);
        int pos3 = parseResult4.component1();
        int ns = ((Number)parseResult4.component2()).intValue();
        ParseResult parseResult5 = (ParseResult)ParserCombinatorsKt.preceded(rfc5322Time.1.1.INSTANCE, ParsersKt.tzOffsetSecRfc5322()).invoke((Object)str, (Object)pos3);
        int pos4 = parseResult5.component1();
        int offsetSec = ((Number)parseResult5.component2()).intValue();
        return new ParseResult<ParsedTime>(pos4, new ParsedTime(hour, min, sec, ns, offsetSec));
    }

    public static final /* synthetic */ ParseResult access$sp(String input, int pos) {
        return ParsersKt.sp(input, pos);
    }
}

