/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.retries.delay.DelayProvider;
import aws.smithy.kotlin.runtime.util.DslFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "config", "<init>", "(Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;)V", "", "attempt", "", "backoff", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "getConfig", "()Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "Lkotlin/random/Random$Default;", "random", "Lkotlin/random/Random$Default;", "Companion", "Config", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nExponentialBackoffWithJitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExponentialBackoffWithJitter.kt\naws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class ExponentialBackoffWithJitter
implements DelayProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Random.Default random;

    public ExponentialBackoffWithJitter(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.config = config2;
        this.random = Random.Default;
    }

    public /* synthetic */ ExponentialBackoffWithJitter(Config config2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config2 = Config.Companion.getDefault();
        }
        this(config2);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    @Nullable
    public Object backoff(int attempt, @NotNull Continuation<? super Unit> $completion) {
        if (!(attempt > 0)) {
            boolean bl = false;
            String string = "attempt was " + attempt + " but must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        double calculatedDelayMs = (double)Duration.getInWholeMilliseconds-impl((long)this.getConfig().getInitialDelay-UwyO8pc()) * Math.pow(this.getConfig().getScaleFactor(), attempt - 1);
        double maxDelayMs = Math.min(calculatedDelayMs, Duration.toDouble-impl((long)this.getConfig().getMaxBackoff-UwyO8pc(), (DurationUnit)DurationUnit.MILLISECONDS));
        double jitterProportion = this.getConfig().getJitter() > 0.0 ? this.random.nextDouble(this.getConfig().getJitter()) : 0.0;
        double delayMs = maxDelayMs * (1.0 - jitterProportion);
        Object object = DelayKt.delay((long)((long)delayMs), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public ExponentialBackoffWithJitter() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\n\u001a\u00020\u00032\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Companion;", "Laws/smithy/kotlin/runtime/util/DslFactory;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter;", "<init>", "()V", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "invoke", "(Lkotlin/jvm/functions/Function1;)Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter;", "runtime-core"})
    public static final class Companion
    implements DslFactory<Config.Builder, ExponentialBackoffWithJitter> {
        private Companion() {
        }

        @Override
        @NotNull
        public ExponentialBackoffWithJitter invoke(@NotNull Function1<? super Config.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return new ExponentialBackoffWithJitter(Config.Companion.invoke(block));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u0018\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006\u001c"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider$Config;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "builder", "<init>", "(Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;)V", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "toBuilderApplicator", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/time/Duration;", "initialDelay", "J", "getInitialDelay-UwyO8pc", "()J", "", "scaleFactor", "D", "getScaleFactor", "()D", "jitter", "getJitter", "maxBackoff", "getMaxBackoff-UwyO8pc", "Companion", "Builder", "runtime-core"})
    public static final class Config
    implements DelayProvider.Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long initialDelay;
        private final double scaleFactor;
        private final double jitter;
        private final long maxBackoff;
        @NotNull
        private static final Config Default = new Config(new Builder());

        public Config(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.initialDelay = builder.getInitialDelay-UwyO8pc();
            this.scaleFactor = builder.getScaleFactor();
            this.jitter = builder.getJitter();
            this.maxBackoff = builder.getMaxBackoff-UwyO8pc();
        }

        public final long getInitialDelay-UwyO8pc() {
            return this.initialDelay;
        }

        public final double getScaleFactor() {
            return this.scaleFactor;
        }

        public final double getJitter() {
            return this.jitter;
        }

        public final long getMaxBackoff-UwyO8pc() {
            return this.maxBackoff;
        }

        @Override
        @InternalApi
        @NotNull
        public Function1<DelayProvider.Config.Builder, Unit> toBuilderApplicator() {
            return arg_0 -> Config.toBuilderApplicator$lambda$0(this, arg_0);
        }

        private static final Unit toBuilderApplicator$lambda$0(Config this$0, DelayProvider.Config.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
            if (builder instanceof Builder) {
                ((Builder)builder).setInitialDelay-LRDsOJo(this$0.initialDelay);
                ((Builder)builder).setScaleFactor(this$0.scaleFactor);
                ((Builder)builder).setJitter(this$0.jitter);
                ((Builder)builder).setMaxBackoff-LRDsOJo(this$0.maxBackoff);
            }
            return Unit.INSTANCE;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\"\u0010\u0015\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\n\u00a8\u0006\u0018"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider$Config$Builder;", "<init>", "()V", "Lkotlin/time/Duration;", "initialDelay", "J", "getInitialDelay-UwyO8pc", "()J", "setInitialDelay-LRDsOJo", "(J)V", "", "scaleFactor", "D", "getScaleFactor", "()D", "setScaleFactor", "(D)V", "jitter", "getJitter", "setJitter", "maxBackoff", "getMaxBackoff-UwyO8pc", "setMaxBackoff-LRDsOJo", "runtime-core"})
        public static final class Builder
        implements DelayProvider.Config.Builder {
            private long initialDelay = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MILLISECONDS);
            private double scaleFactor = 1.5;
            private double jitter = 1.0;
            private long maxBackoff = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.SECONDS);

            public final long getInitialDelay-UwyO8pc() {
                return this.initialDelay;
            }

            public final void setInitialDelay-LRDsOJo(long l) {
                this.initialDelay = l;
            }

            public final double getScaleFactor() {
                return this.scaleFactor;
            }

            public final void setScaleFactor(double d) {
                this.scaleFactor = d;
            }

            public final double getJitter() {
                return this.jitter;
            }

            public final void setJitter(double d) {
                this.jitter = d;
            }

            public final long getMaxBackoff-UwyO8pc() {
                return this.maxBackoff;
            }

            public final void setMaxBackoff-LRDsOJo(long l) {
                this.maxBackoff = l;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Companion;", "", "<init>", "()V", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "block", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "invoke", "(Lkotlin/jvm/functions/Function1;)Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "Default", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "getDefault", "()Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "runtime-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Config getDefault() {
                return Default;
            }

            @NotNull
            public final Config invoke(@NotNull Function1<? super Builder, Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                Builder builder = new Builder();
                block.invoke((Object)builder);
                return new Config(builder);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

