/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.retries.delay.AdaptiveRateLimiter;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0010\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\"\u0010\u0007\u001a\u00020\u00068\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010 R\"\u0010\t\u001a\u00020\b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020&8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\"\u0010,\u001a\u00020\u00068\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010\u001d\u001a\u0004\b-\u0010\u0013\"\u0004\b.\u0010 \u00a8\u0006/"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/CubicRateCalculator;", "", "Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;", "config", "Lkotlin/time/TimeSource;", "timeSource", "", "lastMaxRate", "Lkotlin/time/TimeMark;", "lastThrottleTime", "<init>", "(Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;Lkotlin/time/TimeSource;DLkotlin/time/TimeMark;)V", "Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;", "errorType", "measuredTxRate", "refillUnitsPerSecond", "calculate", "(Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;DD)D", "calculateTimeWindow$runtime_core", "()D", "calculateTimeWindow", "cubicSuccess$runtime_core", "cubicSuccess", "rate", "cubicThrottle$runtime_core", "(D)D", "cubicThrottle", "Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;", "Lkotlin/time/TimeSource;", "D", "getLastMaxRate$runtime_core", "setLastMaxRate$runtime_core", "(D)V", "Lkotlin/time/TimeMark;", "getLastThrottleTime$runtime_core", "()Lkotlin/time/TimeMark;", "setLastThrottleTime$runtime_core", "(Lkotlin/time/TimeMark;)V", "", "value", "throttlingEnabled", "Z", "getThrottlingEnabled", "()Z", "timeWindow", "getTimeWindow$runtime_core", "setTimeWindow$runtime_core", "runtime-core"})
public final class CubicRateCalculator {
    @NotNull
    private final AdaptiveRateLimiter.Config config;
    @NotNull
    private final TimeSource timeSource;
    private double lastMaxRate;
    @NotNull
    private TimeMark lastThrottleTime;
    private boolean throttlingEnabled;
    private double timeWindow;

    public CubicRateCalculator(@NotNull AdaptiveRateLimiter.Config config2, @NotNull TimeSource timeSource, double lastMaxRate, @NotNull TimeMark lastThrottleTime) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)lastThrottleTime, (String)"lastThrottleTime");
        this.config = config2;
        this.timeSource = timeSource;
        this.lastMaxRate = lastMaxRate;
        this.lastThrottleTime = lastThrottleTime;
        this.timeWindow = this.calculateTimeWindow$runtime_core();
    }

    public /* synthetic */ CubicRateCalculator(AdaptiveRateLimiter.Config config2, TimeSource timeSource, double d, TimeMark timeMark, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            timeMark = timeSource.markNow();
        }
        this(config2, timeSource, d, timeMark);
    }

    public final double getLastMaxRate$runtime_core() {
        return this.lastMaxRate;
    }

    public final void setLastMaxRate$runtime_core(double d) {
        this.lastMaxRate = d;
    }

    @NotNull
    public final TimeMark getLastThrottleTime$runtime_core() {
        return this.lastThrottleTime;
    }

    public final void setLastThrottleTime$runtime_core(@NotNull TimeMark timeMark) {
        Intrinsics.checkNotNullParameter((Object)timeMark, (String)"<set-?>");
        this.lastThrottleTime = timeMark;
    }

    public final boolean getThrottlingEnabled() {
        return this.throttlingEnabled;
    }

    public final double getTimeWindow$runtime_core() {
        return this.timeWindow;
    }

    public final void setTimeWindow$runtime_core(double d) {
        this.timeWindow = d;
    }

    public final double calculate(@Nullable RetryErrorType errorType, double measuredTxRate, double refillUnitsPerSecond) {
        double d;
        if (errorType == RetryErrorType.Throttling) {
            this.lastMaxRate = this.throttlingEnabled ? Math.min(measuredTxRate, refillUnitsPerSecond) : measuredTxRate;
            this.timeWindow = this.calculateTimeWindow$runtime_core();
            this.lastThrottleTime = this.timeSource.markNow();
            this.throttlingEnabled = true;
            d = this.cubicThrottle$runtime_core(this.lastMaxRate);
        } else {
            d = this.cubicSuccess$runtime_core();
        }
        double calculatedRate = d;
        return calculatedRate;
    }

    public final double calculateTimeWindow$runtime_core() {
        return Math.cbrt(this.lastMaxRate * (1.0 - this.config.getBeta()) / this.config.getScaleConstant());
    }

    public final double cubicSuccess$runtime_core() {
        double deltaSeconds = Duration.toDouble-impl((long)this.lastThrottleTime.elapsedNow-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS);
        return this.config.getScaleConstant() * Math.pow(deltaSeconds - this.timeWindow, 3) + this.lastMaxRate;
    }

    public final double cubicThrottle$runtime_core(double rate) {
        return rate * this.config.getBeta();
    }
}

