/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.retries.delay.AdaptiveRateLimiter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u0016\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012R\"\u0010\t\u001a\u00020\b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0013\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0016R\u0016\u0010\u000b\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0013\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateMeasurer;", "", "Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;", "config", "Lkotlin/time/TimeSource;", "timeSource", "Lkotlin/time/TimeMark;", "lastTxBucketMark", "", "measuredTxRate", "", "requestCount", "<init>", "(Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;Lkotlin/time/TimeSource;Lkotlin/time/TimeMark;DI)V", "updateMeasuredRate", "()D", "Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;", "Lkotlin/time/TimeSource;", "Lkotlin/time/TimeMark;", "D", "getMeasuredTxRate$runtime_core", "setMeasuredTxRate$runtime_core", "(D)V", "I", "bucketsPerSecond", "runtime-core"})
public final class AdaptiveRateMeasurer {
    @NotNull
    private final AdaptiveRateLimiter.Config config;
    @NotNull
    private final TimeSource timeSource;
    @NotNull
    private TimeMark lastTxBucketMark;
    private double measuredTxRate;
    private int requestCount;
    private final double bucketsPerSecond;

    public AdaptiveRateMeasurer(@NotNull AdaptiveRateLimiter.Config config2, @NotNull TimeSource timeSource, @NotNull TimeMark lastTxBucketMark, double measuredTxRate, int requestCount) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)lastTxBucketMark, (String)"lastTxBucketMark");
        this.config = config2;
        this.timeSource = timeSource;
        this.lastTxBucketMark = lastTxBucketMark;
        this.measuredTxRate = measuredTxRate;
        this.requestCount = requestCount;
        this.bucketsPerSecond = 1.0 / Duration.toDouble-impl((long)this.config.getMeasurementBucketDuration-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS);
    }

    public /* synthetic */ AdaptiveRateMeasurer(AdaptiveRateLimiter.Config config2, TimeSource timeSource, TimeMark timeMark, double d, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            timeMark = timeSource.markNow();
        }
        if ((n2 & 8) != 0) {
            d = 0.0;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(config2, timeSource, timeMark, d, n);
    }

    public final double getMeasuredTxRate$runtime_core() {
        return this.measuredTxRate;
    }

    public final void setMeasuredTxRate$runtime_core(double d) {
        this.measuredTxRate = d;
    }

    public final double updateMeasuredRate() {
        int n = this.requestCount;
        this.requestCount = n + 1;
        long delta = this.lastTxBucketMark.elapsedNow-UwyO8pc();
        double bucketDelta = Math.floor(Duration.div-LRDsOJo((long)delta, (long)this.config.getMeasurementBucketDuration-UwyO8pc()));
        if (bucketDelta >= 1.0) {
            double currentRate = (double)this.requestCount / bucketDelta * this.bucketsPerSecond;
            this.measuredTxRate = currentRate * this.config.getSmoothing() + this.measuredTxRate * (1.0 - this.config.getSmoothing());
            double d = bucketDelta;
            this.lastTxBucketMark = this.lastTxBucketMark.plus-LRDsOJo(Duration.times-UwyO8pc((long)this.config.getMeasurementBucketDuration-UwyO8pc(), (double)d));
            this.requestCount = 0;
        }
        return this.measuredTxRate;
    }
}

