/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net.url;

import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.HostKt;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.QueryParameters;
import aws.smithy.kotlin.runtime.net.url.UrlEncoding;
import aws.smithy.kotlin.runtime.net.url.UrlKt;
import aws.smithy.kotlin.runtime.net.url.UrlPath;
import aws.smithy.kotlin.runtime.net.url.UserInfo;
import aws.smithy.kotlin.runtime.text.Scanner;
import aws.smithy.kotlin.runtime.text.TextKt;
import aws.smithy.kotlin.runtime.text.encoding.Encodable;
import aws.smithy.kotlin.runtime.text.encoding.Encoding;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import aws.smithy.kotlin.runtime.util.CanDeepCopy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u001f\u0018\u0000 >2\u00020\u0001:\u0002>?BC\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J(\u0010\u0019\u001a\u00020\u00002\u0019\b\u0002\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010*\u001a\u0004\b+\u0010 R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010/\u001a\u0004\b0\u00101R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u00102\u001a\u0004\b3\u00104R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00105\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0017\u0010:\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b:\u00109\u001a\u0004\b;\u0010#R\u0017\u0010<\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b<\u00109\u001a\u0004\b=\u0010#\u00a8\u0006@"}, d2={"Laws/smithy/kotlin/runtime/net/url/Url;", "", "Laws/smithy/kotlin/runtime/net/Scheme;", "scheme", "Laws/smithy/kotlin/runtime/net/Host;", "host", "", "port", "Laws/smithy/kotlin/runtime/net/url/UrlPath;", "path", "Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "parameters", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "userInfo", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "fragment", "<init>", "(Laws/smithy/kotlin/runtime/net/Scheme;Laws/smithy/kotlin/runtime/net/Host;ILaws/smithy/kotlin/runtime/net/url/UrlPath;Laws/smithy/kotlin/runtime/net/url/QueryParameters;Laws/smithy/kotlin/runtime/net/url/UserInfo;Laws/smithy/kotlin/runtime/text/encoding/Encodable;)V", "Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "toBuilder", "()Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "copy", "(Lkotlin/jvm/functions/Function1;)Laws/smithy/kotlin/runtime/net/url/Url;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Laws/smithy/kotlin/runtime/net/Scheme;", "getScheme", "()Laws/smithy/kotlin/runtime/net/Scheme;", "Laws/smithy/kotlin/runtime/net/Host;", "getHost", "()Laws/smithy/kotlin/runtime/net/Host;", "I", "getPort", "Laws/smithy/kotlin/runtime/net/url/UrlPath;", "getPath", "()Laws/smithy/kotlin/runtime/net/url/UrlPath;", "Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "getParameters", "()Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "getUserInfo", "()Laws/smithy/kotlin/runtime/net/url/UserInfo;", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "getFragment", "()Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "encoded", "Ljava/lang/String;", "hostAndPort", "getHostAndPort", "requestRelativePath", "getRequestRelativePath", "Companion", "Builder", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/url/Url\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
public final class Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheme scheme;
    @NotNull
    private final Host host;
    private final int port;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final QueryParameters parameters;
    @NotNull
    private final UserInfo userInfo;
    @Nullable
    private final Encodable fragment;
    @NotNull
    private final String encoded;
    @NotNull
    private final String hostAndPort;
    @NotNull
    private final String requestRelativePath;

    /*
     * WARNING - void declaration
     */
    private Url(Scheme scheme, Host host, int port, UrlPath path, QueryParameters parameters, UserInfo userInfo, Encodable fragment) {
        void $this$hostAndPort_u24lambda_u240;
        StringBuilder stringBuilder;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.userInfo = userInfo;
        this.fragment = fragment;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Url url = this;
        boolean bl = false;
        $this$hostAndPort_u24lambda_u240.append(this.host);
        if (this.port != this.scheme.getDefaultPort()) {
            $this$hostAndPort_u24lambda_u240.append(':');
            $this$hostAndPort_u24lambda_u240.append(this.port);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        url.hostAndPort = string;
        int n = this.port;
        if (!(1 <= n ? n < 65536 : false)) {
            boolean $i$a$-require-Url$22 = false;
            String $i$a$-require-Url$22 = "Given port " + this.port + " is not in required range [1, 65535]";
            throw new IllegalArgumentException($i$a$-require-Url$22.toString());
        }
        Pair it = Url.Companion.stringify(this.scheme, this.host, this.port, this.path, this.parameters, this.userInfo, this.fragment);
        boolean bl2 = false;
        this.encoded = (String)it.getFirst();
        this.requestRelativePath = (String)it.getSecond();
    }

    @NotNull
    public final Scheme getScheme() {
        return this.scheme;
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public final QueryParameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Nullable
    public final Encodable getFragment() {
        return this.fragment;
    }

    @NotNull
    public final String getHostAndPort() {
        return this.hostAndPort;
    }

    @NotNull
    public final String getRequestRelativePath() {
        return this.requestRelativePath;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this);
    }

    @NotNull
    public final Url copy(@NotNull Function1<? super Builder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Builder builder = this.toBuilder();
        block.invoke((Object)builder);
        return builder.build();
    }

    public static /* synthetic */ Url copy$default(Url url, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = Url::copy$lambda$3;
        }
        return url.copy((Function1<? super Builder, Unit>)function1);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Url cfr_ignored_0 = (Url)other;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)((Url)other).scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)((Url)other).host)) {
            return false;
        }
        if (this.port != ((Url)other).port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)((Url)other).path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameters, (Object)((Url)other).parameters)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userInfo, (Object)((Url)other).userInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fragment, (Object)((Url)other).fragment);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.userInfo.hashCode();
        Encodable encodable = this.fragment;
        result = 31 * result + (encodable != null ? encodable.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return this.encoded;
    }

    private static final Unit copy$lambda$3(Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
        return Unit.INSTANCE;
    }

    public /* synthetic */ Url(Scheme scheme, Host host, int port, UrlPath path, QueryParameters parameters, UserInfo userInfo, Encodable fragment, DefaultConstructorMarker $constructor_marker) {
        this(scheme, host, port, path, parameters, userInfo, fragment);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J,\u0010\f\u001a\u00020\t2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\rJ,\u0010\u000f\u001a\u00020\t2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\rJ,\u0010\u0011\u001a\u00020\t2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\rJ\u001f\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0019\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0005R\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010-\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00105\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R$\u0010\f\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\f\u00106\u001a\u0004\b7\u00108R\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00109\u001a\u0004\b:\u0010;R\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010<\u001a\u0004\b=\u0010>R\u0018\u0010@\u001a\u0004\u0018\u00010?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR(\u0010E\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u00104\"\u0004\bC\u0010DR(\u0010H\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u00104\"\u0004\bG\u0010DR\u0011\u0010J\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bI\u00104\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006K"}, d2={"Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "Laws/smithy/kotlin/runtime/util/CanDeepCopy;", "Laws/smithy/kotlin/runtime/net/url/Url;", "url", "<init>", "(Laws/smithy/kotlin/runtime/net/url/Url;)V", "()V", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/net/url/UrlPath$Builder;", "", "Lkotlin/ExtensionFunctionType;", "block", "path", "(Lkotlin/jvm/functions/Function1;)V", "Laws/smithy/kotlin/runtime/net/url/QueryParameters$Builder;", "parameters", "Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "userInfo", "", "value", "Laws/smithy/kotlin/runtime/net/url/UrlEncoding;", "encoding", "parseFragment$runtime_core", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/net/url/UrlEncoding;)V", "parseFragment", "build", "()Laws/smithy/kotlin/runtime/net/url/Url;", "deepCopy", "()Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "copyFrom", "Laws/smithy/kotlin/runtime/net/Scheme;", "scheme", "Laws/smithy/kotlin/runtime/net/Scheme;", "getScheme", "()Laws/smithy/kotlin/runtime/net/Scheme;", "setScheme", "(Laws/smithy/kotlin/runtime/net/Scheme;)V", "Laws/smithy/kotlin/runtime/net/Host;", "host", "Laws/smithy/kotlin/runtime/net/Host;", "getHost", "()Laws/smithy/kotlin/runtime/net/Host;", "setHost", "(Laws/smithy/kotlin/runtime/net/Host;)V", "", "port", "Ljava/lang/Integer;", "getPort", "()Ljava/lang/Integer;", "setPort", "(Ljava/lang/Integer;)V", "getHostAndPort", "()Ljava/lang/String;", "hostAndPort", "Laws/smithy/kotlin/runtime/net/url/UrlPath$Builder;", "getPath", "()Laws/smithy/kotlin/runtime/net/url/UrlPath$Builder;", "Laws/smithy/kotlin/runtime/net/url/QueryParameters$Builder;", "getParameters", "()Laws/smithy/kotlin/runtime/net/url/QueryParameters$Builder;", "Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "getUserInfo", "()Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "fragment", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "getDecodedFragment", "setDecodedFragment", "(Ljava/lang/String;)V", "decodedFragment", "getEncodedFragment", "setEncodedFragment", "encodedFragment", "getRequestRelativePath", "requestRelativePath", "runtime-core"})
    @SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/url/Url$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
    public static final class Builder
    implements CanDeepCopy<Builder> {
        @NotNull
        private Scheme scheme;
        @NotNull
        private Host host;
        @Nullable
        private Integer port;
        @NotNull
        private UrlPath.Builder path;
        @NotNull
        private final QueryParameters.Builder parameters;
        @NotNull
        private final UserInfo.Builder userInfo;
        @Nullable
        private Encodable fragment;

        public Builder(@Nullable Url url) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = url;
            if (object4 == null || (object4 = ((Url)object4).getScheme()) == null) {
                object4 = this.scheme = Scheme.Companion.getHTTPS();
            }
            if ((object3 = url) == null || (object3 = ((Url)object3).getHost()) == null) {
                object3 = new Host.Domain("");
            }
            this.host = object3;
            Url url2 = url;
            this.port = url2 != null ? Integer.valueOf(url2.getPort()) : null;
            Object object5 = url;
            if (object5 == null || (object5 = ((Url)object5).getPath()) == null || (object5 = ((UrlPath)object5).toBuilder()) == null) {
                object5 = this.path = new UrlPath.Builder();
            }
            if ((object2 = url) == null || (object2 = ((Url)object2).getParameters()) == null || (object2 = ((QueryParameters)object2).toBuilder()) == null) {
                object2 = this.parameters = new QueryParameters.Builder();
            }
            if ((object = url) == null || (object = ((Url)object).getUserInfo()) == null || (object = ((UserInfo)object).toBuilder()) == null) {
                object = new UserInfo.Builder();
            }
            this.userInfo = object;
            Url url3 = url;
            this.fragment = url3 != null ? url3.getFragment() : null;
        }

        public Builder() {
            this(null);
        }

        @NotNull
        public final Scheme getScheme() {
            return this.scheme;
        }

        public final void setScheme(@NotNull Scheme scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"<set-?>");
            this.scheme = scheme;
        }

        @NotNull
        public final Host getHost() {
            return this.host;
        }

        public final void setHost(@NotNull Host host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"<set-?>");
            this.host = host;
        }

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(@Nullable Integer n) {
            this.port = n;
        }

        @NotNull
        public final String getHostAndPort() {
            StringBuilder stringBuilder;
            StringBuilder $this$_get_hostAndPort__u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$_get_hostAndPort__u24lambda_u240.append(this.host);
            if (this.port != null) {
                Integer n = this.port;
                int n2 = this.scheme.getDefaultPort();
                if (n == null || n != n2) {
                    $this$_get_hostAndPort__u24lambda_u240.append(':');
                    $this$_get_hostAndPort__u24lambda_u240.append(this.port);
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final UrlPath.Builder getPath() {
            return this.path;
        }

        public final void path(@NotNull Function1<? super UrlPath.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$path = false;
            UrlPath.Builder builder = this.getPath();
            block.invoke((Object)builder);
        }

        @NotNull
        public final QueryParameters.Builder getParameters() {
            return this.parameters;
        }

        public final void parameters(@NotNull Function1<? super QueryParameters.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$parameters = false;
            QueryParameters.Builder builder = this.getParameters();
            block.invoke((Object)builder);
        }

        @NotNull
        public final UserInfo.Builder getUserInfo() {
            return this.userInfo;
        }

        public final void userInfo(@NotNull Function1<? super UserInfo.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$userInfo = false;
            UserInfo.Builder builder = this.getUserInfo();
            block.invoke((Object)builder);
        }

        public final void parseFragment$runtime_core(@NotNull String value, @NotNull UrlEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            if (encoding.contains(UrlEncoding.Fragment.INSTANCE)) {
                this.setEncodedFragment(value);
            } else {
                this.setDecodedFragment(value);
            }
        }

        @Nullable
        public final String getDecodedFragment() {
            Encodable encodable = this.fragment;
            return encodable != null ? encodable.getDecoded() : null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDecodedFragment(@Nullable String value) {
            Encodable encodable;
            Builder builder = this;
            String string = value;
            if (string != null) {
                void p0;
                String string2 = string;
                Encoding encoding = PercentEncoding.Companion.getFragment();
                String string3 = string2;
                Builder builder2 = builder;
                boolean $i$f$_set_decodedFragment_$stub_for_inlining = false;
                boolean bl = false;
                encodable = encoding.encodableFromDecoded((String)p0);
                builder = builder2;
            } else {
                encodable = null;
            }
            builder.fragment = encodable;
        }

        @Nullable
        public final String getEncodedFragment() {
            Encodable encodable = this.fragment;
            return encodable != null ? encodable.getEncoded() : null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedFragment(@Nullable String value) {
            Encodable encodable;
            Builder builder = this;
            String string = value;
            if (string != null) {
                void p0;
                String string2 = string;
                Encoding encoding = PercentEncoding.Companion.getFragment();
                String string3 = string2;
                Builder builder2 = builder;
                boolean $i$f$_set_encodedFragment_$stub_for_inlining$1 = false;
                boolean bl = false;
                encodable = encoding.encodableFromEncoded((String)p0);
                builder = builder2;
            } else {
                encodable = null;
            }
            builder.fragment = encodable;
        }

        @NotNull
        public final Url build() {
            Integer n = this.port;
            return new Url(this.scheme, this.host, n != null ? n.intValue() : this.scheme.getDefaultPort(), this.path.build(), this.parameters.build(), this.userInfo.build(), this.fragment, null);
        }

        @Override
        @NotNull
        public Builder deepCopy() {
            Builder builder;
            Builder it = builder = new Builder();
            boolean bl = false;
            it.scheme = this.scheme;
            it.host = this.host;
            it.port = this.port;
            it.path.copyFrom(this.path);
            it.parameters.copyFrom(this.parameters);
            it.userInfo.copyFrom(this.userInfo);
            it.fragment = this.fragment;
            return builder;
        }

        public final void copyFrom(@NotNull Url url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.scheme = url.getScheme();
            this.host = url.getHost();
            this.port = url.getPort();
            this.path.copyFrom(url.getPath());
            this.parameters.copyFrom(url.getParameters());
            this.userInfo.copyFrom(url.getUserInfo());
            this.fragment = url.getFragment();
        }

        @NotNull
        public final String getRequestRelativePath() {
            StringBuilder stringBuilder;
            StringBuilder $this$_get_requestRelativePath__u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$_get_requestRelativePath__u24lambda_u244.append(this.path.getEncoded());
            $this$_get_requestRelativePath__u24lambda_u244.append(this.parameters.getEncoded());
            Encodable encodable = this.fragment;
            if (encodable != null) {
                Encodable it = encodable;
                boolean bl2 = false;
                $this$_get_requestRelativePath__u24lambda_u244.append('#');
                $this$_get_requestRelativePath__u24lambda_u244.append(it.getEncoded());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return TextKt.ensurePrefix(string, "/");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\n\u001a\u00020\t2\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007H\u0086\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011JU\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0 2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"Laws/smithy/kotlin/runtime/net/url/Url$Companion;", "", "<init>", "()V", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "", "Lkotlin/ExtensionFunctionType;", "block", "Laws/smithy/kotlin/runtime/net/url/Url;", "invoke", "(Lkotlin/jvm/functions/Function1;)Laws/smithy/kotlin/runtime/net/url/Url;", "", "value", "Laws/smithy/kotlin/runtime/net/url/UrlEncoding;", "encoding", "parse", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/net/url/UrlEncoding;)Laws/smithy/kotlin/runtime/net/url/Url;", "Laws/smithy/kotlin/runtime/net/Scheme;", "scheme", "Laws/smithy/kotlin/runtime/net/Host;", "host", "", "port", "Laws/smithy/kotlin/runtime/net/url/UrlPath;", "path", "Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "parameters", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "userInfo", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "fragment", "Lkotlin/Pair;", "stringify", "(Laws/smithy/kotlin/runtime/net/Scheme;Laws/smithy/kotlin/runtime/net/Host;ILaws/smithy/kotlin/runtime/net/url/UrlPath;Laws/smithy/kotlin/runtime/net/url/QueryParameters;Laws/smithy/kotlin/runtime/net/url/UserInfo;Laws/smithy/kotlin/runtime/text/encoding/Encodable;)Lkotlin/Pair;", "runtime-core"})
    @SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/url/Url$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n39#1:408\n1#2:409\n*S KotlinDebug\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/url/Url$Companion\n*L\n49#1:408\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Url invoke(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.build();
        }

        @NotNull
        public final Url parse(@NotNull String value, @NotNull UrlEncoding encoding) {
            Url url;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            try {
                Builder builder;
                Companion this_$iv = Companion;
                boolean $i$f$invoke = false;
                Builder $this$parse_u24lambda_u2411 = builder = new Builder();
                boolean bl = false;
                Scanner scanner = new Scanner(value);
                String[] stringArray = new String[]{"://"};
                scanner.requireAndSkip(stringArray, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$0($this$parse_u24lambda_u2411, arg_0)));
                stringArray = new String[]{"/", "?", "#"};
                scanner.upToOrEnd(stringArray, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$4($this$parse_u24lambda_u2411, arg_0)));
                scanner.ifStartsWith("/", (Function0<Unit>)((Function0)() -> Companion.parse$lambda$11$lambda$6(scanner, $this$parse_u24lambda_u2411, encoding)));
                scanner.ifStartsWith("?", (Function0<Unit>)((Function0)() -> Companion.parse$lambda$11$lambda$8(scanner, $this$parse_u24lambda_u2411, encoding)));
                scanner.ifStartsWithSkip("#", (Function0<Unit>)((Function0)() -> Companion.parse$lambda$11$lambda$10(scanner, $this$parse_u24lambda_u2411, encoding)));
                url = builder.build();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot parse \"" + value + "\" as a URL", e);
            }
            return url;
        }

        public static /* synthetic */ Url parse$default(Companion companion, String string, UrlEncoding urlEncoding, int n, Object object) {
            if ((n & 2) != 0) {
                urlEncoding = UrlEncoding.Companion.getAll();
            }
            return companion.parse(string, urlEncoding);
        }

        private final Pair<String, String> stringify(Scheme scheme, Host host, int port, UrlPath path, QueryParameters parameters, UserInfo userInfo, Encodable fragment) {
            StringBuilder stringBuilder;
            int splitAt = 0;
            StringBuilder $this$stringify_u24lambda_u2413 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$stringify_u24lambda_u2413.append(scheme.getProtocolName());
            $this$stringify_u24lambda_u2413.append("://");
            $this$stringify_u24lambda_u2413.append(userInfo);
            $this$stringify_u24lambda_u2413.append(HostKt.toUrlString(host));
            if (port != scheme.getDefaultPort()) {
                $this$stringify_u24lambda_u2413.append(":");
                $this$stringify_u24lambda_u2413.append(port);
            }
            splitAt = $this$stringify_u24lambda_u2413.length();
            $this$stringify_u24lambda_u2413.append(path);
            $this$stringify_u24lambda_u2413.append(parameters);
            Encodable encodable = fragment;
            if (encodable != null) {
                Encodable it = encodable;
                boolean bl2 = false;
                $this$stringify_u24lambda_u2413.append('#');
                $this$stringify_u24lambda_u2413.append(it.getEncoded());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String encoded = string;
            String string2 = encoded.substring(splitAt);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String requestRelativePath = TextKt.ensurePrefix(string2, "/");
            return TuplesKt.to((Object)encoded, (Object)requestRelativePath);
        }

        private static final Unit parse$lambda$11$lambda$0(Builder $this_Url, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this_Url.setScheme(Scheme.Companion.parse(it));
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$4$lambda$1(Builder $this_Url, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this_Url.getUserInfo().parseEncoded$runtime_core(it);
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$4$lambda$3(Builder $this_Url, String hostport) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)hostport, (String)"hostport");
                Pair pair = UrlKt.access$parseHostPort(hostport);
                Host h = (Host)pair.component1();
                Integer p = (Integer)pair.component2();
                $this_Url.setHost(h);
                Integer n = p;
                if (n == null) break block0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                $this_Url.setPort(it);
            }
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$4(Builder $this_Url, String authority) {
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            Scanner innerScanner = new Scanner(authority);
            String[] stringArray = new String[]{"@"};
            innerScanner.optionalAndSkip(stringArray, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$4$lambda$1($this_Url, arg_0)));
            innerScanner.upToOrEnd(new String[0], (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$4$lambda$3($this_Url, arg_0)));
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$6$lambda$5(Builder $this_Url, UrlEncoding $encoding, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this_Url.getPath().parse$runtime_core(it, $encoding);
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$6(Scanner $scanner, Builder $this_Url, UrlEncoding $encoding) {
            String[] stringArray = new String[]{"?", "#"};
            $scanner.upToOrEnd(stringArray, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$6$lambda$5($this_Url, $encoding, arg_0)));
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$8$lambda$7(Builder $this_Url, UrlEncoding $encoding, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this_Url.getParameters().parse$runtime_core(it, $encoding);
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$8(Scanner $scanner, Builder $this_Url, UrlEncoding $encoding) {
            String[] stringArray = new String[]{"#"};
            $scanner.upToOrEnd(stringArray, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$8$lambda$7($this_Url, $encoding, arg_0)));
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$10$lambda$9(Builder $this_Url, UrlEncoding $encoding, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this_Url.parseFragment$runtime_core(it, $encoding);
            return Unit.INSTANCE;
        }

        private static final Unit parse$lambda$11$lambda$10(Scanner $scanner, Builder $this_Url, UrlEncoding $encoding) {
            $scanner.upToOrEnd(new String[0], (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.parse$lambda$11$lambda$10$lambda$9($this_Url, $encoding, arg_0)));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

