/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.net.IpV4Addr;
import aws.smithy.kotlin.runtime.net.IpV6Addr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0004\u001a\u00020\u0001*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0013\u0010\b\u001a\u00020\u0001*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\b\u0010\u0003\u001a\u001b\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\t*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0015\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0013\u0010\u000f\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003\u001a\u0013\u0010\u0010\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0003\u001a\u0013\u0010\u0012\u001a\u00020\u0001*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\"\u0014\u0010\u0017\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"", "", "isValidHostname", "(Ljava/lang/String;)Z", "isIpv4", "Laws/smithy/kotlin/runtime/net/IpV4Addr;", "parseIpv4OrNull", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/net/IpV4Addr;", "isIpv6", "", "getIpv6AddressSegments", "(Ljava/lang/String;)Ljava/util/List;", "Laws/smithy/kotlin/runtime/net/IpV6Addr;", "parseIpv6OrNull", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/net/IpV6Addr;", "isIpv6AddressSegment", "isIpv6ZoneId", "", "isHexDigit", "(C)Z", "", "IPV6_SEGMENT_COUNT", "I", "IPV4_MAPPED_IPV6_SEGMENT_COUNT", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Text.kt\naws/smithy/kotlin/runtime/net/TextKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1069#2,2:116\n1069#2,2:134\n1755#3,3:118\n1557#3:121\n1628#3,3:122\n1557#3:126\n1628#3,3:127\n1557#3:130\n1628#3,3:131\n1#4:125\n*S KotlinDebug\n*F\n+ 1 Text.kt\naws/smithy/kotlin/runtime/net/TextKt\n*L\n14#1:116,2\n110#1:134,2\n21#1:118,3\n23#1:121\n23#1:122,3\n85#1:126\n85#1:127,3\n96#1:130\n96#1:131,3\n*E\n"})
public final class TextKt {
    private static final int IPV6_SEGMENT_COUNT = 8;
    private static final int IPV4_MAPPED_IPV6_SEGMENT_COUNT = 7;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalApi
    public static final boolean isValidHostname(@NotNull String $this$isValidHostname) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidHostname, (String)"<this>");
        int n = $this$isValidHostname.length();
        if (1 > n) return false;
        if (n >= 64) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Character.isLetterOrDigit($this$isValidHostname.charAt(0))) return false;
        CharSequence $this$all$iv = StringsKt.drop((String)$this$isValidHostname, (int)1);
        boolean $i$f$all = false;
        int n2 = 0;
        while (n2 < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n2);
            boolean bl2 = false;
            if (!Character.isLetterOrDigit(it)) {
                if (it != '-') return false;
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @InternalApi
    public static final boolean isIpv4(@NotNull String $this$isIpv4) {
        Intrinsics.checkNotNullParameter((Object)$this$isIpv4, (String)"<this>");
        return TextKt.parseIpv4OrNull($this$isIpv4) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IpV4Addr parseIpv4OrNull(@NotNull String $this$parseIpv4OrNull) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        List segments2;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)$this$parseIpv4OrNull, (String)"<this>");
                    char[] cArray = new char[]{'.'};
                    segments2 = StringsKt.split$default((CharSequence)$this$parseIpv4OrNull, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    if (segments2.size() != 4) break block9;
                    Iterable $this$any$iv = segments2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            int n;
                            String it = (String)element$iv2;
                            boolean bl2 = false;
                            Integer n2 = StringsKt.toIntOrNull((String)it);
                            int n3 = n = n2 != null ? n2 : -1;
                            boolean bl3 = 0 <= n ? n < 256 : false;
                            if (!(!bl3)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block10;
            }
            return null;
        }
        Iterable $this$map$iv = segments2;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UStringsKt.toUByte((String)it));
        }
        byte[] octets = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
        return new IpV4Addr(octets);
    }

    @InternalApi
    public static final boolean isIpv6(@NotNull String $this$isIpv6) {
        Intrinsics.checkNotNullParameter((Object)$this$isIpv6, (String)"<this>");
        return TextKt.parseIpv6OrNull($this$isIpv6) != null;
    }

    private static final List<String> getIpv6AddressSegments(String $this$getIpv6AddressSegments) {
        List list;
        List rightSegments;
        List list2;
        List leftSegments;
        List list3;
        String[] stringArray = new String[]{"::"};
        List explicitSegmentGroups = StringsKt.split$default((CharSequence)$this$getIpv6AddressSegments, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (explicitSegmentGroups.size() > 2) {
            return null;
        }
        if (explicitSegmentGroups.size() == 1) {
            stringArray = new String[]{":"};
            return StringsKt.split$default((CharSequence)((CharSequence)explicitSegmentGroups.get(0)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        if (Intrinsics.areEqual(explicitSegmentGroups.get(0), (Object)"")) {
            list3 = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{':'};
            list3 = leftSegments = StringsKt.split$default((CharSequence)((CharSequence)explicitSegmentGroups.get(0)), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        if (Intrinsics.areEqual(explicitSegmentGroups.get(1), (Object)"")) {
            list2 = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{':'};
            list2 = rightSegments = StringsKt.split$default((CharSequence)((CharSequence)explicitSegmentGroups.get(1)), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        if (leftSegments.size() + rightSegments.size() == 8) {
            return null;
        }
        String string = (String)CollectionsKt.lastOrNull((List)rightSegments);
        int totalSegmentCount = (string != null ? StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null) : false) ? 7 : 8;
        int implicitSegmentCount = totalSegmentCount - leftSegments.size() - rightSegments.size();
        List $this$getIpv6AddressSegments_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getIpv6AddressSegments_u24lambda_u244.addAll(leftSegments);
        int n = 0;
        while (n < implicitSegmentCount) {
            int it = n++;
            boolean bl2 = false;
            $this$getIpv6AddressSegments_u24lambda_u244.add("0");
        }
        $this$getIpv6AddressSegments_u24lambda_u244.addAll(rightSegments);
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IpV6Addr parseIpv6OrNull(@NotNull String $this$parseIpv6OrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$parseIpv6OrNull, (String)"<this>");
        char[] cArray = new char[]{'%'};
        List components = StringsKt.split$default((CharSequence)$this$parseIpv6OrNull, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (components.size() > 2) {
            return null;
        }
        if (components.size() == 2 && !TextKt.isIpv6ZoneId((String)components.get(1))) {
            return null;
        }
        String zoneId = components.size() == 2 ? (String)components.get(1) : null;
        List<String> list = TextKt.getIpv6AddressSegments((String)components.get(0));
        if (list == null) {
            return null;
        }
        List<String> segments2 = list;
        if (segments2.size() < 7) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            if (TextKt.isIpv6AddressSegment(segments2.get(i))) continue;
            return null;
        }
        if (segments2.size() == 7) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = segments2.subList(0, 6);
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UShort.box-impl((short)UStringsKt.toUShort((String)it, (int)16)));
            }
            List prefix = (List)destination$iv$iv;
            Object[] $i$f$map22 = new UShort[]{UShort.box-impl((short)0), UShort.box-impl((short)0), UShort.box-impl((short)0), UShort.box-impl((short)0), UShort.box-impl((short)0), UShort.box-impl((short)-1)};
            List mappedPrefixSegments = CollectionsKt.listOf((Object[])$i$f$map22);
            if (!Intrinsics.areEqual((Object)prefix, (Object)mappedPrefixSegments)) {
                return null;
            }
            IpV4Addr ipV4Addr = TextKt.parseIpv4OrNull(segments2.get(6));
            if (ipV4Addr == null) {
                return null;
            }
            IpV4Addr ipv4 = ipV4Addr;
            return ipv4.toMappedIpv6();
        }
        if (segments2.size() != 8) {
            return null;
        }
        if (!TextKt.isIpv6AddressSegment(segments2.get(6)) || !TextKt.isIpv6AddressSegment(segments2.get(7))) {
            return null;
        }
        Iterable $this$map$iv = segments2;
        boolean $i$f$map = false;
        Iterable $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UShort.box-impl((short)UStringsKt.toUShort((String)it, (int)16)));
        }
        List parsedSegments = (List)destination$iv$iv;
        return new IpV6Addr(((UShort)parsedSegments.get(0)).unbox-impl(), ((UShort)parsedSegments.get(1)).unbox-impl(), ((UShort)parsedSegments.get(2)).unbox-impl(), ((UShort)parsedSegments.get(3)).unbox-impl(), ((UShort)parsedSegments.get(4)).unbox-impl(), ((UShort)parsedSegments.get(5)).unbox-impl(), ((UShort)parsedSegments.get(6)).unbox-impl(), ((UShort)parsedSegments.get(7)).unbox-impl(), zoneId, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIpv6AddressSegment(String $this$isIpv6AddressSegment) {
        int n = $this$isIpv6AddressSegment.length();
        if (1 > n) return false;
        if (n >= 5) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = $this$isIpv6AddressSegment;
        boolean $i$f$all = false;
        int n2 = 0;
        while (n2 < $this$all$iv.length()) {
            char element$iv;
            char p0 = element$iv = $this$all$iv.charAt(n2);
            boolean $i$f$isIpv6AddressSegment$stub_for_inlining = false;
            boolean bl2 = false;
            if (!TextKt.isHexDigit(p0)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean isIpv6ZoneId(@NotNull String $this$isIpv6ZoneId) {
        Intrinsics.checkNotNullParameter((Object)$this$isIpv6ZoneId, (String)"<this>");
        return ((CharSequence)$this$isIpv6ZoneId).length() > 0 && !StringsKt.contains$default((CharSequence)$this$isIpv6ZoneId, (char)'%', (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHexDigit(char $this$isHexDigit) {
        boolean bl;
        boolean bl2;
        if ('0' <= $this$isHexDigit) {
            if ($this$isHexDigit < ':') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('a' <= $this$isHexDigit) {
            if ($this$isHexDigit < 'g') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('A' > $this$isHexDigit) return false;
        if ($this$isHexDigit >= 'G') return false;
        return true;
    }
}

