/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0018R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0019R\u001b\u0010\u001f\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u0018\u00a8\u0006!"}, d2={"Laws/smithy/kotlin/runtime/io/RandomAccessFileSource;", "Lokio/Source;", "Ljava/io/File;", "fileObject", "", "start", "endInclusive", "Lokio/Timeout;", "timeout", "<init>", "(Ljava/io/File;JJLokio/Timeout;)V", "", "toString", "()Ljava/lang/String;", "()Lokio/Timeout;", "Lokio/Buffer;", "sink", "byteCount", "read", "(Lokio/Buffer;J)J", "", "close", "()V", "Ljava/io/File;", "J", "Lokio/Timeout;", "Ljava/io/RandomAccessFile;", "file$delegate", "Lkotlin/Lazy;", "getFile", "()Ljava/io/RandomAccessFile;", "file", "position", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nRandomAccessFileSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomAccessFileSource.kt\naws/smithy/kotlin/runtime/io/RandomAccessFileSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class RandomAccessFileSource
implements Source {
    @NotNull
    private final File fileObject;
    private final long endInclusive;
    @NotNull
    private final Timeout timeout;
    @NotNull
    private final Lazy file$delegate;
    private long position;

    public RandomAccessFileSource(@NotNull File fileObject, long start, long endInclusive, @NotNull Timeout timeout) {
        Intrinsics.checkNotNullParameter((Object)fileObject, (String)"fileObject");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.fileObject = fileObject;
        this.endInclusive = endInclusive;
        this.timeout = timeout;
        this.file$delegate = LazyKt.lazy(() -> RandomAccessFileSource.file_delegate$lambda$6(this, start));
        this.position = start;
    }

    public /* synthetic */ RandomAccessFileSource(File file, long l, long l2, Timeout timeout, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeout = Timeout.NONE;
        }
        this(file, l, l2, timeout);
    }

    private final RandomAccessFile getFile() {
        Lazy lazy = this.file$delegate;
        return (RandomAccessFile)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return "RandomAccessFileSource(" + this.fileObject + ')';
    }

    @NotNull
    public Timeout timeout() {
        return this.timeout;
    }

    public long read(@NotNull Buffer sink, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        FileChannel channel = this.getFile().getChannel();
        if (!channel.isOpen()) {
            boolean bl = false;
            String string = "channel is closed";
            throw new IllegalStateException(string.toString());
        }
        if (this.position > this.endInclusive) {
            return -1L;
        }
        long bytesRequested = Math.min(byteCount, this.endInclusive - this.position + 1L);
        long rc = channel.transferTo(this.position, bytesRequested, (WritableByteChannel)sink);
        this.position += rc;
        return rc;
    }

    public void close() {
        this.getFile().close();
    }

    private static final RandomAccessFile file_delegate$lambda$6(RandomAccessFileSource this$0, long $start) {
        RandomAccessFile randomAccessFile;
        if (!this$0.fileObject.exists()) {
            boolean $i$a$-require-RandomAccessFileSource$file$2$62 = false;
            String $i$a$-require-RandomAccessFileSource$file$2$62 = "cannot create SdkSource, file does not exist: " + this$0;
            throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$62.toString());
        }
        if (!this$0.fileObject.isFile()) {
            boolean $i$a$-require-RandomAccessFileSource$file$2$72 = false;
            String $i$a$-require-RandomAccessFileSource$file$2$72 = "cannot create a SdkSource from a directory: " + this$0;
            throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$72.toString());
        }
        if (!($start >= 0L)) {
            boolean $i$a$-require-RandomAccessFileSource$file$2$82 = false;
            String $i$a$-require-RandomAccessFileSource$file$2$82 = "start position should be >= 0, found " + $start;
            throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$82.toString());
        }
        if (!(this$0.endInclusive >= $start - 1L)) {
            boolean $i$a$-require-RandomAccessFileSource$file$2$92 = false;
            String $i$a$-require-RandomAccessFileSource$file$2$92 = "end index " + this$0.endInclusive + " must be greater than or equal to the start index minus one (" + ($start - 1L) + ')';
            throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$92.toString());
        }
        if (!(this$0.endInclusive <= this$0.fileObject.length() - 1L)) {
            boolean $i$a$-require-RandomAccessFileSource$file$2$102 = false;
            String $i$a$-require-RandomAccessFileSource$file$2$102 = "endInclusive should be less than or equal to the length of the file, was " + this$0.endInclusive;
            throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$102.toString());
        }
        RandomAccessFile it = randomAccessFile = new RandomAccessFile(this$0.fileObject, "r");
        boolean bl = false;
        if ($start > 0L) {
            it.seek($start);
        }
        return randomAccessFile;
    }
}

