/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http.android;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Map;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.http.Response;
import microsoft.aspnet.signalr.client.http.StreamResponse;

public class AndroidOkHttpConnection
implements HttpConnection {
    private Logger mLogger;
    private OkHttpClient client;

    public AndroidOkHttpConnection(Logger logger, OkHttpClient client) {
        if (logger == null) {
            throw new IllegalArgumentException("logger");
        }
        this.client = client;
        this.mLogger = logger;
    }

    public HttpConnectionFuture execute(Request request, final HttpConnectionFuture.ResponseCallback responseCallback) {
        final HttpConnectionFuture future = new HttpConnectionFuture();
        com.squareup.okhttp.Request okHttpRequest = AndroidOkHttpConnection.createRequest(request);
        final Call call = this.client.newCall(okHttpRequest);
        call.enqueue(new Callback(){

            public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                if (e instanceof SocketTimeoutException) {
                    AndroidOkHttpConnection.this.mLogger.log("Timeout executing request: " + e.getMessage(), LogLevel.Information);
                    future.triggerTimeout((Throwable)e);
                } else {
                    AndroidOkHttpConnection.this.mLogger.log("Error executing request: " + e.getMessage(), LogLevel.Critical);
                    future.triggerError((Throwable)e);
                }
            }

            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                AndroidOkHttpConnection.this.mLogger.log("Request executed", LogLevel.Verbose);
                InputStream bodyStream = response.body().byteStream();
                Map headersMap = response.headers().toMultimap();
                try {
                    responseCallback.onResponse((Response)new StreamResponse(bodyStream, response.code(), headersMap));
                    future.setResult(null);
                }
                catch (Exception e) {
                    AndroidOkHttpConnection.this.mLogger.log("Error calling onResponse: " + e.getMessage(), LogLevel.Critical);
                    future.triggerError((Throwable)e);
                }
            }
        });
        future.onCancelled(new Runnable(){

            @Override
            public void run() {
                call.cancel();
            }
        });
        return future;
    }

    private static com.squareup.okhttp.Request createRequest(Request request) {
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        okHttpRequestBuilder.url(request.getUrl());
        switch (request.getVerb()) {
            case "GET": {
                okHttpRequestBuilder.get();
                break;
            }
            case "POST": {
                okHttpRequestBuilder.post(RequestBody.create(null, (String)request.getContent()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s is not GET or POST", request.getVerb()));
            }
        }
        for (String key : request.getHeaders().keySet()) {
            okHttpRequestBuilder.addHeader(key, (String)request.getHeaders().get(key));
        }
        return okHttpRequestBuilder.build();
    }
}

