/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http.android;

import android.annotation.SuppressLint;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.os.Build;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.Platform;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.http.Response;
import microsoft.aspnet.signalr.client.http.StreamResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

public class AndroidHttpConnection
implements HttpConnection {
    private Logger mLogger;

    public AndroidHttpConnection(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger");
        }
        this.mLogger = logger;
    }

    public HttpConnectionFuture execute(final Request request, final HttpConnectionFuture.ResponseCallback responseCallback) {
        this.mLogger.log("Create new AsyncTask for HTTP Connection", LogLevel.Verbose);
        final HttpConnectionFuture future = new HttpConnectionFuture();
        final RequestTask requestTask = new RequestTask(){
            AndroidHttpClient mClient;
            InputStream mResponseStream;

            protected Void doInBackground(Void ... voids) {
                if (request == null) {
                    future.triggerError((Throwable)new IllegalArgumentException("request"));
                }
                this.mClient = AndroidHttpClient.newInstance((String)Platform.getUserAgent());
                this.mResponseStream = null;
                try {
                    HttpResponse response;
                    AndroidHttpConnection.this.mLogger.log("Create an Android-specific request", LogLevel.Verbose);
                    request.log(AndroidHttpConnection.this.mLogger);
                    BasicHttpEntityEnclosingRequest realRequest = AndroidHttpConnection.createRealRequest(request);
                    URI uri = new URI(request.getUrl());
                    HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    AndroidHttpConnection.this.mLogger.log("Execute the HTTP Request", LogLevel.Verbose);
                    try {
                        response = this.mClient.execute(host, (HttpRequest)realRequest);
                    }
                    catch (SocketTimeoutException timeoutException) {
                        this.closeStreamAndClient();
                        AndroidHttpConnection.this.mLogger.log("Timeout executing request: " + timeoutException.getMessage(), LogLevel.Information);
                        future.triggerTimeout((Throwable)timeoutException);
                        return null;
                    }
                    AndroidHttpConnection.this.mLogger.log("Request executed", LogLevel.Verbose);
                    this.mResponseStream = response.getEntity().getContent();
                    Header[] headers = response.getAllHeaders();
                    HashMap headersMap = new HashMap();
                    for (Header header : headers) {
                        String headerName = header.getName();
                        if (headersMap.containsKey(headerName)) {
                            ((List)headersMap.get(headerName)).add(header.getValue());
                            continue;
                        }
                        ArrayList<String> headerValues = new ArrayList<String>();
                        headerValues.add(header.getValue());
                        headersMap.put(headerName, headerValues);
                    }
                    responseCallback.onResponse((Response)new StreamResponse(this.mResponseStream, response.getStatusLine().getStatusCode(), headersMap));
                    future.setResult(null);
                    this.closeStreamAndClient();
                }
                catch (Exception e) {
                    this.closeStreamAndClient();
                    AndroidHttpConnection.this.mLogger.log("Error executing request: " + e.getMessage(), LogLevel.Critical);
                    future.triggerError((Throwable)e);
                }
                return null;
            }

            @Override
            protected void closeStreamAndClient() {
                if (this.mResponseStream != null) {
                    try {
                        this.mResponseStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.mClient != null) {
                    this.mClient.close();
                }
            }
        };
        future.onCancelled(new Runnable(){

            @Override
            public void run() {
                AsyncTask<Void, Void, Void> cancelTask = new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... params) {
                        requestTask.closeStreamAndClient();
                        return null;
                    }
                };
                AndroidHttpConnection.this.executeTask((AsyncTask<Void, Void, Void>)((AsyncTask)cancelTask));
            }
        });
        this.executeTask(requestTask);
        return future;
    }

    @SuppressLint(value={"NewApi"})
    private void executeTask(AsyncTask<Void, Void, Void> task) {
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    private static BasicHttpEntityEnclosingRequest createRealRequest(Request request) throws UnsupportedEncodingException {
        BasicHttpEntityEnclosingRequest realRequest = new BasicHttpEntityEnclosingRequest(request.getVerb(), request.getUrl());
        if (request.getContent() != null) {
            realRequest.setEntity((HttpEntity)new StringEntity(request.getContent()));
        }
        Map headers = request.getHeaders();
        for (String key : headers.keySet()) {
            realRequest.addHeader(key, (String)headers.get(key));
        }
        return realRequest;
    }

    private abstract class RequestTask
    extends AsyncTask<Void, Void, Void> {
        private RequestTask() {
        }

        protected abstract void closeStreamAndClient();
    }
}

