/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit5;

import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.PactVerification;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010R\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J7\u0010S\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0001J\u0013\u0010T\u001a\u00020\u001d2\b\u0010U\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u0010V\u001a\u00020WH\u00d6\u0001J\t\u0010X\u001a\u00020\u0003H\u00d6\u0001R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R(\u0010/\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u0015\"\u0004\b1\u0010\u0017R$\u00102\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010#\"\u0004\b4\u0010%R\u0016\u00105\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0015R\u0016\u00107\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0015R\u0014\u00109\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001fR\u0016\u0010;\u001a\u0004\u0018\u00010<X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001fR\u001c\u0010A\u001a\u0004\u0018\u00010BX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001c\u0010G\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010#\"\u0004\bI\u0010%R\u001c\u0010J\u001a\u0004\u0018\u00010KX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006Y"}, d2={"Lau/com/dius/pact/provider/junit5/PluginProvider;", "Lau/com/dius/pact/provider/IProviderInfo;", "name", "", "pactSource", "Lau/com/dius/pact/core/model/PactSource;", "config", "", "", "(Ljava/lang/String;Lau/com/dius/pact/core/model/PactSource;Ljava/util/Map;)V", "getConfig", "()Ljava/util/Map;", "consumers", "", "Lau/com/dius/pact/provider/IConsumerInfo;", "getConsumers", "()Ljava/util/List;", "setConsumers", "(Ljava/util/List;)V", "createClient", "getCreateClient", "()Ljava/lang/Object;", "setCreateClient", "(Ljava/lang/Object;)V", "value", "host", "getHost", "setHost", "insecure", "", "getInsecure", "()Z", "setInsecure", "(Z)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "packagesToScan", "", "getPackagesToScan", "setPackagesToScan", "getPactSource", "()Lau/com/dius/pact/core/model/PactSource;", "path", "getPath", "setPath", "port", "getPort", "setPort", "protocol", "getProtocol", "setProtocol", "requestFilter", "getRequestFilter", "stateChangeRequestFilter", "getStateChangeRequestFilter", "stateChangeTeardown", "getStateChangeTeardown", "stateChangeUrl", "Ljava/net/URL;", "getStateChangeUrl", "()Ljava/net/URL;", "stateChangeUsesBody", "getStateChangeUsesBody", "trustStore", "Ljava/io/File;", "getTrustStore", "()Ljava/io/File;", "setTrustStore", "(Ljava/io/File;)V", "trustStorePassword", "getTrustStorePassword", "setTrustStorePassword", "verificationType", "Lau/com/dius/pact/provider/PactVerification;", "getVerificationType", "()Lau/com/dius/pact/provider/PactVerification;", "setVerificationType", "(Lau/com/dius/pact/provider/PactVerification;)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "junit5"})
public final class PluginProvider
implements IProviderInfo {
    @NotNull
    private String name;
    @Nullable
    private final PactSource pactSource;
    @NotNull
    private final Map<String, Object> config;
    @Nullable
    private PactVerification verificationType;
    @NotNull
    private String path;
    @Nullable
    private final Object requestFilter;
    @Nullable
    private final Object stateChangeRequestFilter;
    @Nullable
    private final URL stateChangeUrl;
    private final boolean stateChangeUsesBody;
    private final boolean stateChangeTeardown;
    @NotNull
    private List<String> packagesToScan;
    @Nullable
    private Object createClient;
    private boolean insecure;
    @Nullable
    private File trustStore;
    @Nullable
    private String trustStorePassword;
    @NotNull
    private List<IConsumerInfo> consumers;

    public PluginProvider(@NotNull String name, @Nullable PactSource pactSource, @NotNull Map<String, Object> config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.name = name;
        this.pactSource = pactSource;
        this.config = config;
        this.verificationType = PactVerification.PLUGIN;
        this.path = "";
        this.stateChangeUsesBody = true;
        this.packagesToScan = CollectionsKt.emptyList();
        this.consumers = new ArrayList();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final PactSource getPactSource() {
        return this.pactSource;
    }

    @NotNull
    public final Map<String, Object> getConfig() {
        return this.config;
    }

    @NotNull
    public String getProtocol() {
        return String.valueOf(this.config.getOrDefault("transport", "http"));
    }

    public void setProtocol(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.config.put("transport", value);
    }

    @Nullable
    public Object getHost() {
        return this.config.getOrDefault("host", "localhost");
    }

    public void setHost(@Nullable Object value) {
        this.config.put("host", value);
    }

    @Nullable
    public Object getPort() {
        return this.config.getOrDefault("port", 8080);
    }

    public void setPort(@Nullable Object value) {
        this.config.put("port", value);
    }

    @Nullable
    public PactVerification getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(@Nullable PactVerification pactVerification) {
        this.verificationType = pactVerification;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @Nullable
    public Object getRequestFilter() {
        return this.requestFilter;
    }

    @Nullable
    public Object getStateChangeRequestFilter() {
        return this.stateChangeRequestFilter;
    }

    @Nullable
    public URL getStateChangeUrl() {
        return this.stateChangeUrl;
    }

    public boolean getStateChangeUsesBody() {
        return this.stateChangeUsesBody;
    }

    public boolean getStateChangeTeardown() {
        return this.stateChangeTeardown;
    }

    @NotNull
    public List<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.packagesToScan = list;
    }

    @Nullable
    public Object getCreateClient() {
        return this.createClient;
    }

    public void setCreateClient(@Nullable Object object) {
        this.createClient = object;
    }

    public boolean getInsecure() {
        return this.insecure;
    }

    public void setInsecure(boolean bl) {
        this.insecure = bl;
    }

    @Nullable
    public File getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(@Nullable File file) {
        this.trustStore = file;
    }

    @Nullable
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(@Nullable String string) {
        this.trustStorePassword = string;
    }

    @NotNull
    public List<IConsumerInfo> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(@NotNull List<IConsumerInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.consumers = list;
    }

    @NotNull
    public final String component1() {
        return this.getName();
    }

    @Nullable
    public final PactSource component2() {
        return this.pactSource;
    }

    @NotNull
    public final Map<String, Object> component3() {
        return this.config;
    }

    @NotNull
    public final PluginProvider copy(@NotNull String name, @Nullable PactSource pactSource, @NotNull Map<String, Object> config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return new PluginProvider(name, pactSource, config);
    }

    public static /* synthetic */ PluginProvider copy$default(PluginProvider pluginProvider, String string, PactSource pactSource, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = pluginProvider.getName();
        }
        if ((n & 2) != 0) {
            pactSource = pluginProvider.pactSource;
        }
        if ((n & 4) != 0) {
            map = pluginProvider.config;
        }
        return pluginProvider.copy(string, pactSource, map);
    }

    @NotNull
    public String toString() {
        return "PluginProvider(name=" + this.getName() + ", pactSource=" + this.pactSource + ", config=" + this.config + ")";
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = result * 31 + (this.pactSource == null ? 0 : this.pactSource.hashCode());
        result = result * 31 + ((Object)this.config).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginProvider)) {
            return false;
        }
        PluginProvider pluginProvider = (PluginProvider)other;
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)pluginProvider.getName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pactSource, (Object)pluginProvider.pactSource)) {
            return false;
        }
        return Intrinsics.areEqual(this.config, pluginProvider.config);
    }
}

