/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.descriptions;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.runner.Description;
import org.junit.runners.model.TestClass;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lau/com/dius/pact/provider/junit/descriptions/DescriptionGenerator;", "I", "Lau/com/dius/pact/core/model/Interaction;", "", "testClass", "Lorg/junit/runners/model/TestClass;", "pact", "Lau/com/dius/pact/core/model/Pact;", "pactSource", "Lau/com/dius/pact/core/model/PactSource;", "(Lorg/junit/runners/model/TestClass;Lau/com/dius/pact/core/model/Pact;Lau/com/dius/pact/core/model/PactSource;)V", "consumerName", "", "generate", "Lorg/junit/runner/Description;", "interaction", "getTagDescription", "pending", "junit"})
public final class DescriptionGenerator<I extends Interaction> {
    private final TestClass testClass;
    private final Pact<I> pact;
    private final PactSource pactSource;

    @NotNull
    public final Description generate(@NotNull Interaction interaction) {
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Description description = Description.createTestDescription((Class)this.testClass.getJavaClass(), (String)(this.consumerName() + ' ' + this.getTagDescription() + "- Upon " + interaction.getDescription() + this.pending()));
        Intrinsics.checkExpressionValueIsNotNull((Object)description, (String)"Description.createTestDe\u2026ption}${this.pending()}\")");
        return description;
    }

    private final String consumerName() {
        String string;
        if (this.pact.getSource() instanceof BrokerUrlSource) {
            PactSource pactSource = this.pact.getSource();
            if (pactSource == null) {
                throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.core.model.BrokerUrlSource");
            }
            BrokerUrlSource source = (BrokerUrlSource)pactSource;
            string = source.getResult();
            if (string == null || (string = string.getName()) == null) {
                string = this.pact.getConsumer().getName();
            }
        } else {
            string = this.pact.getConsumer().getName();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String pending() {
        if (!(this.pact.getSource() instanceof BrokerUrlSource)) return "";
        PactSource pactSource = this.pact.getSource();
        if (pactSource == null) {
            throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.core.model.BrokerUrlSource");
        }
        BrokerUrlSource source = (BrokerUrlSource)pactSource;
        if (source.getResult() == null) return "";
        PactBrokerResult pactBrokerResult = source.getResult();
        if (pactBrokerResult == null) {
            Intrinsics.throwNpe();
        }
        if (!pactBrokerResult.getPending()) return "";
        return " <PENDING>";
    }

    private final String getTagDescription() {
        if (this.pactSource instanceof BrokerUrlSource && KotlinLanguageSupportKt.isNotEmpty((String)((BrokerUrlSource)this.pactSource).getTag())) {
            return "[tag:" + ((BrokerUrlSource)this.pactSource).getTag() + "] ";
        }
        return "";
    }

    public DescriptionGenerator(@NotNull TestClass testClass, @NotNull Pact<I> pact, @NotNull PactSource pactSource) {
        Intrinsics.checkParameterIsNotNull((Object)testClass, (String)"testClass");
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)pactSource, (String)"pactSource");
        this.testClass = testClass;
        this.pact = pact;
        this.pactSource = pactSource;
    }
}

