/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.DirectorySource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactFolder;
import au.com.dius.pact.provider.junitsupport.loader.PactFolderLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B9\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0002J$\u0010\u0019\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactFolderLoader;", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "path", "", "valueResolverClass", "Lkotlin/reflect/KClass;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "valueResolver", "ep", "Lau/com/dius/pact/core/support/expressions/ExpressionParser;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Lau/com/dius/pact/core/support/expressions/ValueResolver;Lau/com/dius/pact/core/support/expressions/ExpressionParser;)V", "pactFolder", "Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "pactSource", "Lau/com/dius/pact/core/model/DirectorySource;", "description", "getPactSource", "load", "", "Lau/com/dius/pact/core/model/Pact;", "providerName", "resolvePath", "setupValueResolver", "provider"})
public final class PactFolderLoader
implements PactLoader {
    @NotNull
    private final File path;
    @NotNull
    private final DirectorySource pactSource;

    @JvmOverloads
    public PactFolderLoader(@NotNull String path, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver, @NotNull ExpressionParser ep) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ep, (String)"ep");
        ValueResolver resolver = this.setupValueResolver(valueResolver, valueResolverClass);
        Object object = ExpressionParser.parseExpression$default((ExpressionParser)ep, (String)path, (DataType)DataType.STRING, (ValueResolver)resolver, (boolean)false, (int)8, null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String interpolatedPath = (String)object;
        this.path = new File(interpolatedPath);
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }

    public /* synthetic */ PactFolderLoader(String string, KClass kClass, ValueResolver valueResolver, ExpressionParser expressionParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        if ((n & 4) != 0) {
            valueResolver = null;
        }
        if ((n & 8) != 0) {
            expressionParser = new ExpressionParser(null, null, 3, null);
        }
        this(string, (KClass<? extends ValueResolver>)kClass, valueResolver, expressionParser);
    }

    public PactFolderLoader(@NotNull PactFolder pactFolder) {
        Intrinsics.checkNotNullParameter((Object)pactFolder, (String)"pactFolder");
        this(pactFolder.value(), Reflection.getOrCreateKotlinClass(pactFolder.valueResolver()), null, null, 12, null);
    }

    public PactFolderLoader(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }

    @Override
    @NotNull
    public String description() {
        return "Directory(" + this.pactSource.getDir() + ")";
    }

    @Override
    @NotNull
    public List<Pact> load(@NotNull String providerName) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        List pacts = new ArrayList();
        File pactFolder = this.resolvePath();
        File[] files = pactFolder.listFiles(PactFolderLoader::load$lambda-0);
        if (files != null) {
            for (File file : files) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                Pact pact = DefaultPactReader.INSTANCE.loadPact((Object)file);
                if (!Intrinsics.areEqual((Object)pact.getProvider().getName(), (Object)providerName)) continue;
                pacts.add(pact);
                this.pactSource.getPacts().put(file, pact);
            }
        }
        return pacts;
    }

    @NotNull
    public DirectorySource getPactSource() {
        return this.pactSource;
    }

    private final File resolvePath() {
        URL resourcePath = Thread.currentThread().getContextClassLoader().getResource(this.path.getPath());
        if (resourcePath == null) {
            return this.path;
        }
        return new File(URLDecoder.decode(resourcePath.getPath(), "UTF-8"));
    }

    private final ValueResolver setupValueResolver(ValueResolver valueResolver, KClass<? extends ValueResolver> valueResolverClass) {
        ValueResolver resolver;
        ValueResolver valueResolver2 = valueResolver;
        if (valueResolver2 == null) {
            valueResolver2 = resolver = (ValueResolver)SystemPropertyResolver.INSTANCE;
        }
        if (valueResolverClass != null) {
            if (valueResolverClass.getObjectInstance() != null) {
                Object object = valueResolverClass.getObjectInstance();
                Intrinsics.checkNotNull((Object)object);
                resolver = (ValueResolver)object;
            } else {
                try {
                    Object t = JvmClassMappingKt.getJavaClass(valueResolverClass).newInstance();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"valueResolverClass.java.newInstance()");
                    resolver = (ValueResolver)t;
                }
                catch (InstantiationException e) {
                    PactBrokerLoader.Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.1.INSTANCE);
                }
                catch (IllegalAccessException e) {
                    PactBrokerLoader.Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.2.INSTANCE);
                }
            }
        }
        return resolver;
    }

    @JvmOverloads
    public PactFolderLoader(@NotNull String path, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, valueResolverClass, valueResolver, null, 8, null);
    }

    @JvmOverloads
    public PactFolderLoader(@NotNull String path, @Nullable KClass<? extends ValueResolver> valueResolverClass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, valueResolverClass, null, null, 12, null);
    }

    @JvmOverloads
    public PactFolderLoader(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, null, null, null, 14, null);
    }

    private static final boolean load$lambda-0(File file, String name) {
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        return StringsKt.endsWith$default((String)name, (String)".json", (boolean)false, (int)2, null);
    }
}

