/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.reporters;

import au.com.dius.pact.core.matchers.BodyTypeMismatch;
import au.com.dius.pact.core.matchers.HeaderMismatch;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.pactbroker.VerificationNotice;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonToken;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.provider.BodyComparisonResult;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.VerificationResult;
import au.com.dius.pact.provider.reporters.BaseVerifierReporter;
import au.com.dius.pact.provider.reporters.Event;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import java.io.File;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 m2\u00020\u0001:\u0001mB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020$H\u0016J\u0016\u0010(\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u001c\u0010(\u001a\u00020$2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020&0,H\u0016J\u0010\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020$H\u0016J\b\u00101\u001a\u00020$H\u0016J&\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u00032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010%\u001a\u00020&H\u0016J\u001e\u00105\u001a\u00020$2\u0006\u00103\u001a\u00020\u00032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0016J\b\u00106\u001a\u00020$H\u0016J\b\u00107\u001a\u00020$H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0016J\"\u0010<\u001a\u00020$2\u0006\u00103\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u00010&2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010=\u001a\u00020$H\u0016J\u001a\u0010=\u001a\u00020$2\u0006\u00103\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u00010&H\u0016J\u0018\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0003H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020DH\u0016J\"\u0010E\u001a\u00020$2\u0006\u0010?\u001a\u00020@2\u0006\u00109\u001a\u00020:2\b\u0010F\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010G\u001a\u00020$2\u0006\u0010?\u001a\u00020@2\u0006\u00109\u001a\u00020:2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0*H\u0016J4\u0010J\u001a\u00020$2\u0006\u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u0010K\u001a\u00020\u00032\n\u0010L\u001a\u00060Mj\u0002`N2\u0006\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020$H\u0016J(\u0010R\u001a\u00020$2\u0006\u0010S\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010T\u001a\u00020P2\u0006\u0010U\u001a\u00020\u0003H\u0016J,\u0010V\u001a\u00020$2\u0006\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020P2\n\u0010L\u001a\u00060Mj\u0002`N2\u0006\u0010O\u001a\u00020PH\u0016J(\u0010W\u001a\u00020$2\u0006\u0010S\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010?\u001a\u00020@2\u0006\u0010T\u001a\u00020PH\u0016J\u0018\u0010X\u001a\u00020$2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010[\u001a\u00020$2\u0006\u0010Y\u001a\u00020ZH\u0016J$\u0010\\\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\n\u0010L\u001a\u00060Mj\u0002`N2\u0006\u0010O\u001a\u00020PH\u0016J\u0018\u0010]\u001a\u00020$2\u0006\u0010^\u001a\u00020_2\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010`\u001a\u00020$2\u0006\u0010a\u001a\u00020b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010c\u001a\u00020$2\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020$2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010g\u001a\u00020$2\u0006\u0010h\u001a\u00020\u0003H\u0016J\b\u0010i\u001a\u00020$H\u0016J \u0010j\u001a\u00020$2\u0006\u0010S\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010?\u001a\u00020@H\u0016J(\u0010k\u001a\u00020$2\u0006\u0010S\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010T\u001a\u00020P2\u0006\u0010l\u001a\u00020&H\u0016R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00069"}, d2={"Lau/com/dius/pact/provider/reporters/JsonReporter;", "Lau/com/dius/pact/provider/reporters/BaseVerifierReporter;", "name", "", "reportDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "jsonData", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "ext", "providerName", "(Ljava/lang/String;Ljava/io/File;Lau/com/dius/pact/core/support/json/JsonValue$Object;Ljava/lang/String;Ljava/lang/String;)V", "getExt", "()Ljava/lang/String;", "setExt", "(Ljava/lang/String;)V", "getJsonData", "()Lau/com/dius/pact/core/support/json/JsonValue$Object;", "setJsonData", "(Lau/com/dius/pact/core/support/json/JsonValue$Object;)V", "getName", "setName", "getReportDir", "()Ljava/io/File;", "setReportDir", "(Ljava/io/File;)V", "reportFile", "getReportFile", "setReportFile", "verifier", "Lau/com/dius/pact/provider/IProviderVerifier;", "getVerifier", "()Lau/com/dius/pact/provider/IProviderVerifier;", "setVerifier", "(Lau/com/dius/pact/provider/IProviderVerifier;)V", "bodyComparisonFailed", "", "comparison", "", "bodyComparisonOk", "displayFailures", "failures", "", "Lau/com/dius/pact/provider/VerificationResult$Failed;", "", "errorHasNoAnnotatedMethodsFoundForInteraction", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "finaliseReport", "generatesAMessageWhich", "headerComparisonFailed", "key", "value", "headerComparisonOk", "includesHeaders", "includesMetadata", "initialise", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "interactionDescription", "metadataComparisonFailed", "metadataComparisonOk", "pactLoadFailureForConsumer", "consumer", "Lau/com/dius/pact/provider/IConsumerInfo;", "message", "receive", "event", "Lau/com/dius/pact/provider/reporters/Event;", "reportVerificationForConsumer", "tag", "reportVerificationNoticesForConsumer", "notices", "Lau/com/dius/pact/core/pactbroker/VerificationNotice;", "requestFailed", "interactionMessage", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "printStackTrace", "", "returnsAResponseWhich", "stateChangeRequestFailed", "state", "isSetup", "httpStatus", "stateChangeRequestFailedWithException", "stateForInteraction", "statusComparisonFailed", "status", "", "statusComparisonOk", "verificationFailed", "verifyConsumerFromFile", "pactFile", "Lau/com/dius/pact/core/model/PactSource;", "verifyConsumerFromUrl", "pactUrl", "Lau/com/dius/pact/core/model/UrlPactSource;", "warnPactFileHasNoInteractions", "pact", "Lau/com/dius/pact/core/model/Pact;", "warnProviderHasNoConsumers", "warnPublishResultsSkippedBecauseDisabled", "envVar", "warnPublishResultsSkippedBecauseFiltered", "warnStateChangeIgnored", "warnStateChangeIgnoredDueToInvalidUrl", "stateChangeHandler", "Companion"})
public final class JsonReporter
extends BaseVerifierReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @Nullable
    private File reportDir;
    @NotNull
    private JsonValue.Object jsonData;
    @NotNull
    private String ext;
    @Nullable
    private String providerName;
    public File reportFile;
    public IProviderVerifier verifier;
    @NotNull
    public static final String REPORT_FORMAT = "0.1.0";
    @NotNull
    public static final String FAILED = "failed";

    public JsonReporter(@NotNull String name, @Nullable File reportDir, @NotNull JsonValue.Object jsonData, @NotNull String ext, @Nullable String providerName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)jsonData, (String)"jsonData");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        this.name = name;
        this.reportDir = reportDir;
        this.jsonData = jsonData;
        this.ext = ext;
        this.providerName = providerName;
        if (this.getReportDir() == null) {
            this.setReportDir(new File(System.getProperty("user.dir")));
        }
        this.setReportFile(new File(this.getReportDir(), this.name + this.getExt()));
    }

    public /* synthetic */ JsonReporter(String string, File file, JsonValue.Object object, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "json";
        }
        if ((n & 4) != 0) {
            object = new JsonValue.Object(null, 1, null);
        }
        if ((n & 8) != 0) {
            string2 = ".json";
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        this(string, file, object, string2, string3);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @Nullable
    public File getReportDir() {
        return this.reportDir;
    }

    @Override
    public void setReportDir(@Nullable File file) {
        this.reportDir = file;
    }

    @NotNull
    public final JsonValue.Object getJsonData() {
        return this.jsonData;
    }

    public final void setJsonData(@NotNull JsonValue.Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.jsonData = object;
    }

    @Override
    @NotNull
    public String getExt() {
        return this.ext;
    }

    public void setExt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ext = string;
    }

    public JsonReporter(@NotNull String name, @Nullable File reportDir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, reportDir, new JsonValue.Object(null, 1, null), ".json", null);
    }

    @Override
    @NotNull
    public File getReportFile() {
        File file = this.reportFile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"reportFile");
        return null;
    }

    @Override
    public void setReportFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.reportFile = file;
    }

    @Override
    @NotNull
    public IProviderVerifier getVerifier() {
        IProviderVerifier iProviderVerifier = this.verifier;
        if (iProviderVerifier != null) {
            return iProviderVerifier;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"verifier");
        return null;
    }

    @Override
    public void setVerifier(@NotNull IProviderVerifier iProviderVerifier) {
        Intrinsics.checkNotNullParameter((Object)iProviderVerifier, (String)"<set-?>");
        this.verifier = iProviderVerifier;
    }

    @Override
    public void initialise(@NotNull IProviderInfo provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.providerName = provider.getName();
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"date", (Object)ZonedDateTime.now().toString()), TuplesKt.to((Object)"pactJvmVersion", (Object)BasePact.Companion.lookupVersion()), TuplesKt.to((Object)"reportFormat", (Object)REPORT_FORMAT)};
        pairArray[0] = TuplesKt.to((Object)"metaData", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)this.providerName)};
        pairArray[1] = TuplesKt.to((Object)"provider", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        pairArray[2] = TuplesKt.to((Object)"execution", (Object)new JsonValue.Array(null, 1, null));
        this.jsonData = JsonKt.jsonObject((Pair[])pairArray);
        File file = this.getReportDir();
        Intrinsics.checkNotNull((Object)file);
        file.mkdirs();
        this.setReportFile(new File(this.getReportDir(), this.providerName + this.getExt()));
    }

    @Override
    public void finaliseReport() {
        if (this.jsonData.isNotEmpty()) {
            if (this.getReportFile().exists() && this.getReportFile().length() > 0L) {
                JsonValue existingContents = JsonParser.parseString((String)FilesKt.readText$default((File)this.getReportFile(), null, (int)1, null));
                if (existingContents instanceof JsonValue.Object && existingContents.has("provider") && Intrinsics.areEqual((Object)this.providerName, (Object)((JsonValue.Object)existingContents).get("provider").get((Object)"name").asString())) {
                    ((JsonValue.Object)existingContents).set("metaData", (Object)this.jsonData.get("metaData"));
                    JsonValue.Array array = ((JsonValue.Object)existingContents).get("execution").asArray();
                    Intrinsics.checkNotNull((Object)array);
                    array.addAll(this.jsonData.get("execution"));
                    FilesKt.writeText$default((File)this.getReportFile(), (String)existingContents.serialise(), null, (int)2, null);
                } else {
                    FilesKt.writeText$default((File)this.getReportFile(), (String)this.jsonData.serialise(), null, (int)2, null);
                }
            } else {
                FilesKt.writeText$default((File)this.getReportFile(), (String)this.jsonData.serialise(), null, (int)2, null);
            }
        }
    }

    @Override
    public void reportVerificationForConsumer(@NotNull IConsumerInfo consumer, @NotNull IProviderInfo provider, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Object object = new Pair[3];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)consumer.getName())};
        object[0] = TuplesKt.to((Object)"consumer", (Object)JsonKt.jsonObject((Pair[])pairArray));
        object[1] = TuplesKt.to((Object)"interactions", (Object)new JsonValue.Array(null, 1, null));
        object[2] = TuplesKt.to((Object)"pending", (Object)consumer.getPending());
        JsonValue.Object jsonObject = JsonKt.jsonObject((Pair[])object);
        if (KotlinLanguageSupportKt.isNotEmpty((String)tag)) {
            String string = tag;
            Intrinsics.checkNotNull((Object)string);
            object = string;
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = ((String)object2).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            jsonObject.add("tag", (JsonValue)new JsonValue.StringValue(new JsonToken.StringValue(cArray)));
        }
        this.jsonData.get("execution").add((JsonValue)jsonObject);
    }

    @Override
    public void verifyConsumerFromUrl(@NotNull UrlPactSource pactUrl, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)pactUrl, (String)"pactUrl");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Object object = array.last().get((Object)"consumer").asObject();
        Intrinsics.checkNotNull((Object)object);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)pactUrl.getUrl())};
        object.set("source", (Object)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void verifyConsumerFromFile(@NotNull PactSource pactFile, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)pactFile, (String)"pactFile");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Object object = array.last().get((Object)"consumer").asObject();
        Intrinsics.checkNotNull((Object)object);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"file", (Object)(pactFile instanceof FileSource ? ((FileSource)pactFile).getFile().toString() : pactFile.description()))};
        object.set("source", (Object)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void pactLoadFailureForConsumer(@NotNull IConsumerInfo consumer, @NotNull String message) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.jsonData.get("execution").size() == 0) {
            pairArray = new Pair[2];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)consumer.getName())};
            pairArray[0] = TuplesKt.to((Object)"consumer", (Object)JsonKt.jsonObject((Pair[])pairArray2));
            pairArray[1] = TuplesKt.to((Object)"interactions", (Object)new JsonValue.Array(null, 1, null));
            this.jsonData.get("execution").add((JsonValue)JsonKt.jsonObject((Pair[])pairArray));
        }
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Object object = array.last().asObject();
        Intrinsics.checkNotNull((Object)object);
        pairArray = new Pair[]{TuplesKt.to((Object)"state", (Object)"Pact Load Failure"), TuplesKt.to((Object)"message", (Object)message)};
        object.set("result", (Object)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void warnProviderHasNoConsumers(@NotNull IProviderInfo provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
    }

    @Override
    public void warnPactFileHasNoInteractions(@NotNull Pact pact) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
    }

    @Override
    public void interactionDescription(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"interaction", (Object)Json.toJson((Object)interaction.toMap(PactSpecVersion.V3)));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"result", (Object)"OK")};
        pairArray[1] = TuplesKt.to((Object)"verification", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        array2.add((JsonValue)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void stateForInteraction(@NotNull String state, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, boolean isSetup) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
    }

    @Override
    public void warnStateChangeIgnored(@NotNull String state, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
    }

    @Override
    public void stateChangeRequestFailedWithException(@NotNull String state, boolean isSetup, @NotNull Exception e, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Array interactions = array2;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"result", (Object)FAILED);
        pairArray[1] = TuplesKt.to((Object)"message", (Object)("State change '" + state + "' callback failed"));
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to((Object)"message", (Object)e.getMessage());
        String[] stringArray = ExceptionUtils.getStackFrames((Throwable)e);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getStackFrames(e)");
        pairArray2[1] = TuplesKt.to((Object)"stackTrace", (Object)JsonKt.jsonArray((List)ArraysKt.toList((Object[])stringArray)));
        pairArray[2] = TuplesKt.to((Object)"exception", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        JsonValue.Object error = JsonKt.jsonObject((Pair[])pairArray);
        if (interactions.size() == 0) {
            pairArray = new Pair[]{TuplesKt.to((Object)"verification", (Object)error)};
            interactions.add((JsonValue)JsonKt.jsonObject((Pair[])pairArray));
        } else {
            JsonValue.Object object = interactions.last().asObject();
            Intrinsics.checkNotNull((Object)object);
            object.set("verification", (Object)error);
        }
    }

    @Override
    public void stateChangeRequestFailed(@NotNull String state, @NotNull IProviderInfo provider, boolean isSetup, @NotNull String httpStatus) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)httpStatus, (String)"httpStatus");
    }

    @Override
    public void warnStateChangeIgnoredDueToInvalidUrl(@NotNull String state, @NotNull IProviderInfo provider, boolean isSetup, @NotNull Object stateChangeHandler) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)stateChangeHandler, (String)"stateChangeHandler");
    }

    @Override
    public void requestFailed(@NotNull IProviderInfo provider, @NotNull Interaction interaction, @NotNull String interactionMessage, @NotNull Exception e, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)interactionMessage, (String)"interactionMessage");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().asObject();
        Intrinsics.checkNotNull((Object)object);
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"result", (Object)FAILED);
        pairArray[1] = TuplesKt.to((Object)"message", (Object)interactionMessage);
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to((Object)"message", (Object)e.getMessage());
        String[] stringArray = ExceptionUtils.getStackFrames((Throwable)e);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getStackFrames(e)");
        pairArray2[1] = TuplesKt.to((Object)"stackTrace", (Object)JsonKt.jsonArray((List)ArraysKt.toList((Object[])stringArray)));
        pairArray[2] = TuplesKt.to((Object)"exception", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        object.set("verification", (Object)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void returnsAResponseWhich() {
    }

    @Override
    public void statusComparisonOk(int status) {
    }

    @Override
    public void statusComparisonFailed(int status, @NotNull Object comparison) {
        List list;
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().get((Object)"verification").asObject();
        Intrinsics.checkNotNull((Object)object);
        JsonValue.Object verification = object;
        verification.set("result", (Object)FAILED);
        if (KotlinLanguageSupportKt.hasProperty((Object)comparison, (String)"message")) {
            Object object2 = KotlinLanguageSupportKt.property((Object)comparison, (String)"message");
            Object object3 = object2 == null ? null : object2.get(comparison);
            object2 = new char[1];
            object2[0] = (KProperty1)10;
            list = StringsKt.split$default((CharSequence)String.valueOf(object3), (char[])object2, (boolean)false, (int)0, (int)6, null);
        } else {
            char[] cArray = new char[]{'\n'};
            list = StringsKt.split$default((CharSequence)comparison.toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        JsonValue statusJson = JsonKt.jsonArray((List)list);
        verification.set("status", (Object)statusJson);
    }

    @Override
    public void includesHeaders() {
    }

    @Override
    public void headerComparisonOk(@NotNull String key, @NotNull List<String> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void headerComparisonFailed(@NotNull String key, @NotNull List<String> value, @NotNull Object comparison) {
        JsonValue jsonValue;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().get((Object)"verification").asObject();
        Intrinsics.checkNotNull((Object)object);
        JsonValue.Object verification = object;
        verification.set("result", (Object)FAILED);
        if (!verification.has("header")) {
            verification.set("header", (Object)JsonKt.jsonObject((Pair[])new Pair[0]));
        }
        JsonValue.Object object2 = verification.get("header").asObject();
        JsonValue.Object object3 = object2;
        Intrinsics.checkNotNull((Object)object2);
        String string = key;
        Object object4 = comparison;
        if (object4 instanceof List) {
            Collection<JsonValue> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)comparison;
            String string2 = string;
            JsonValue.Object object5 = object3;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                JsonValue jsonValue2;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                void var15_17 = it;
                if (var15_17 instanceof HeaderMismatch) {
                    String string3 = ((HeaderMismatch)it).getMismatch();
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray = string4.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    jsonValue2 = (JsonValue)new JsonValue.StringValue(new JsonToken.StringValue(cArray));
                } else {
                    jsonValue2 = Json.toJson((Object)it);
                }
                JsonValue jsonValue3 = jsonValue2;
                collection.add(jsonValue3);
            }
            collection = (List)destination$iv$iv;
            object3 = object5;
            string = string2;
            jsonValue = Json.toJson((Object)collection);
        } else {
            jsonValue = Json.toJson((Object)comparison);
        }
        object3.set(string, (Object)jsonValue);
    }

    @Override
    public void bodyComparisonOk() {
    }

    @Override
    public void bodyComparisonFailed(@NotNull Object comparison) {
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().get((Object)"verification").asObject();
        Intrinsics.checkNotNull((Object)object);
        JsonValue.Object verification = object;
        verification.set("result", (Object)FAILED);
        Object object2 = comparison;
        verification.set("body", (Object)(object2 instanceof Err ? Json.toJson((Object)((BodyTypeMismatch)((Err)comparison).getError()).description()) : (object2 instanceof Ok ? (JsonValue)((BodyComparisonResult)((Ok)comparison).getValue()).toJson() : Json.toJson((Object)comparison))));
    }

    @Override
    public void errorHasNoAnnotatedMethodsFoundForInteraction(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().asObject();
        Intrinsics.checkNotNull((Object)object);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"result", (Object)FAILED);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"message", (Object)"No Annotated Methods Found For Interaction")};
        pairArray[1] = TuplesKt.to((Object)"cause", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        object.set("verification", (Object)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void verificationFailed(@NotNull Interaction interaction, @NotNull Exception e, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().asObject();
        Intrinsics.checkNotNull((Object)object);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"result", (Object)FAILED);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"message", (Object)e.getMessage()), TuplesKt.to((Object)"stackTrace", (Object)ExceptionUtils.getStackFrames((Throwable)e))};
        pairArray[1] = TuplesKt.to((Object)"exception", (Object)JsonKt.jsonObject((Pair[])pairArray2));
        object.set("verification", (Object)JsonKt.jsonObject((Pair[])pairArray));
    }

    @Override
    public void generatesAMessageWhich() {
    }

    @Override
    public void displayFailures(@NotNull Map<String, ? extends Object> failures) {
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
    }

    @Override
    public void displayFailures(@NotNull List<VerificationResult.Failed> failures) {
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
    }

    @Override
    public void metadataComparisonFailed(@NotNull String key, @Nullable Object value, @NotNull Object comparison) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Array array2 = array.last().get((Object)"interactions").asArray();
        Intrinsics.checkNotNull((Object)array2);
        JsonValue.Object object = array2.last().get((Object)"verification").asObject();
        Intrinsics.checkNotNull((Object)object);
        JsonValue.Object verification = object;
        verification.set("result", (Object)FAILED);
        if (!verification.has("metadata")) {
            verification.set("metadata", (Object)JsonKt.jsonObject((Pair[])new Pair[0]));
        }
        JsonValue.Object object2 = verification.get("metadata").asObject();
        Intrinsics.checkNotNull((Object)object2);
        object2.set(key, comparison);
    }

    @Override
    public void includesMetadata() {
    }

    @Override
    public void metadataComparisonOk(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
    }

    @Override
    public void metadataComparisonOk() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportVerificationNoticesForConsumer(@NotNull IConsumerInfo consumer, @NotNull IProviderInfo provider, @NotNull List<VerificationNotice> notices) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(notices, (String)"notices");
        JsonValue.Array array = this.jsonData.get("execution").asArray();
        Intrinsics.checkNotNull((Object)array);
        JsonValue.Object object = array.last().get((Object)"consumer").asObject();
        Intrinsics.checkNotNull((Object)object);
        Iterable iterable = notices;
        String string = "notices";
        JsonValue.Object object2 = object;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VerificationNotice verificationNotice = (VerificationNotice)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getText();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        object2.set(string, (Object)JsonKt.jsonArray((List)collection));
    }

    @Override
    public void warnPublishResultsSkippedBecauseFiltered() {
    }

    @Override
    public void warnPublishResultsSkippedBecauseDisabled(@NotNull String envVar) {
        Intrinsics.checkNotNullParameter((Object)envVar, (String)"envVar");
    }

    @Override
    public void receive(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Event event2 = event;
        if (event2 instanceof Event.DisplayInteractionComments) {
            JsonValue.Array array = this.jsonData.get("execution").asArray();
            Intrinsics.checkNotNull((Object)array);
            JsonValue.Object object = array.last().get((Object)"consumer").asObject();
            Intrinsics.checkNotNull((Object)object);
            object.set("comments", (Object)new JsonValue.Object(MapsKt.toMutableMap(((Event.DisplayInteractionComments)event).getComments())));
        } else {
            super.receive(event);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lau/com/dius/pact/provider/reporters/JsonReporter$Companion;", "", "()V", "FAILED", "", "REPORT_FORMAT", "provider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

