/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.matchers.util.CollectionUtilsKt;
import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactBrokerSource;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.ConsumerVersionSelector;
import au.com.dius.pact.core.pactbroker.IPactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Utils;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.junitsupport.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junitsupport.loader.OverrideablePactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactBroker;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerLoader;
import au.com.dius.pact.provider.junitsupport.loader.VersionSelector;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import mu.KLogging;
import org.apache.hc.core5.net.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 b2\u00020\u0001:\u0001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u00bf\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010E\u001a\u00020F2\u0006\u0010@\u001a\u00020\u0014J\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\n2\u0006\u0010@\u001a\u00020\u0014J\b\u0010I\u001a\u00020\u0006H\u0016J\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u0010@\u001a\u00020\u0014J\n\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0018\u0010O\u001a\u00020\u00062\u0006\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020RH\u0002J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\n2\u0006\u0010P\u001a\u00020\u0006H\u0016J,\u0010U\u001a\b\u0012\u0004\u0012\u00020T0\n2\u0006\u0010P\u001a\u00020\u00062\f\u0010V\u001a\b\u0012\u0004\u0012\u00020H0\n2\u0006\u0010@\u001a\u00020\u0014H\u0002J\u0018\u0010W\u001a\u00020R2\u0006\u0010X\u001a\u00020Y2\u0006\u0010@\u001a\u00020\u0014H\u0016J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00062\u0006\u0010]\u001a\u00020\u0006H\u0016J\u0010\u0010^\u001a\u00020[2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010_\u001a\u00020\u0014H\u0002J*\u0010`\u001a\u00020\u000f2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010@\u001a\u00020\u0014R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\"R\u0010\u0010*\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010-R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b/\u00100\u001a\u0004\b1\u0010\"R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b2\u00100\u001a\u0004\b3\u0010\"R\u001e\u0010\b\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b4\u00100\u001a\u0004\b5\u0010\"R$\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u00100\u001a\u0004\b7\u0010-R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\"R\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010-R\u0010\u0010@\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006c"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerLoader;", "Lau/com/dius/pact/provider/junitsupport/loader/OverrideablePactLoader;", "pactBroker", "Lau/com/dius/pact/provider/junitsupport/loader/PactBroker;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactBroker;)V", "pactBrokerHost", "", "pactBrokerPort", "pactBrokerScheme", "pactBrokerTags", "", "pactBrokerConsumerVersionSelectors", "Lau/com/dius/pact/provider/junitsupport/loader/VersionSelector;", "pactBrokerConsumers", "failIfNoPactsFound", "", "authentication", "Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;", "valueResolverClass", "Lkotlin/reflect/KClass;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "valueResolver", "enablePendingPacts", "providerTags", "includeWipPactsSince", "pactBrokerUrl", "ep", "Lau/com/dius/pact/core/support/expressions/ExpressionParser;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;Lkotlin/reflect/KClass;Lau/com/dius/pact/core/support/expressions/ValueResolver;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lau/com/dius/pact/core/support/expressions/ExpressionParser;)V", "getAuthentication", "()Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;", "setAuthentication", "(Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;)V", "getEnablePendingPacts", "()Ljava/lang/String;", "getEp", "()Lau/com/dius/pact/core/support/expressions/ExpressionParser;", "getFailIfNoPactsFound", "()Z", "setFailIfNoPactsFound", "(Z)V", "getIncludeWipPactsSince", "overriddenConsumer", "overriddenPactUrl", "getPactBrokerConsumerVersionSelectors", "()Ljava/util/List;", "getPactBrokerConsumers", "getPactBrokerHost$annotations", "()V", "getPactBrokerHost", "getPactBrokerPort$annotations", "getPactBrokerPort", "getPactBrokerScheme$annotations", "getPactBrokerScheme", "getPactBrokerTags$annotations", "getPactBrokerTags", "getPactBrokerUrl", "pactReader", "Lau/com/dius/pact/core/model/PactReader;", "getPactReader", "()Lau/com/dius/pact/core/model/PactReader;", "setPactReader", "(Lau/com/dius/pact/core/model/PactReader;)V", "getProviderTags", "resolver", "getValueResolverClass", "()Lkotlin/reflect/KClass;", "setValueResolverClass", "(Lkotlin/reflect/KClass;)V", "brokerUrl", "Lorg/apache/hc/core5/net/URIBuilder;", "buildConsumerVersionSelectors", "Lau/com/dius/pact/core/pactbroker/ConsumerVersionSelector;", "description", "getPactBrokerSource", "Lau/com/dius/pact/core/model/PactBrokerSource;", "Lau/com/dius/pact/core/model/Interaction;", "getPactSource", "Lau/com/dius/pact/core/model/PactSource;", "getUrlForProvider", "providerName", "pactBrokerClient", "Lau/com/dius/pact/core/pactbroker/IPactBrokerClient;", "load", "Lau/com/dius/pact/core/model/Pact;", "loadPactsForProvider", "selectors", "newPactBrokerClient", "url", "Ljava/net/URI;", "overridePactUrl", "", "pactUrl", "consumer", "setValueResolver", "setupValueResolver", "shouldFallBackToTags", "tags", "Companion", "provider"})
public class PactBrokerLoader
implements OverrideablePactLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String pactBrokerHost;
    @Nullable
    private final String pactBrokerPort;
    @Nullable
    private final String pactBrokerScheme;
    @Nullable
    private final List<String> pactBrokerTags;
    @NotNull
    private final List<VersionSelector> pactBrokerConsumerVersionSelectors;
    @NotNull
    private final List<String> pactBrokerConsumers;
    private boolean failIfNoPactsFound;
    @Nullable
    private PactBrokerAuth authentication;
    @Nullable
    private KClass<? extends ValueResolver> valueResolverClass;
    @NotNull
    private final String enablePendingPacts;
    @NotNull
    private final List<String> providerTags;
    @NotNull
    private final String includeWipPactsSince;
    @Nullable
    private final String pactBrokerUrl;
    @NotNull
    private final ExpressionParser ep;
    @Nullable
    private ValueResolver resolver;
    @Nullable
    private String overriddenPactUrl;
    @Nullable
    private String overriddenConsumer;
    @NotNull
    private PactReader pactReader;

    public PactBrokerLoader(@Nullable String pactBrokerHost, @Nullable String pactBrokerPort, @Nullable String pactBrokerScheme, @Nullable List<String> pactBrokerTags, @NotNull List<VersionSelector> pactBrokerConsumerVersionSelectors, @NotNull List<String> pactBrokerConsumers, boolean failIfNoPactsFound, @Nullable PactBrokerAuth authentication, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver, @NotNull String enablePendingPacts, @NotNull List<String> providerTags, @NotNull String includeWipPactsSince, @Nullable String pactBrokerUrl, @NotNull ExpressionParser ep) {
        Intrinsics.checkNotNullParameter(pactBrokerConsumerVersionSelectors, (String)"pactBrokerConsumerVersionSelectors");
        Intrinsics.checkNotNullParameter(pactBrokerConsumers, (String)"pactBrokerConsumers");
        Intrinsics.checkNotNullParameter((Object)enablePendingPacts, (String)"enablePendingPacts");
        Intrinsics.checkNotNullParameter(providerTags, (String)"providerTags");
        Intrinsics.checkNotNullParameter((Object)includeWipPactsSince, (String)"includeWipPactsSince");
        Intrinsics.checkNotNullParameter((Object)ep, (String)"ep");
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerScheme = pactBrokerScheme;
        this.pactBrokerTags = pactBrokerTags;
        this.pactBrokerConsumerVersionSelectors = pactBrokerConsumerVersionSelectors;
        this.pactBrokerConsumers = pactBrokerConsumers;
        this.failIfNoPactsFound = failIfNoPactsFound;
        this.authentication = authentication;
        this.valueResolverClass = valueResolverClass;
        this.enablePendingPacts = enablePendingPacts;
        this.providerTags = providerTags;
        this.includeWipPactsSince = includeWipPactsSince;
        this.pactBrokerUrl = pactBrokerUrl;
        this.ep = ep;
        this.resolver = valueResolver;
        this.pactReader = (PactReader)DefaultPactReader.INSTANCE;
    }

    public /* synthetic */ PactBrokerLoader(String string, String string2, String string3, List list, List list2, List list3, boolean bl, PactBrokerAuth pactBrokerAuth, KClass kClass, ValueResolver valueResolver, String string4, List list4, String string5, String string6, ExpressionParser expressionParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)"latest");
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x200) != 0) {
            valueResolver = null;
        }
        if ((n & 0x400) != 0) {
            string4 = "false";
        }
        if ((n & 0x800) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x1000) != 0) {
            string5 = "";
        }
        if ((n & 0x2000) != 0) {
            string6 = null;
        }
        if ((n & 0x4000) != 0) {
            expressionParser = new ExpressionParser(null, null, 3, null);
        }
        this(string, string2, string3, list, list2, list3, bl, pactBrokerAuth, (KClass<? extends ValueResolver>)kClass, valueResolver, string4, list4, string5, string6, expressionParser);
    }

    @Nullable
    public final String getPactBrokerHost() {
        return this.pactBrokerHost;
    }

    @Deprecated(message="Use pactBrokerUrl")
    public static /* synthetic */ void getPactBrokerHost$annotations() {
    }

    @Nullable
    public final String getPactBrokerPort() {
        return this.pactBrokerPort;
    }

    @Deprecated(message="Use pactBrokerUrl")
    public static /* synthetic */ void getPactBrokerPort$annotations() {
    }

    @Nullable
    public final String getPactBrokerScheme() {
        return this.pactBrokerScheme;
    }

    @Deprecated(message="Use pactBrokerUrl")
    public static /* synthetic */ void getPactBrokerScheme$annotations() {
    }

    @Nullable
    public final List<String> getPactBrokerTags() {
        return this.pactBrokerTags;
    }

    @Deprecated(message="Use Consumer version selectors instead", replaceWith=@ReplaceWith(expression="pactBrokerConsumerVersionSelectors", imports={}))
    public static /* synthetic */ void getPactBrokerTags$annotations() {
    }

    @NotNull
    public final List<VersionSelector> getPactBrokerConsumerVersionSelectors() {
        return this.pactBrokerConsumerVersionSelectors;
    }

    @NotNull
    public final List<String> getPactBrokerConsumers() {
        return this.pactBrokerConsumers;
    }

    public final boolean getFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public final void setFailIfNoPactsFound(boolean bl) {
        this.failIfNoPactsFound = bl;
    }

    @Nullable
    public final PactBrokerAuth getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(@Nullable PactBrokerAuth pactBrokerAuth) {
        this.authentication = pactBrokerAuth;
    }

    @Nullable
    public final KClass<? extends ValueResolver> getValueResolverClass() {
        return this.valueResolverClass;
    }

    public final void setValueResolverClass(@Nullable KClass<? extends ValueResolver> kClass) {
        this.valueResolverClass = kClass;
    }

    @NotNull
    public final String getEnablePendingPacts() {
        return this.enablePendingPacts;
    }

    @NotNull
    public final List<String> getProviderTags() {
        return this.providerTags;
    }

    @NotNull
    public final String getIncludeWipPactsSince() {
        return this.includeWipPactsSince;
    }

    @Nullable
    public final String getPactBrokerUrl() {
        return this.pactBrokerUrl;
    }

    @NotNull
    public final ExpressionParser getEp() {
        return this.ep;
    }

    @NotNull
    public final PactReader getPactReader() {
        return this.pactReader;
    }

    public final void setPactReader(@NotNull PactReader pactReader) {
        Intrinsics.checkNotNullParameter((Object)pactReader, (String)"<set-?>");
        this.pactReader = pactReader;
    }

    public PactBrokerLoader(@NotNull PactBroker pactBroker) {
        Intrinsics.checkNotNullParameter((Object)pactBroker, (String)"pactBroker");
        this(pactBroker.host(), pactBroker.port(), pactBroker.scheme(), ArraysKt.toList((Object[])pactBroker.tags()), ArraysKt.toList((Object[])pactBroker.consumerVersionSelectors()), ArraysKt.toList((Object[])pactBroker.consumers()), true, pactBroker.authentication(), Reflection.getOrCreateKotlinClass(pactBroker.valueResolver()), null, pactBroker.enablePendingPacts(), ArraysKt.toList((Object[])pactBroker.providerTags()), pactBroker.includeWipPactsSince(), pactBroker.url(), null, 16384, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String description() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$flatMapTo$iv$iv;
        ValueResolver resolver = this.setupValueResolver();
        List<ConsumerVersionSelector> consumerVersionSelectors = this.buildConsumerVersionSelectors(resolver);
        Iterable $this$flatMap$iv = this.pactBrokerConsumers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it, (ValueResolver)resolver, (boolean)false, (int)4, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List consumers = (List)destination$iv$iv;
        Object source = this.getPactBrokerSource(resolver).description();
        if (KotlinLanguageSupportKt.isNotEmpty(consumerVersionSelectors)) {
            source = (String)source + " consumerVersionSelectors=" + consumerVersionSelectors;
        }
        if (KotlinLanguageSupportKt.isNotEmpty((List)consumers)) {
            source = (String)source + " consumers=" + consumers;
        }
        return source;
    }

    @Override
    public void overridePactUrl(@NotNull String pactUrl, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)pactUrl, (String)"pactUrl");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.overriddenPactUrl = pactUrl;
        this.overriddenConsumer = consumer;
    }

    @Override
    @NotNull
    public List<Pact> load(@NotNull String providerName) throws IOException {
        List list;
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        ValueResolver resolver = this.setupValueResolver();
        if (KotlinLanguageSupportKt.isNotEmpty((String)this.overriddenPactUrl)) {
            URI brokerUri = this.brokerUrl(resolver).build();
            Intrinsics.checkNotNullExpressionValue((Object)brokerUri, (String)"brokerUri");
            IPactBrokerClient pactBrokerClient = this.newPactBrokerClient(brokerUri, resolver);
            String string = this.overriddenPactUrl;
            Intrinsics.checkNotNull((Object)string);
            String string2 = brokerUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"brokerUri.toString()");
            BrokerUrlSource pactSource = new BrokerUrlSource(string, string2, null, pactBrokerClient.getOptions(), null, null, 52, null);
            pactSource.setEncodePath(false);
            list = CollectionsKt.listOf((Object)this.pactReader.loadPact((Object)pactSource, pactBrokerClient.getOptions()));
        } else {
            List list2;
            try {
                List<ConsumerVersionSelector> consumerVersionSelectors = this.buildConsumerVersionSelectors(resolver);
                list2 = this.loadPactsForProvider(providerName, consumerVersionSelectors, resolver);
            }
            catch (NoPactsFoundException e) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConsumerVersionSelector> buildConsumerVersionSelectors(@NotNull ValueResolver resolver) {
        List list;
        Iterable $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        List list2 = this.pactBrokerTags;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = list3;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            list$iv$iv = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it, (ValueResolver)resolver, (boolean)false, (int)4, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List tags = (List)destination$iv$iv;
        if (this.shouldFallBackToTags(tags, this.pactBrokerConsumerVersionSelectors, resolver)) {
            $this$flatMap$iv = this.pactBrokerConsumers;
            List list4 = tags;
            Object object = Utils.INSTANCE;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                list$iv$iv = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it, (ValueResolver)resolver, (boolean)false, (int)4, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list5 = (List)destination$iv$iv;
            Iterable $this$map$iv = object.permutations(list4, list5);
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                list4 = new ConsumerVersionSelector((String)it.getFirst(), false, (String)it.getSecond(), null, 10, null);
                object.add(list4);
            }
            list = (List)destination$iv$iv;
        } else {
            $this$flatMap$iv = this.pactBrokerConsumerVersionSelectors;
            $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list6;
                boolean bl5;
                int n;
                boolean $i$f$mapTo;
                boolean $i$f$map;
                int index$iv$iv;
                boolean $i$f$mapIndexedTo;
                Collection destination$iv$iv2;
                boolean $i$f$mapIndexed;
                List latest;
                List list7;
                Object object;
                Object object2;
                int n2;
                int n3;
                int n4;
                it = (VersionSelector)element$iv$iv;
                boolean bl6 = false;
                List tags2 = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it.tag(), (ValueResolver)resolver, (boolean)false, (int)4, null);
                List consumers = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it.consumer(), (ValueResolver)resolver, (boolean)false, (int)4, null);
                String fallbackTag = (String)ExpressionParser.parseExpression$default((ExpressionParser)this.getEp(), (String)it.fallbackTag(), (DataType)DataType.STRING, (ValueResolver)resolver, (boolean)false, (int)8, null);
                List parsedLatest = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it.latest(), (ValueResolver)resolver, (boolean)false, (int)4, null);
                if (parsedLatest.isEmpty()) {
                    n4 = tags2.size();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    ArrayList arrayList = new ArrayList(n4);
                    boolean bl9 = false;
                    int n5 = 0;
                    n5 = 0;
                    int n6 = n4;
                    while (n5 < n6) {
                        int n7 = n5++;
                        n3 = 0;
                        n2 = n7;
                        object2 = arrayList;
                        boolean bl10 = false;
                        object = "true";
                        ((ArrayList)object2).add(object);
                    }
                    list7 = arrayList;
                } else {
                    list7 = latest = parsedLatest.size() == 1 ? CollectionUtilsKt.padTo((List)parsedLatest, (int)tags2.size(), parsedLatest.get(0)) : parsedLatest;
                }
                if (tags2.size() != latest.size()) {
                    throw new IllegalArgumentException("Invalid Consumer version selectors. Each version selector must have a tag and latest property");
                }
                if (KotlinLanguageSupportKt.isNotEmpty((List)tags2) && KotlinLanguageSupportKt.isNotEmpty((List)consumers)) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$mapIndexedTo$iv$iv;
                    void $this$mapIndexed$iv;
                    Iterable iterable2 = tags2;
                    object2 = Utils.INSTANCE;
                    $i$f$mapIndexed = false;
                    void var18_25 = $this$mapIndexed$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    $i$f$mapIndexedTo = false;
                    index$iv$iv = 0;
                    for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                        void index;
                        void tag;
                        n3 = index$iv$iv++;
                        boolean it2 = false;
                        if (n3 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String bl10 = (String)item$iv$iv2;
                        int n8 = n3;
                        object = destination$iv$iv2;
                        boolean bl11 = false;
                        Pair pair = TuplesKt.to((Object)tag, (Object)((int)index));
                        object.add(pair);
                    }
                    object = (List)destination$iv$iv2;
                    Iterable $this$map$iv = object2.permutations((List)object, consumers);
                    $i$f$map = false;
                    $this$mapIndexedTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void $dstr$tag$consumer;
                        Pair item$iv$iv2 = (Pair)item$iv$iv;
                        object2 = destination$iv$iv2;
                        n = 0;
                        Pair tag = (Pair)$dstr$tag$consumer.component1();
                        String consumer = (String)$dstr$tag$consumer.component2();
                        Pair pair = tag;
                        Intrinsics.checkNotNull((Object)pair);
                        String index = (String)pair.getFirst();
                        String bl11 = (String)latest.get(((Number)tag.getSecond()).intValue());
                        boolean bl12 = false;
                        bl5 = Boolean.parseBoolean(bl11);
                        object = new ConsumerVersionSelector(index, bl5, consumer, fallbackTag);
                        object2.add(object);
                    }
                    list6 = (List)destination$iv$iv2;
                } else if (KotlinLanguageSupportKt.isNotEmpty((List)tags2)) {
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapIndexed$iv = tags2;
                    $i$f$mapIndexed = false;
                    Iterable $this$mapTo$iv$iv2 = $this$mapIndexed$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    $i$f$mapIndexedTo = false;
                    index$iv$iv = 0;
                    for (Object item$iv$iv3 : $this$mapIndexedTo$iv$iv) {
                        void tag;
                        n = index$iv$iv++;
                        n2 = 0;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String consumer = (String)item$iv$iv3;
                        int index = n;
                        object2 = destination$iv$iv2;
                        boolean bl13 = false;
                        String string = (String)latest.get(index);
                        bl5 = false;
                        boolean bl14 = Boolean.parseBoolean(string);
                        string = (String)CollectionsKt.firstOrNull((List)consumers);
                        object = new ConsumerVersionSelector((String)tag, bl14, string, fallbackTag);
                        object2.add(object);
                    }
                    list6 = (List)destination$iv$iv2;
                } else if (KotlinLanguageSupportKt.isNotEmpty((List)consumers)) {
                    void $this$mapTo$iv$iv3;
                    Iterable $this$map$iv = consumers;
                    $i$f$map = false;
                    Iterable $this$mapIndexedTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void name;
                        String item$iv$iv3 = (String)item$iv$iv;
                        object2 = destination$iv$iv2;
                        boolean bl15 = false;
                        object = new ConsumerVersionSelector(null, true, (String)name, fallbackTag);
                        object2.add(object);
                    }
                    list6 = (List)destination$iv$iv2;
                } else {
                    n4 = 0;
                    list6 = CollectionsKt.emptyList();
                }
                list$iv$iv = list6;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public final boolean shouldFallBackToTags(@NotNull List<String> tags, @NotNull List<VersionSelector> selectors, @NotNull ValueResolver resolver) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(selectors, (String)"selectors");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return selectors.isEmpty() || selectors.size() == 1 && ExpressionParser.parseListExpression$default((ExpressionParser)this.ep, (String)selectors.get(0).tag(), (ValueResolver)resolver, (boolean)false, (int)4, null).isEmpty() && KotlinLanguageSupportKt.isNotEmpty(tags);
    }

    private final ValueResolver setupValueResolver() {
        ValueResolver valueResolver = (ValueResolver)SystemPropertyResolver.INSTANCE;
        if (this.resolver != null) {
            ValueResolver valueResolver2 = this.resolver;
            Intrinsics.checkNotNull((Object)valueResolver2);
            valueResolver = valueResolver2;
        } else if (this.valueResolverClass != null) {
            KClass<? extends ValueResolver> kClass = this.valueResolverClass;
            Intrinsics.checkNotNull(kClass);
            if (kClass.getObjectInstance() != null) {
                KClass<? extends ValueResolver> kClass2 = this.valueResolverClass;
                Intrinsics.checkNotNull(kClass2);
                Object object = kClass2.getObjectInstance();
                Intrinsics.checkNotNull((Object)object);
                valueResolver = (ValueResolver)object;
            } else {
                try {
                    KClass<? extends ValueResolver> kClass3 = this.valueResolverClass;
                    Intrinsics.checkNotNull(kClass3);
                    Object t = JvmClassMappingKt.getJavaClass(kClass3).newInstance();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"valueResolverClass!!.java.newInstance()");
                    valueResolver = (ValueResolver)t;
                }
                catch (InstantiationException e) {
                    Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.1.INSTANCE);
                }
                catch (IllegalAccessException e) {
                    Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.2.INSTANCE);
                }
            }
        }
        return valueResolver;
    }

    @Override
    @Nullable
    public PactSource getPactSource() {
        ValueResolver resolver = this.setupValueResolver();
        return (PactSource)this.getPactBrokerSource(resolver);
    }

    @Override
    public void setValueResolver(@NotNull ValueResolver valueResolver) {
        Intrinsics.checkNotNullParameter((Object)valueResolver, (String)"valueResolver");
        this.resolver = valueResolver;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pact> loadPactsForProvider(String providerName, List<ConsumerVersionSelector> selectors, ValueResolver resolver) throws IOException, IllegalArgumentException {
        String string;
        Iterator $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$flatMapTo$iv$iv;
        Companion.getLogger().debug((Function0)new Function0<Object>(providerName, selectors){
            final /* synthetic */ String $providerName;
            final /* synthetic */ List<ConsumerVersionSelector> $selectors;
            {
                this.$providerName = $providerName;
                this.$selectors = $selectors;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Loading pacts from pact broker for provider " + this.$providerName + " and consumer version selectors " + this.$selectors;
            }
        });
        Object object = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)this.enablePendingPacts, (DataType)DataType.BOOLEAN, (ValueResolver)resolver, (boolean)false, (int)8, null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean pending = (Boolean)object;
        Iterable $this$flatMap$iv = this.providerTags;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it, (ValueResolver)resolver, (boolean)false, (int)4, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List providerTags = (List)destination$iv$iv;
        if (pending) {
            boolean bl;
            block20: {
                Iterable $this$none$iv = providerTags;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (URI element$iv : $this$none$iv) {
                        String it2 = (String)((Object)element$iv);
                        boolean bl2 = false;
                        if (!KotlinLanguageSupportKt.isNotEmpty((String)it2)) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new IllegalArgumentException("Pending pacts feature has been enabled, but no provider tags have been specified. To use the pending pacts feature, you need to provide the list of provider names for the provider application version with the providerTags property that will be published with the verification results.");
            }
        }
        if (pending) {
            Object $i$f$none = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)this.includeWipPactsSince, (DataType)DataType.STRING, (ValueResolver)resolver, (boolean)false, (int)8, null);
            if ($i$f$none == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)$i$f$none;
        } else {
            string = "";
        }
        String wipSinceDate = string;
        URIBuilder uriBuilder = this.brokerUrl(resolver);
        try {
            void $this$mapTo$iv$iv;
            Result result2;
            URI element$iv;
            element$iv = uriBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)element$iv, (String)"uriBuilder.build()");
            IPactBrokerClient pactBrokerClient = this.newPactBrokerClient(element$iv, resolver);
            Result bl2 = result2 = pactBrokerClient.fetchConsumersWithSelectors(providerName, selectors, providerTags, pending, wipSinceDate);
            if (!(bl2 instanceof Ok)) {
                if (bl2 instanceof Err) {
                    throw (Throwable)((Err)result2).getError();
                }
                throw new NoWhenBranchMatchedException();
            }
            List consumers = (List)((Ok)result2).getValue();
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                throw new NoPactsFoundException("No consumer pacts were found for provider '" + providerName + "' and consumer version selectors '" + selectors + "'. (URL " + this.getUrlForProvider(providerName, pactBrokerClient) + ")");
            }
            if (KotlinLanguageSupportKt.isNotEmpty(this.pactBrokerConsumers)) {
                void $this$filterTo$iv$iv2;
                String it3;
                Iterable $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2 = this.pactBrokerConsumers;
                boolean $i$f$flatMap2 = false;
                Iterable bl = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    it3 = (String)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = ExpressionParser.parseListExpression$default((ExpressionParser)this.getEp(), (String)it3, (ValueResolver)resolver, (boolean)false, (int)4, null);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List consumerInclusions = (List)destination$iv$iv2;
                Iterable $this$filter$iv2 = consumers;
                boolean $i$f$filter2 = false;
                $this$flatMapTo$iv$iv2 = $this$filter$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it3 = (PactBrokerResult)element$iv$iv;
                    boolean bl4 = false;
                    boolean bl5 = it3.getUsedNewEndpoint() || consumerInclusions.isEmpty() || consumerInclusions.contains(it3.getName());
                    if (!bl5) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                consumers = (List)destination$iv$iv2;
            }
            Iterable $this$map$iv = consumers;
            boolean $i$f$map = false;
            Iterable $i$f$filter2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                Object element$iv$iv;
                element$iv$iv = (PactBrokerResult)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                Pact pact = this.getPactReader().loadPact((Object)it4, pactBrokerClient.getOptions());
                collection.add(pact);
            }
            return (List)destination$iv$iv3;
        }
        catch (URISyntaxException e) {
            throw new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    @NotNull
    public final URIBuilder brokerUrl(@NotNull ValueResolver resolver) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        PactBrokerSource<Interaction> pactBrokerSource = this.getPactBrokerSource(resolver);
        String host = pactBrokerSource.component1();
        String port = pactBrokerSource.component2();
        String scheme = pactBrokerSource.component3();
        String url = pactBrokerSource.component5();
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            URIBuilder uriBuilder = new URIBuilder().setScheme(scheme).setHost(host);
            if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
                uriBuilder.setPort(Integer.parseInt(port));
            }
            charSequence = uriBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"{\n      val uriBuilder =\u2026 }\n      uriBuilder\n    }");
            object = charSequence;
        } else {
            object = new URIBuilder(url);
        }
        return object;
    }

    @NotNull
    public final PactBrokerSource<Interaction> getPactBrokerSource(@NotNull ValueResolver resolver) {
        PactBrokerSource pactBrokerSource;
        block8: {
            String url;
            block5: {
                Object object;
                boolean bl;
                Object object2;
                String port;
                String host;
                String scheme;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
                        Object object3 = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)this.pactBrokerScheme, (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
                        scheme = object3 == null ? null : object3.toString();
                        Object object4 = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)this.pactBrokerHost, (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
                        host = object4 == null ? null : object4.toString();
                        Object object5 = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)this.pactBrokerPort, (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
                        port = object5 == null ? null : object5.toString();
                        object2 = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)this.pactBrokerUrl, (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
                        url = object2 == null ? null : object2.toString();
                        object2 = url;
                        boolean bl2 = false;
                        bl = false;
                        if (!(object2 == null || object2.length() == 0)) break block5;
                        object2 = host;
                        bl2 = false;
                        bl = false;
                        if (object2 == null || object2.length() == 0) break block6;
                        object2 = host;
                        object = new Regex("[0-9a-zA-Z\\-.]+");
                        bl = false;
                        if (object.matches((CharSequence)object2)) break block7;
                    }
                    object2 = StringCompanionObject.INSTANCE;
                    String string = "Invalid pact broker host specified ('%s'). Please provide a valid host or specify the system property 'pactbroker.host'.";
                    Object[] objectArray = new Object[]{this.pactBrokerHost};
                    boolean bl3 = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    throw new IllegalArgumentException(string2);
                }
                if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
                    String string = port;
                    Intrinsics.checkNotNull((Object)string);
                    object2 = string;
                    object = new Regex("^[0-9]+");
                    bl = false;
                    if (!object.matches((CharSequence)object2)) {
                        object2 = StringCompanionObject.INSTANCE;
                        object = "Invalid pact broker port specified ('%s'). Please provide a valid port number or specify the system property 'pactbroker.port'.";
                        Object[] objectArray = new Object[]{this.pactBrokerPort};
                        boolean bl4 = false;
                        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                        throw new IllegalArgumentException(string3);
                    }
                }
                pactBrokerSource = scheme == null ? new PactBrokerSource(host, port, null, null, null, 28, null) : new PactBrokerSource(host, port, scheme, null, null, 24, null);
                break block8;
            }
            pactBrokerSource = new PactBrokerSource(null, null, null, null, url, 12, null);
        }
        return pactBrokerSource;
    }

    private final String getUrlForProvider(String providerName, IPactBrokerClient pactBrokerClient) {
        String string;
        try {
            string = pactBrokerClient.getUrlForProvider(providerName, "");
            string = string == null ? "Unknown" : string;
        }
        catch (Exception e) {
            Companion.getLogger().debug((Throwable)e, (Function0)getUrlForProvider.1.INSTANCE);
            string = "Unknown";
        }
        return string;
    }

    @NotNull
    public IPactBrokerClient newPactBrokerClient(@NotNull URI url, @NotNull ValueResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        boolean bl = false;
        Map options = MapsKt.emptyMap();
        PactBrokerClientConfig config = new PactBrokerClientConfig(0, 0, false, 7, null);
        if (this.authentication == null) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.1.INSTANCE);
        } else {
            String token;
            PactBrokerAuth pactBrokerAuth = this.authentication;
            Intrinsics.checkNotNull((Object)pactBrokerAuth);
            Object object = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)pactBrokerAuth.username(), (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
            String username = object == null ? null : object.toString();
            PactBrokerAuth pactBrokerAuth2 = this.authentication;
            Intrinsics.checkNotNull((Object)pactBrokerAuth2);
            Object[] objectArray = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)pactBrokerAuth2.token(), (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
            String string = token = objectArray == null ? null : objectArray.toString();
            if (KotlinLanguageSupportKt.isNotEmpty((String)username)) {
                Companion.getLogger().debug((Function0)newPactBrokerClient.2.INSTANCE);
                objectArray = new Object[3];
                objectArray[0] = "basic";
                objectArray[1] = username;
                PactBrokerAuth pactBrokerAuth3 = this.authentication;
                Intrinsics.checkNotNull((Object)pactBrokerAuth3);
                objectArray[2] = ExpressionParser.parseExpression$default((ExpressionParser)this.ep, (String)pactBrokerAuth3.password(), (DataType)DataType.RAW, (ValueResolver)resolver, (boolean)false, (int)8, null);
                options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])objectArray)));
            } else if (KotlinLanguageSupportKt.isNotEmpty((String)token)) {
                Companion.getLogger().debug((Function0)newPactBrokerClient.3.INSTANCE);
                objectArray = new String[]{"bearer", token};
                options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])objectArray)));
            }
        }
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
        return (IPactBrokerClient)new PactBrokerClient(string, MapsKt.toMutableMap((Map)options), config);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerLoader$Companion;", "Lmu/KLogging;", "()V", "provider"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

