/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.DirectorySource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.provider.junitsupport.loader.PactFolder;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactFolderLoader;", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "path", "", "(Ljava/lang/String;)V", "pactFolder", "Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "pactSource", "Lau/com/dius/pact/core/model/DirectorySource;", "description", "getPactSource", "load", "", "Lau/com/dius/pact/core/model/Pact;", "providerName", "resolvePath", "provider"})
public final class PactFolderLoader
implements PactLoader {
    @NotNull
    private final File path;
    @NotNull
    private final DirectorySource pactSource;

    public PactFolderLoader(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }

    public PactFolderLoader(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(new File(path));
    }

    public PactFolderLoader(@NotNull PactFolder pactFolder) {
        Intrinsics.checkNotNullParameter((Object)pactFolder, (String)"pactFolder");
        this(pactFolder.value());
    }

    @Override
    @NotNull
    public String description() {
        return "Directory(" + this.pactSource.getDir() + ")";
    }

    @Override
    @NotNull
    public List<Pact> load(@NotNull String providerName) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        boolean bl = false;
        List pacts = new ArrayList();
        File pactFolder = this.resolvePath();
        File[] files = pactFolder.listFiles(PactFolderLoader::load$lambda-0);
        if (files != null) {
            for (File file : files) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                Pact pact = DefaultPactReader.INSTANCE.loadPact((Object)file);
                if (!Intrinsics.areEqual((Object)pact.getProvider().getName(), (Object)providerName)) continue;
                pacts.add(pact);
                this.pactSource.getPacts().put(file, pact);
            }
        }
        return pacts;
    }

    @NotNull
    public DirectorySource getPactSource() {
        return this.pactSource;
    }

    private final File resolvePath() {
        URL resourcePath = PactFolderLoader.class.getClassLoader().getResource(this.path.getPath());
        if (resourcePath == null) {
            return this.path;
        }
        return new File(URLDecoder.decode(resourcePath.getPath(), "UTF-8"));
    }

    private static final boolean load$lambda-0(File $noName_0, String name) {
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        return StringsKt.endsWith$default((String)name, (String)".json", (boolean)false, (int)2, null);
    }
}

