/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.PactVerifierException;
import au.com.dius.pact.provider.ProviderUtils;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactSource;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J3\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ.\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u00042\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J^\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00042\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0004H\u0007J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00042\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0019H\u0007J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020(J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0019H\u0007\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/provider/ProviderUtils;", "Lmu/KLogging;", "()V", "findAllPactSources", "", "Lkotlin/Pair;", "Lau/com/dius/pact/provider/junitsupport/loader/PactSource;", "", "clazz", "Lkotlin/reflect/KClass;", "findAnnotation", "T", "Ljava/lang/Class;", "annotation", "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "findPactSourceOnAnnotations", "parent", "instantiatePactLoader", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "pactSource", "isS3Url", "", "pactFile", "", "loadPactFiles", "Lau/com/dius/pact/provider/IConsumerInfo;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "pactFileDir", "Ljava/io/File;", "stateChange", "stateChangeUsesBody", "verificationType", "Lau/com/dius/pact/provider/PactVerification;", "packagesToScan", "", "pactFileAuthentication", "providerInfo", "consumer", "pactFileExists", "Lau/com/dius/pact/core/model/FileSource;"})
public final class ProviderUtils
extends KLogging {
    @NotNull
    public static final ProviderUtils INSTANCE = new ProviderUtils();

    private ProviderUtils() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan, @NotNull List<String> pactFileAuthentication) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkNotNullParameter(packagesToScan, (String)"packagesToScan");
        Intrinsics.checkNotNullParameter(pactFileAuthentication, (String)"pactFileAuthentication");
        if (!pactFileDir.exists()) {
            throw new PactVerifierException("Pact file directory (" + pactFileDir + ") does not exist", null, 2, null);
        }
        if (!pactFileDir.isDirectory()) {
            throw new PactVerifierException("Pact file directory (" + pactFileDir + ") is not a directory", null, 2, null);
        }
        if (!pactFileDir.canRead()) {
            throw new PactVerifierException("Pact file directory (" + pactFileDir + ") is not readable", null, 2, null);
        }
        String string = "Loading pact files for provider " + provider.getName() + " from " + pactFileDir;
        boolean bl = false;
        System.out.println((Object)string);
        boolean object = false;
        List consumers = new ArrayList();
        File[] fileArray = pactFileDir.listFiles(ProviderUtils::loadPactFiles$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"pactFileDir.listFiles { \u2026Extension(name, \"json\") }");
        for (File f : fileArray) {
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
            Pact pact = DefaultPactReader.INSTANCE.loadPact((Object)f);
            String providerName = pact.getProvider().getName();
            if (Intrinsics.areEqual((Object)providerName, (Object)provider.getName())) {
                consumers.add(new ConsumerInfo(pact.getConsumer().getName(), stateChange2, stateChangeUsesBody, packagesToScan, verificationType, new FileSource(f, null, 2, null), pactFileAuthentication, null, false, false, 896, null));
                continue;
            }
            String string2 = "Skipping " + f + " as the provider names don't match provider.name: " + provider.getName() + " vs pactJson.provider.name: " + providerName;
            boolean bl2 = false;
            System.out.println((Object)string2);
        }
        String string3 = "Found " + consumers.size() + " pact files";
        int n = 0;
        System.out.println((Object)string3);
        return consumers;
    }

    public static /* synthetic */ List loadPactFiles$default(IProviderInfo iProviderInfo, File file, Object object, boolean bl, PactVerification pactVerification, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ProviderUtils.loadPactFiles(iProviderInfo, file, object, bl, pactVerification, list, list2);
    }

    public final boolean pactFileExists(@NotNull FileSource pactFile) {
        Intrinsics.checkNotNullParameter((Object)pactFile, (String)"pactFile");
        return pactFile.getFile().exists();
    }

    @JvmStatic
    @NotNull
    public static final PactVerification verificationType(@NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        PactVerification pactVerification;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        PactVerification pactVerification2 = consumer.getVerificationType();
        return pactVerification2 == null ? ((pactVerification = provider.getVerificationType()) == null ? PactVerification.REQUEST_RESPONSE : pactVerification) : pactVerification2;
    }

    @JvmStatic
    @NotNull
    public static final List<String> packagesToScan(@NotNull IProviderInfo providerInfo, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)providerInfo, (String)"providerInfo");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Collection collection = consumer.getPackagesToScan();
        boolean bl = false;
        return !collection.isEmpty() ? consumer.getPackagesToScan() : providerInfo.getPackagesToScan();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isS3Url(@Nullable Object pactFile) {
        if (!(pactFile instanceof String)) return false;
        String string = (String)pactFile;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.startsWith$default((String)string2, (String)"s3://", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final <T extends Annotation> T findAnnotation(@NotNull Class<?> clazz, @NotNull Class<T> annotation) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        T value = clazz.getAnnotation(annotation);
        if (value == null) {
            for (Annotation anno : JvmClassMappingKt.getKotlinClass(clazz).getAnnotations()) {
                KClass annotationClass = JvmClassMappingKt.getAnnotationClass((Annotation)anno);
                if (StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"java.lang.annotation.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"kotlin.annotation.", (boolean)false, (int)2, null)) continue;
                T valueAnnotation = ProviderUtils.findAnnotation(JvmClassMappingKt.getJavaClass((KClass)annotationClass), annotation);
                if (valueAnnotation == null) continue;
                value = valueAnnotation;
            }
        }
        return value;
    }

    @JvmStatic
    @NotNull
    public static final List<Pair<PactSource, Annotation>> findAllPactSources(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(clazz), (Iterable)KClasses.getAllSuperclasses(clazz));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            KClass it;
            block4: {
                it = (KClass)element$iv;
                boolean bl2 = false;
                Iterable iterable = it.getAnnotations();
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                boolean bl4 = false;
                for (Object t : iterable2) {
                    Annotation annotation = (Annotation)t;
                    boolean bl5 = false;
                    if (!(annotation instanceof PactSource)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Annotation annotationOnClass = v0;
            if (annotationOnClass instanceof PactSource) {
                result2.add(TuplesKt.to((Object)annotationOnClass, null));
            }
            for (Annotation anno : it.getAnnotations()) {
                result2.addAll((Collection)INSTANCE.findPactSourceOnAnnotations(anno, null));
            }
        }
        return result2;
    }

    private final List<Pair<PactSource, Annotation>> findPactSourceOnAnnotations(Annotation annotation, Annotation parent) {
        boolean bl = false;
        List result2 = new ArrayList();
        if (annotation instanceof PactSource && parent != null) {
            result2.add(TuplesKt.to((Object)annotation, (Object)parent));
        }
        for (Annotation anno : JvmClassMappingKt.getAnnotationClass((Annotation)annotation).getAnnotations()) {
            KClass annotationClass = JvmClassMappingKt.getAnnotationClass((Annotation)anno);
            if (StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"java.lang.annotation.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"kotlin.annotation.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)anno, (Object)annotation)) continue;
            result2.addAll((Collection)this.findPactSourceOnAnnotations(anno, annotation));
        }
        return result2;
    }

    @NotNull
    public final PactLoader instantiatePactLoader(@NotNull PactSource pactSource, @NotNull Class<?> clazz, @Nullable Annotation annotation) {
        PactLoader pactLoader;
        Intrinsics.checkNotNullParameter((Object)pactSource, (String)"pactSource");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        KClass pactLoaderClass = Reflection.getOrCreateKotlinClass(pactSource.value());
        try {
            Object[] objectArray = new Class[]{Class.class};
            Constructor constructorWithClass = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor((Class<?>[])objectArray);
            constructorWithClass.setAccessible(true);
            objectArray = new Object[]{clazz};
            pactLoader = constructorWithClass.newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)pactLoader, (String)"{\n      // Checks if the\u2026.newInstance(clazz)\n    }");
        }
        catch (NoSuchMethodException e) {
            PactLoader pactLoader2;
            this.getLogger().debug((Function0)instantiatePactLoader.1.INSTANCE);
            if (annotation != null) {
                PactLoader pactLoader3;
                try {
                    Object[] objectArray = new Class[]{JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation))};
                    Constructor constructor = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor((Class<?>[])objectArray);
                    constructor.setAccessible(true);
                    objectArray = new Object[]{annotation};
                    pactLoader3 = (PactLoader)constructor.newInstance(objectArray);
                }
                catch (NoSuchMethodException e2) {
                    PactLoader pactLoader4;
                    this.getLogger().debug((Function0)new Function0<Object>(pactSource){
                        final /* synthetic */ PactSource $pactSource;
                        {
                            this.$pactSource = $pactSource;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Pact loader does not have a constructor with one argument of type " + this.$pactSource;
                        }
                    });
                    try {
                        KProperty1 annotationValueProp;
                        Object v0;
                        block9: {
                            Iterable iterable = KClasses.getMemberProperties((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                            boolean bl = false;
                            Iterable iterable2 = iterable;
                            boolean bl2 = false;
                            for (Object t : iterable2) {
                                KProperty1 it = (KProperty1)t;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"value")) continue;
                                v0 = t;
                                break block9;
                            }
                            v0 = null;
                        }
                        KProperty1 kProperty1 = annotationValueProp = (KProperty1)v0;
                        Intrinsics.checkNotNull((Object)kProperty1);
                        Object[] objectArray = new Object[]{annotation};
                        Object object = kProperty1.getGetter().call(objectArray);
                        Intrinsics.checkNotNull((Object)object);
                        Object annotationValue = object;
                        objectArray = new Class[]{annotationValue.getClass()};
                        Constructor constructor = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor((Class<?>[])objectArray);
                        objectArray = new Object[]{annotationValue};
                        pactLoader4 = (PactLoader)constructor.newInstance(objectArray);
                    }
                    catch (NoSuchMethodException e3) {
                        this.getLogger().debug((Function0)new Function0<Object>(pactSource){
                            final /* synthetic */ PactSource $pactSource;
                            {
                                this.$pactSource = $pactSource;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Pact loader does not have a constructor with one argument of type " + Reflection.getOrCreateKotlinClass(this.$pactSource.value());
                            }
                        });
                        pactLoader4 = (PactLoader)KClasses.createInstance((KClass)pactLoaderClass);
                    }
                    pactLoader3 = pactLoader4;
                }
                pactLoader2 = pactLoader3;
            } else {
                pactLoader2 = (PactLoader)KClasses.createInstance((KClass)pactLoaderClass);
            }
            PactLoader pactLoader5 = pactLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)pactLoader5, (String)"pactSource: PactSource, \u2026eInstance()\n      }\n    }");
            pactLoader = pactLoader5;
        }
        return pactLoader;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkNotNullParameter(packagesToScan, (String)"packagesToScan");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, packagesToScan, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationType), (String)"verificationType");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, null, null, null, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, false, null, null, null, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, null, false, null, null, null, 124, null);
    }

    private static final boolean loadPactFiles$lambda-0(File $noName_0, String name) {
        return FilenameUtils.isExtension((String)name, (String)"json");
    }
}

