/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lau/com/dius/pact/provider/ProviderVersion;", "Ljava/util/function/Supplier;", "", "source", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "getSource", "()Lkotlin/jvm/functions/Function0;", "get", "trimSnapshot", "providerVersion", "Companion", "provider"})
public final class ProviderVersion
implements Supplier<String> {
    @NotNull
    private final Function0<String> source;
    @NotNull
    public static final String FALLBACK_VALUE = "0.0.0";
    @NotNull
    public static final String SNAPSHOT_DEFINITION_STRING = "-SNAPSHOT";
    @NotNull
    private static final Regex snapshotRegex;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public String get() {
        boolean bl;
        String version2;
        String string = (String)this.source.invoke();
        if (string == null) {
            string = version2 = FALLBACK_VALUE;
        }
        if (Intrinsics.areEqual((Object)version2, (Object)FALLBACK_VALUE)) {
            logger.warn("Provider version not set, defaulting to '0.0.0'");
        }
        String trimSnapshotProperty = System.getProperty("pact.provider.version.trimSnapshot");
        CharSequence charSequence = trimSnapshotProperty;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bl = false;
        } else {
            charSequence = trimSnapshotProperty;
            bl2 = false;
            bl = Boolean.parseBoolean((String)charSequence);
        }
        boolean isTrimSnapshot = bl;
        return isTrimSnapshot ? this.trimSnapshot(version2) : version2;
    }

    private final String trimSnapshot(String providerVersion) {
        if (StringsKt.contains$default((CharSequence)providerVersion, (CharSequence)SNAPSHOT_DEFINITION_STRING, (boolean)false, (int)2, null)) {
            String string = providerVersion;
            MatchResult matchResult = Regex.find$default((Regex)snapshotRegex, (CharSequence)providerVersion, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            IntRange intRange = matchGroup.getRange();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.removeRange((CharSequence)string2, (IntRange)intRange)).toString();
        }
        return providerVersion;
    }

    @NotNull
    public final Function0<String> getSource() {
        return this.source;
    }

    public ProviderVersion(@NotNull Function0<String> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
    }

    static {
        Companion = new Companion(null);
        snapshotRegex = new Regex(".*(-SNAPSHOT)");
        Logger logger = LoggerFactory.getLogger(ProviderVersion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026viderVersion::class.java)");
        ProviderVersion.logger = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lau/com/dius/pact/provider/ProviderVersion$Companion;", "", "()V", "FALLBACK_VALUE", "", "SNAPSHOT_DEFINITION_STRING", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "snapshotRegex", "Lkotlin/text/Regex;", "getSnapshotRegex", "()Lkotlin/text/Regex;", "provider"})
    public static final class Companion {
        @NotNull
        public final Regex getSnapshotRegex() {
            return snapshotRegex;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

