/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.PactVerifierException;
import au.com.dius.pact.provider.ProviderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001J^\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0007J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000bH\u0007J\u0014\u0010\u0018\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lau/com/dius/pact/provider/ProviderUtils;", "", "()V", "getProviderVersion", "", "projectVersion", "isS3Url", "", "pactFile", "loadPactFiles", "", "Lau/com/dius/pact/provider/IConsumerInfo;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "pactFileDir", "Ljava/io/File;", "stateChange", "stateChangeUsesBody", "verificationType", "Lau/com/dius/pact/provider/PactVerification;", "packagesToScan", "pactFileAuthentication", "providerInfo", "consumer", "pactFileExists", "Lau/com/dius/pact/core/model/FileSource;", "Lau/com/dius/pact/core/model/Interaction;", "trimSnapshot", "providerVersion"})
public final class ProviderUtils {
    public static final ProviderUtils INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan, @NotNull List<String> pactFileAuthentication) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkParameterIsNotNull((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkParameterIsNotNull(packagesToScan, (String)"packagesToScan");
        Intrinsics.checkParameterIsNotNull(pactFileAuthentication, (String)"pactFileAuthentication");
        if (!pactFileDir.exists()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") does not exist", null, 2, null);
        }
        if (!pactFileDir.isDirectory()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") is not a directory", null, 2, null);
        }
        if (!pactFileDir.canRead()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") is not readable", null, 2, null);
        }
        String string = "Loading pact files for provider " + provider.getName() + " from " + pactFileDir;
        boolean bl = false;
        System.out.println((Object)string);
        bl = false;
        List consumers = new ArrayList();
        File[] fileArray = pactFileDir.listFiles(loadPactFiles.1.INSTANCE);
        int n2 = fileArray.length;
        for (n = 0; n < n2; ++n) {
            File f;
            File file = f = fileArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"f");
            Pact pact2 = DefaultPactReader.INSTANCE.loadPact((Object)file);
            String providerName = pact2.getProvider().getName();
            if (Intrinsics.areEqual((Object)providerName, (Object)provider.getName())) {
                consumers.add(new ConsumerInfo(pact2.getConsumer().getName(), stateChange2, stateChangeUsesBody, packagesToScan, verificationType, new FileSource(f, null, 2, null), pactFileAuthentication, null, false, false, 896, null));
                continue;
            }
            String string2 = "Skipping " + f + " as the provider names don't match provider.name: " + provider.getName() + " vs pactJson.provider.name: " + providerName;
            boolean bl2 = false;
            System.out.println((Object)string2);
        }
        String string3 = "Found " + consumers.size() + " pact files";
        n = 0;
        System.out.println((Object)string3);
        return consumers;
    }

    public static /* synthetic */ List loadPactFiles$default(IProviderInfo iProviderInfo, File file, Object object, boolean bl, PactVerification pactVerification, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ProviderUtils.loadPactFiles(iProviderInfo, file, object, bl, pactVerification, list, list2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, packagesToScan, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, null, null, null, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, false, null, null, null, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, null, false, null, null, null, 124, null);
    }

    public final boolean pactFileExists(@NotNull FileSource<Interaction> pactFile) {
        Intrinsics.checkParameterIsNotNull(pactFile, (String)"pactFile");
        return pactFile.getFile().exists();
    }

    @JvmStatic
    @NotNull
    public static final PactVerification verificationType(@NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        PactVerification pactVerification;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        PactVerification pactVerification2 = consumer.getVerificationType();
        if (pactVerification2 == null) {
            pactVerification2 = pactVerification = provider.getVerificationType();
        }
        if (pactVerification2 == null) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        return pactVerification;
    }

    @JvmStatic
    @NotNull
    public static final List<String> packagesToScan(@NotNull IProviderInfo providerInfo, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkParameterIsNotNull((Object)providerInfo, (String)"providerInfo");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Collection collection = consumer.getPackagesToScan();
        boolean bl = false;
        return !collection.isEmpty() ? consumer.getPackagesToScan() : providerInfo.getPackagesToScan();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isS3Url(@Nullable Object pactFile) {
        if (!(pactFile instanceof String)) return false;
        String string = (String)pactFile;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.startsWith$default((String)string2, (String)"s3://", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final String getProviderVersion(@NotNull String projectVersion) {
        Intrinsics.checkParameterIsNotNull((Object)projectVersion, (String)"projectVersion");
        String trimSnapshotProperty = System.getProperty("pact.provider.version.trimSnapshot");
        boolean isTrimSnapshot = trimSnapshotProperty == null || StringsKt.isBlank((CharSequence)trimSnapshotProperty) ? false : BooleanUtils.toBoolean((String)trimSnapshotProperty);
        return isTrimSnapshot ? INSTANCE.trimSnapshot(projectVersion) : projectVersion;
    }

    private final String trimSnapshot(String providerVersion) {
        String SNAPSHOT_STRING = "-SNAPSHOT";
        if (StringsKt.contains$default((CharSequence)providerVersion, (CharSequence)SNAPSHOT_STRING, (boolean)false, (int)2, null)) {
            return StringsKt.replaceFirst$default((String)providerVersion, (String)SNAPSHOT_STRING, (String)"", (boolean)false, (int)4, null);
        }
        return providerVersion;
    }

    private ProviderUtils() {
    }

    static {
        ProviderUtils providerUtils;
        INSTANCE = providerUtils = new ProviderUtils();
    }
}

