/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.PactVerifierException;
import au.com.dius.pact.provider.ProviderUtils;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactSource;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J3\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ.\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u00042\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016J^\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010!\u001a\u00020\u00182\b\b\u0002\u0010\"\u001a\u00020#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00042\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0004H\u0007J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00042\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0007J\u0014\u0010)\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020+0*J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0007\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/provider/ProviderUtils;", "Lmu/KLogging;", "()V", "findAllPactSources", "", "Lkotlin/Pair;", "Lau/com/dius/pact/provider/junitsupport/loader/PactSource;", "", "clazz", "Lkotlin/reflect/KClass;", "findAnnotation", "T", "Ljava/lang/Class;", "annotation", "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "findPactSourceOnAnnotations", "parent", "instantiatePactLoader", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "pactSource", "testClass", "testInstance", "", "isS3Url", "", "pactFile", "loadPactFiles", "Lau/com/dius/pact/provider/IConsumerInfo;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "pactFileDir", "Ljava/io/File;", "stateChange", "stateChangeUsesBody", "verificationType", "Lau/com/dius/pact/provider/PactVerification;", "packagesToScan", "", "pactFileAuthentication", "providerInfo", "consumer", "pactFileExists", "Lau/com/dius/pact/core/model/FileSource;", "Lau/com/dius/pact/core/model/Interaction;"})
public final class ProviderUtils
extends KLogging {
    public static final ProviderUtils INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan, @NotNull List<String> pactFileAuthentication) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkParameterIsNotNull((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkParameterIsNotNull(packagesToScan, (String)"packagesToScan");
        Intrinsics.checkParameterIsNotNull(pactFileAuthentication, (String)"pactFileAuthentication");
        if (!pactFileDir.exists()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") does not exist", null, 2, null);
        }
        if (!pactFileDir.isDirectory()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") is not a directory", null, 2, null);
        }
        if (!pactFileDir.canRead()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") is not readable", null, 2, null);
        }
        String string = "Loading pact files for provider " + provider.getName() + " from " + pactFileDir;
        boolean bl = false;
        System.out.println((Object)string);
        bl = false;
        List consumers = new ArrayList();
        File[] fileArray = pactFileDir.listFiles(loadPactFiles.1.INSTANCE);
        int n2 = fileArray.length;
        for (n = 0; n < n2; ++n) {
            File f;
            File file = f = fileArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"f");
            Pact pact2 = DefaultPactReader.INSTANCE.loadPact((Object)file);
            String providerName = pact2.getProvider().getName();
            if (Intrinsics.areEqual((Object)providerName, (Object)provider.getName())) {
                consumers.add(new ConsumerInfo(pact2.getConsumer().getName(), stateChange2, stateChangeUsesBody, packagesToScan, verificationType, new FileSource(f, null, 2, null), pactFileAuthentication, null, false, false, null, 1920, null));
                continue;
            }
            String string2 = "Skipping " + f + " as the provider names don't match provider.name: " + provider.getName() + " vs pactJson.provider.name: " + providerName;
            boolean bl2 = false;
            System.out.println((Object)string2);
        }
        String string3 = "Found " + consumers.size() + " pact files";
        n = 0;
        System.out.println((Object)string3);
        return consumers;
    }

    public static /* synthetic */ List loadPactFiles$default(IProviderInfo iProviderInfo, File file, Object object, boolean bl, PactVerification pactVerification, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ProviderUtils.loadPactFiles(iProviderInfo, file, object, bl, pactVerification, list, list2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, packagesToScan, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, null, null, null, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, false, null, null, null, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, null, false, null, null, null, 124, null);
    }

    public final boolean pactFileExists(@NotNull FileSource<Interaction> pactFile) {
        Intrinsics.checkParameterIsNotNull(pactFile, (String)"pactFile");
        return pactFile.getFile().exists();
    }

    @JvmStatic
    @NotNull
    public static final PactVerification verificationType(@NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        PactVerification pactVerification;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        PactVerification pactVerification2 = consumer.getVerificationType();
        if (pactVerification2 == null) {
            pactVerification2 = pactVerification = provider.getVerificationType();
        }
        if (pactVerification2 == null) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        return pactVerification;
    }

    @JvmStatic
    @NotNull
    public static final List<String> packagesToScan(@NotNull IProviderInfo providerInfo, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkParameterIsNotNull((Object)providerInfo, (String)"providerInfo");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Collection collection = consumer.getPackagesToScan();
        boolean bl = false;
        return !collection.isEmpty() ? consumer.getPackagesToScan() : providerInfo.getPackagesToScan();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isS3Url(@Nullable Object pactFile) {
        if (!(pactFile instanceof String)) return false;
        String string = (String)pactFile;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.startsWith$default((String)string2, (String)"s3://", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final <T extends Annotation> T findAnnotation(@NotNull Class<?> clazz, @NotNull Class<T> annotation) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull(annotation, (String)"annotation");
        T value = clazz.getAnnotation(annotation);
        if (value == null) {
            for (Annotation anno : JvmClassMappingKt.getKotlinClass(clazz).getAnnotations()) {
                T valueAnnotation;
                KClass annotationClass = JvmClassMappingKt.getAnnotationClass((Annotation)anno);
                if (StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"java.lang.annotation.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"kotlin.annotation.", (boolean)false, (int)2, null) || (valueAnnotation = ProviderUtils.findAnnotation(JvmClassMappingKt.getJavaClass((KClass)annotationClass), annotation)) == null) continue;
                value = valueAnnotation;
            }
        }
        return value;
    }

    @JvmStatic
    @NotNull
    public static final List<Pair<PactSource, Annotation>> findAllPactSources(@NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(clazz), (Iterable)KClasses.getAllSuperclasses(clazz));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            KClass it;
            block4: {
                it = (KClass)element$iv;
                boolean bl2 = false;
                Iterable iterable = it.getAnnotations();
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                boolean bl4 = false;
                for (Object t : iterable2) {
                    Annotation annotation = (Annotation)t;
                    boolean bl5 = false;
                    if (!(annotation instanceof PactSource)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Annotation annotationOnClass = v0;
            if (annotationOnClass instanceof PactSource) {
                result2.add(TuplesKt.to((Object)annotationOnClass, null));
            }
            for (Annotation anno : it.getAnnotations()) {
                result2.addAll((Collection)INSTANCE.findPactSourceOnAnnotations(anno, null));
            }
        }
        return result2;
    }

    private final List<Pair<PactSource, Annotation>> findPactSourceOnAnnotations(Annotation annotation, Annotation parent) {
        boolean bl = false;
        List result2 = new ArrayList();
        if (annotation instanceof PactSource && parent != null) {
            result2.add(TuplesKt.to((Object)annotation, (Object)parent));
        }
        for (Annotation anno : JvmClassMappingKt.getAnnotationClass((Annotation)annotation).getAnnotations()) {
            KClass annotationClass = JvmClassMappingKt.getAnnotationClass((Annotation)anno);
            if (StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"java.lang.annotation.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"kotlin.annotation.", (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)anno, (Object)annotation) ^ true)) continue;
            result2.addAll((Collection)this.findPactSourceOnAnnotations(anno, annotation));
        }
        return result2;
    }

    @NotNull
    public final PactLoader instantiatePactLoader(@NotNull PactSource pactSource, @NotNull Class<?> testClass, @Nullable Object testInstance, @Nullable Annotation annotation) {
        PactLoader pactLoader2;
        Intrinsics.checkParameterIsNotNull((Object)pactSource, (String)"pactSource");
        Intrinsics.checkParameterIsNotNull(testClass, (String)"testClass");
        KClass pactLoaderClass = Reflection.getOrCreateKotlinClass(pactSource.value());
        try {
            Constructor constructorWithClass;
            Constructor constructor = constructorWithClass = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor(Class.class);
            Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"constructorWithClass");
            constructor.setAccessible(true);
            pactLoader2 = (PactLoader)constructorWithClass.newInstance(testClass);
        }
        catch (NoSuchMethodException e) {
            PactLoader pactLoader3;
            this.getLogger().debug((Function0)instantiatePactLoader.pactLoader.1.INSTANCE);
            if (annotation != null) {
                PactLoader pactLoader4;
                try {
                    Constructor constructor;
                    Constructor constructor2 = constructor = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor(JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation)));
                    Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"constructor");
                    constructor2.setAccessible(true);
                    pactLoader4 = (PactLoader)constructor.newInstance(annotation);
                }
                catch (NoSuchMethodException e2) {
                    PactLoader pactLoader5;
                    this.getLogger().debug((Function0)new Function0<String>(pactSource){
                        final /* synthetic */ PactSource $pactSource;

                        @NotNull
                        public final String invoke() {
                            return "Pact loader does not have a constructor with one argument of type " + this.$pactSource;
                        }
                        {
                            this.$pactSource = pactSource;
                            super(0);
                        }
                    });
                    try {
                        KProperty1 annotationValueProp;
                        Object v2;
                        block11: {
                            Iterable iterable = KClasses.getMemberProperties((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                            boolean bl = false;
                            Iterable iterable2 = iterable;
                            boolean bl2 = false;
                            for (Object t : iterable2) {
                                KProperty1 it = (KProperty1)t;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"value")) continue;
                                v2 = t;
                                break block11;
                            }
                            v2 = null;
                        }
                        KProperty1 kProperty1 = annotationValueProp = (KProperty1)v2;
                        if (kProperty1 == null) {
                            Intrinsics.throwNpe();
                        }
                        Object object = kProperty1.getGetter().call(new Object[]{annotation});
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        Object annotationValue = object;
                        pactLoader5 = (PactLoader)JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor(annotationValue.getClass()).newInstance(annotationValue);
                    }
                    catch (NoSuchMethodException e3) {
                        this.getLogger().debug((Function0)new Function0<String>(pactSource){
                            final /* synthetic */ PactSource $pactSource;

                            @NotNull
                            public final String invoke() {
                                return "Pact loader does not have a constructor with one argument of type " + Reflection.getOrCreateKotlinClass(this.$pactSource.value());
                            }
                            {
                                this.$pactSource = pactSource;
                                super(0);
                            }
                        });
                        pactLoader5 = (PactLoader)KClasses.createInstance((KClass)pactLoaderClass);
                    }
                    pactLoader4 = pactLoader5;
                }
                pactLoader3 = pactLoader4;
            } else {
                pactLoader3 = (PactLoader)KClasses.createInstance((KClass)pactLoaderClass);
            }
            pactLoader2 = pactLoader3;
        }
        PactLoader pactLoader6 = pactLoader2;
        pactLoader6.initLoader(testClass, testInstance);
        PactLoader pactLoader7 = pactLoader6;
        Intrinsics.checkExpressionValueIsNotNull((Object)pactLoader7, (String)"pactLoader");
        return pactLoader7;
    }

    private ProviderUtils() {
    }

    static {
        ProviderUtils providerUtils;
        INSTANCE = providerUtils = new ProviderUtils();
    }
}

