/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.provider.junitsupport.loader.PactUrlLoader;
import au.com.dius.pact.provider.junitsupport.loader.VersionedPactUrl;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class VersionedPactUrlLoader
extends PactUrlLoader {
    public VersionedPactUrlLoader(String[] urls) {
        super(VersionedPactUrlLoader.expandVariables(urls));
    }

    public VersionedPactUrlLoader(VersionedPactUrl pactUrl) {
        this(pactUrl.urls());
    }

    @VisibleForTesting
    static String[] expandVariables(String[] urls) {
        return Arrays.stream(urls).map(VersionedPactUrlLoader::expandVariables).collect(Collectors.toList()).toArray(new String[urls.length]);
    }

    private static String expandVariables(String urlWithVariables) {
        String urlWithVersions = urlWithVariables;
        if (!VersionedPactUrlLoader.variablesToExpandFound(urlWithVersions)) {
            throw new IllegalArgumentException(urlWithVersions + " contains no variables to expand in the format ${...}. Consider using @PactUrl or providing expandable variables.");
        }
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            urlWithVersions = urlWithVersions.replace(String.format("${%s}", property.getKey()), property.getValue().toString());
        }
        if (VersionedPactUrlLoader.variablesToExpandFound(urlWithVersions)) {
            throw new IllegalArgumentException(urlWithVersions + " contains variables that could not be any of the system properties. Define a system property to replace them or remove the variables from the URL.");
        }
        return urlWithVersions;
    }

    private static boolean variablesToExpandFound(String urlWithVersions) {
        return urlWithVersions.matches(".*\\$\\{[a-z\\.]+\\}.*");
    }
}

