/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.IPactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.VerificationReporter;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003Jb\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J<\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016JR\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/provider/DefaultVerificationReporter;", "Lau/com/dius/pact/provider/VerificationReporter;", "Lmu/KLogging;", "()V", "publishResult", "Lcom/github/michaelbull/result/Result;", "", "", "", "I", "Lau/com/dius/pact/core/model/Interaction;", "brokerClient", "Lau/com/dius/pact/core/pactbroker/IPactBrokerClient;", "source", "Lau/com/dius/pact/core/model/BrokerUrlSource;", "result", "Lau/com/dius/pact/core/pactbroker/TestResult;", "version", "pact", "Lau/com/dius/pact/core/model/Pact;", "tags", "publishingResultsDisabled", "resolver", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "reportResults", "", "client", "tag", "provider"})
public final class DefaultVerificationReporter
extends KLogging
implements VerificationReporter {
    public static final DefaultVerificationReporter INSTANCE;

    @Override
    public void reportResults(@NotNull Pact<? extends Interaction> pact2, @NotNull TestResult result2, @NotNull String version2, @Nullable IPactBrokerClient client, @Nullable String tag) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        CharSequence charSequence = tag;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.reportResults(pact2, result2, version2, client, CollectionsKt.emptyList());
        } else {
            this.reportResults(pact2, result2, version2, client, CollectionsKt.listOf((Object)tag));
        }
    }

    @Override
    @NotNull
    public Result<Boolean, List<String>> reportResults(@NotNull Pact<? extends Interaction> pact2, @NotNull TestResult result2, @NotNull String version2, @Nullable IPactBrokerClient client, @NotNull List<String> tags) {
        Result result3;
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        PactSource source = pact2.getSource();
        if (source instanceof BrokerUrlSource) {
            IPactBrokerClient iPactBrokerClient = client;
            if (iPactBrokerClient == null) {
                iPactBrokerClient = (IPactBrokerClient)new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), MapsKt.toMutableMap((Map)((BrokerUrlSource)source).getOptions()), null, 4, null);
            }
            IPactBrokerClient brokerClient = iPactBrokerClient;
            result3 = this.publishResult(brokerClient, (BrokerUrlSource)source, result2, version2, pact2, tags);
        } else {
            this.getLogger().info((Function0)new Function0<String>(source){
                final /* synthetic */ PactSource $source;

                @NotNull
                public final String invoke() {
                    return "Skipping publishing verification results for source " + this.$source;
                }
                {
                    this.$source = pactSource;
                    super(0);
                }
            });
            result3 = (Result)new Ok((Object)false);
        }
        return result3;
    }

    private final <I extends Interaction> Result<Boolean, List<String>> publishResult(IPactBrokerClient brokerClient, BrokerUrlSource source, TestResult result2, String version2, Pact<? extends I> pact2, List<String> tags) {
        Result result3;
        Collection collection = tags;
        boolean bl = false;
        Result tagsResult = !collection.isEmpty() ? brokerClient.publishProviderTags(source.getAttributes(), pact2.getProvider().getName(), tags, version2) : (Result)new Ok((Object)true);
        Result publishResult2 = brokerClient.publishVerificationResults(source.getAttributes(), result2, version2);
        if (publishResult2 instanceof Err) {
            this.getLogger().error((Function0)new Function0<String>(publishResult2){
                final /* synthetic */ Result $publishResult;

                @NotNull
                public final String invoke() {
                    return "Failed to publish verification results - " + (String)((Err)this.$publishResult).getError();
                }
                {
                    this.$publishResult = result2;
                    super(0);
                }
            });
        } else {
            this.getLogger().info((Function0)new Function0<String>(result2, pact2){
                final /* synthetic */ TestResult $result;
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "Published verification result of '" + this.$result + "' for consumer '" + this.$pact.getConsumer() + '\'';
                }
                {
                    this.$result = testResult;
                    this.$pact = pact2;
                    super(0);
                }
            });
        }
        if (tagsResult instanceof Err && publishResult2 instanceof Ok) {
            result3 = tagsResult;
        } else if (tagsResult instanceof Err && publishResult2 instanceof Err) {
            result3 = (Result)new Err((Object)CollectionsKt.plus((Collection)((Collection)((Err)tagsResult).getError()), (Object)((Err)publishResult2).getError()));
        } else {
            Result $this$mapError$iv = publishResult2;
            boolean $i$f$mapError = false;
            boolean bl2 = false;
            Result result4 = $this$mapError$iv;
            if (result4 instanceof Ok) {
                result3 = $this$mapError$iv;
            } else if (result4 instanceof Err) {
                List list;
                String it = (String)((Err)$this$mapError$iv).getError();
                boolean bl3 = false;
                List list2 = list = CollectionsKt.listOf((Object)it);
                result3 = (Result)new Err((Object)list2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result3;
    }

    @Override
    public boolean publishingResultsDisabled() {
        return this.publishingResultsDisabled((ValueResolver)SystemPropertyResolver.INSTANCE);
    }

    @Override
    public boolean publishingResultsDisabled(@NotNull ValueResolver resolver) {
        String string;
        String property;
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        String string2 = property = resolver.resolveValue("pact.verifier.publishResults", "false");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)"true") ^ true;
    }

    private DefaultVerificationReporter() {
    }

    static {
        DefaultVerificationReporter defaultVerificationReporter;
        INSTANCE = defaultVerificationReporter = new DefaultVerificationReporter();
    }
}

