/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.matchers.util.CollectionUtilsKt;
import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactBrokerSource;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.ConsumerVersionSelector;
import au.com.dius.pact.core.pactbroker.IPactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Utils;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.junitsupport.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junitsupport.loader.OverrideablePactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactBroker;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerLoader;
import au.com.dius.pact.provider.junitsupport.loader.VersionSelector;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import mu.KLogging;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 Y2\u00020\u0001:\u0001YB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u00a5\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010<\u001a\u00020=2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\n2\u0006\u00107\u001a\u00020\u0014J\b\u0010@\u001a\u00020\u0006H\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u00107\u001a\u00020\u0014H\u0002J\n\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0018\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u001a\u0010J\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030K0\n2\u0006\u0010G\u001a\u00020\u0006H\u0016J0\u0010L\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030K0\n2\u0006\u0010G\u001a\u00020\u00062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020?0\n2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0018\u0010N\u001a\u00020I2\u0006\u0010O\u001a\u00020P2\u0006\u00107\u001a\u00020\u0014H\u0016J\u0018\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u0006H\u0016J\u0010\u0010U\u001a\u00020R2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010V\u001a\u00020\u0014H\u0002J*\u0010W\u001a\u00020\u000f2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u00107\u001a\u00020\u0014R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u0010\u0010%\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001fR$\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010.\u001a\u0004\b/\u0010(R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010(R\u0010\u00107\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006Z"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerLoader;", "Lau/com/dius/pact/provider/junitsupport/loader/OverrideablePactLoader;", "pactBroker", "Lau/com/dius/pact/provider/junitsupport/loader/PactBroker;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactBroker;)V", "pactBrokerHost", "", "pactBrokerPort", "pactBrokerScheme", "pactBrokerTags", "", "pactBrokerConsumerVersionSelectors", "Lau/com/dius/pact/provider/junitsupport/loader/VersionSelector;", "pactBrokerConsumers", "failIfNoPactsFound", "", "authentication", "Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;", "valueResolverClass", "Lkotlin/reflect/KClass;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "valueResolver", "enablePendingPacts", "providerTags", "includeWipPactsSince", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;Lkotlin/reflect/KClass;Lau/com/dius/pact/core/support/expressions/ValueResolver;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getAuthentication", "()Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;", "setAuthentication", "(Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerAuth;)V", "getEnablePendingPacts", "()Ljava/lang/String;", "getFailIfNoPactsFound", "()Z", "setFailIfNoPactsFound", "(Z)V", "getIncludeWipPactsSince", "overriddenConsumer", "overriddenPactUrl", "getPactBrokerConsumerVersionSelectors", "()Ljava/util/List;", "getPactBrokerConsumers", "getPactBrokerHost", "getPactBrokerPort", "getPactBrokerScheme", "pactBrokerTags$annotations", "()V", "getPactBrokerTags", "pactReader", "Lau/com/dius/pact/core/model/PactReader;", "getPactReader", "()Lau/com/dius/pact/core/model/PactReader;", "setPactReader", "(Lau/com/dius/pact/core/model/PactReader;)V", "getProviderTags", "resolver", "getValueResolverClass", "()Lkotlin/reflect/KClass;", "setValueResolverClass", "(Lkotlin/reflect/KClass;)V", "brokerUrl", "Lorg/apache/http/client/utils/URIBuilder;", "buildConsumerVersionSelectors", "Lau/com/dius/pact/core/pactbroker/ConsumerVersionSelector;", "description", "getPactBrokerSource", "Lau/com/dius/pact/core/model/PactBrokerSource;", "Lau/com/dius/pact/core/model/Interaction;", "getPactSource", "Lau/com/dius/pact/core/model/PactSource;", "getUrlForProvider", "providerName", "pactBrokerClient", "Lau/com/dius/pact/core/pactbroker/IPactBrokerClient;", "load", "Lau/com/dius/pact/core/model/Pact;", "loadPactsForProvider", "selectors", "newPactBrokerClient", "url", "Ljava/net/URI;", "overridePactUrl", "", "pactUrl", "consumer", "setValueResolver", "setupValueResolver", "shouldFallBackToTags", "tags", "Companion", "provider"})
public class PactBrokerLoader
implements OverrideablePactLoader {
    private ValueResolver resolver;
    private String overriddenPactUrl;
    private String overriddenConsumer;
    @NotNull
    private PactReader pactReader;
    @NotNull
    private final String pactBrokerHost;
    @Nullable
    private final String pactBrokerPort;
    @NotNull
    private final String pactBrokerScheme;
    @Nullable
    private final List<String> pactBrokerTags;
    @NotNull
    private final List<VersionSelector> pactBrokerConsumerVersionSelectors;
    @NotNull
    private final List<String> pactBrokerConsumers;
    private boolean failIfNoPactsFound;
    @Nullable
    private PactBrokerAuth authentication;
    @Nullable
    private KClass<? extends ValueResolver> valueResolverClass;
    @NotNull
    private final String enablePendingPacts;
    @NotNull
    private final List<String> providerTags;
    @NotNull
    private final String includeWipPactsSince;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PactReader getPactReader() {
        return this.pactReader;
    }

    public final void setPactReader(@NotNull PactReader pactReader) {
        Intrinsics.checkParameterIsNotNull((Object)pactReader, (String)"<set-?>");
        this.pactReader = pactReader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String description() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        ValueResolver resolver = this.setupValueResolver();
        List<ConsumerVersionSelector> consumerVersionSelectors = this.buildConsumerVersionSelectors(resolver);
        Iterable $this$flatMap$iv = this.pactBrokerConsumers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List consumers = (List)destination$iv$iv;
        String source = this.getPactBrokerSource(resolver).description();
        Collection collection = consumerVersionSelectors;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            source = source + " consumerVersionSelectors=" + consumerVersionSelectors;
        }
        if (KotlinLanguageSupportKt.isNotEmpty((List)consumers)) {
            source = source + " consumers=" + consumers;
        }
        return source;
    }

    @Override
    public void overridePactUrl(@NotNull String pactUrl, @NotNull String consumer) {
        Intrinsics.checkParameterIsNotNull((Object)pactUrl, (String)"pactUrl");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        this.overriddenPactUrl = pactUrl;
        this.overriddenConsumer = consumer;
    }

    @NotNull
    public List<Pact<?>> load(@NotNull String providerName) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        ValueResolver resolver = this.setupValueResolver();
        if (KotlinLanguageSupportKt.isNotEmpty((String)this.overriddenPactUrl)) {
            URI brokerUri;
            URI uRI = brokerUri = this.brokerUrl(resolver).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"brokerUri");
            IPactBrokerClient pactBrokerClient = this.newPactBrokerClient(uRI, resolver);
            String string = this.overriddenPactUrl;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = brokerUri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"brokerUri.toString()");
            BrokerUrlSource pactSource = new BrokerUrlSource(string, string2, null, pactBrokerClient.getOptions(), null, null, 52, null);
            pactSource.setEncodePath(false);
            list = CollectionsKt.listOf((Object)this.pactReader.loadPact((Object)pactSource, pactBrokerClient.getOptions()));
        } else {
            List list2;
            try {
                List<ConsumerVersionSelector> consumerVersionSelectors = this.buildConsumerVersionSelectors(resolver);
                list2 = this.loadPactsForProvider(providerName, consumerVersionSelectors, resolver);
            }
            catch (NoPactsFoundException e) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConsumerVersionSelector> buildConsumerVersionSelectors(@NotNull ValueResolver resolver) {
        List list;
        Iterable $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        List list2 = this.pactBrokerTags;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = list3;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List tags = (List)destination$iv$iv;
        if (this.shouldFallBackToTags(tags, this.pactBrokerConsumerVersionSelectors, resolver)) {
            $this$flatMap$iv = this.pactBrokerConsumers;
            List list4 = tags;
            Object object = Utils.INSTANCE;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list5 = (List)destination$iv$iv;
            Iterable $this$map$iv = object.permutations(list4, list5);
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                list4 = new ConsumerVersionSelector((String)it.getFirst(), false, (String)it.getSecond(), null, 10, null);
                object.add(list4);
            }
            list = (List)destination$iv$iv;
        } else {
            $this$flatMap$iv = this.pactBrokerConsumerVersionSelectors;
            $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list6;
                List latest;
                List list7;
                String string;
                Collection<String> collection;
                int n;
                int n2;
                it = (VersionSelector)element$iv$iv;
                boolean bl5 = false;
                List tags2 = ExpressionParser.parseListExpression((String)it.tag(), (ValueResolver)resolver);
                String consumer = (String)ExpressionParser.parseExpression((String)it.consumer(), (DataType)DataType.STRING, (ValueResolver)resolver);
                String fallbackTag = (String)ExpressionParser.parseExpression((String)it.fallbackTag(), (DataType)DataType.STRING, (ValueResolver)resolver);
                List parsedLatest = ExpressionParser.parseListExpression((String)it.latest(), (ValueResolver)resolver);
                if (parsedLatest.isEmpty()) {
                    n2 = tags2.size();
                    boolean bl6 = false;
                    boolean bl7 = false;
                    ArrayList<String> arrayList = new ArrayList<String>(n2);
                    boolean bl8 = false;
                    int n3 = 0;
                    n3 = 0;
                    int n4 = n2;
                    while (n3 < n4) {
                        int n5 = n3++;
                        n = 0;
                        int n6 = n5;
                        collection = arrayList;
                        boolean bl9 = false;
                        string = String.valueOf(true);
                        ((ArrayList)collection).add(string);
                    }
                    list7 = arrayList;
                } else {
                    list7 = latest = parsedLatest.size() == 1 ? CollectionUtilsKt.padTo((List)parsedLatest, (int)tags2.size(), parsedLatest.get(0)) : parsedLatest;
                }
                if (tags2.size() != latest.size()) {
                    throw (Throwable)new IllegalArgumentException("Invalid Consumer version selectors. Each version selector must have a tag and latest property");
                }
                if (KotlinLanguageSupportKt.isNotEmpty((List)tags2)) {
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapIndexed$iv = tags2;
                    boolean $i$f$mapIndexed = false;
                    Iterable iterable2 = $this$mapIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        String string2;
                        void tag;
                        void index;
                        n = index$iv$iv++;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl10 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        int n7 = n;
                        String string3 = (String)item$iv$iv;
                        int n8 = n7;
                        collection = collection2;
                        boolean bl11 = false;
                        String string4 = (String)latest.get((int)index);
                        void var35_45 = tag;
                        boolean bl12 = false;
                        boolean bl13 = Boolean.parseBoolean(string4);
                        string4 = consumer;
                        String string5 = string2 = fallbackTag;
                        String string6 = string4;
                        boolean bl14 = bl13;
                        void var46_52 = var35_45;
                        string = new ConsumerVersionSelector((String)var46_52, bl14, string6, string5);
                        collection.add(string);
                    }
                    list6 = (List)destination$iv$iv2;
                } else if (KotlinLanguageSupportKt.isNotEmpty((String)consumer)) {
                    String string7 = consumer;
                    String string8 = fallbackTag;
                    list6 = CollectionsKt.listOf((Object)new ConsumerVersionSelector(null, true, string7, string8));
                } else {
                    n2 = 0;
                    list6 = CollectionsKt.emptyList();
                }
                list$iv$iv = list6;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public final boolean shouldFallBackToTags(@NotNull List<String> tags, @NotNull List<VersionSelector> selectors, @NotNull ValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        Intrinsics.checkParameterIsNotNull(selectors, (String)"selectors");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        return selectors.isEmpty() || selectors.size() == 1 && ExpressionParser.parseListExpression((String)selectors.get(0).tag(), (ValueResolver)resolver).isEmpty() && KotlinLanguageSupportKt.isNotEmpty(tags);
    }

    private final ValueResolver setupValueResolver() {
        ValueResolver valueResolver = (ValueResolver)SystemPropertyResolver.INSTANCE;
        if (this.resolver != null) {
            ValueResolver valueResolver2 = this.resolver;
            if (valueResolver2 == null) {
                Intrinsics.throwNpe();
            }
            valueResolver = valueResolver2;
        } else if (this.valueResolverClass != null) {
            try {
                KClass<? extends ValueResolver> kClass = this.valueResolverClass;
                if (kClass == null) {
                    Intrinsics.throwNpe();
                }
                Object t = JvmClassMappingKt.getJavaClass(kClass).newInstance();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"valueResolverClass!!.java.newInstance()");
                valueResolver = (ValueResolver)t;
            }
            catch (InstantiationException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.1.INSTANCE);
            }
            catch (IllegalAccessException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.2.INSTANCE);
            }
        }
        return valueResolver;
    }

    @Override
    @Nullable
    public PactSource getPactSource() {
        ValueResolver resolver = this.setupValueResolver();
        return (PactSource)this.getPactBrokerSource(resolver);
    }

    @Override
    public void setValueResolver(@NotNull ValueResolver valueResolver) {
        Intrinsics.checkParameterIsNotNull((Object)valueResolver, (String)"valueResolver");
        this.resolver = valueResolver;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pact<?>> loadPactsForProvider(String providerName, List<ConsumerVersionSelector> selectors, ValueResolver resolver) throws IOException, IllegalArgumentException {
        String string;
        Iterator $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Companion.getLogger().debug((Function0)new Function0<String>(providerName, selectors){
            final /* synthetic */ String $providerName;
            final /* synthetic */ List $selectors;

            @NotNull
            public final String invoke() {
                return "Loading pacts from pact broker for provider " + this.$providerName + " and consumer version selectors " + this.$selectors;
            }
            {
                this.$providerName = string;
                this.$selectors = list;
                super(0);
            }
        });
        Object object = ExpressionParser.parseExpression((String)this.enablePendingPacts, (DataType)DataType.BOOLEAN, (ValueResolver)resolver);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean pending = (Boolean)object;
        Iterable $this$flatMap$iv = this.providerTags;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it, (ValueResolver)resolver);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List providerTags = (List)destination$iv$iv;
        if (pending) {
            boolean bl;
            block20: {
                Iterable $this$none$iv = providerTags;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it2 = (String)element$iv;
                        boolean bl2 = false;
                        if (!KotlinLanguageSupportKt.isNotEmpty((String)it2)) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw (Throwable)new IllegalArgumentException("Pending pacts feature has been enabled, but no provider tags have been specified. To use the pending pacts feature, you need to provide the list of provider names for the provider application version with the providerTags property that will be published with the verification results.");
            }
        }
        if (pending) {
            Object object2 = ExpressionParser.parseExpression((String)this.includeWipPactsSince, (DataType)DataType.STRING, (ValueResolver)resolver);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object2;
        } else {
            string = "";
        }
        String wipSinceDate = string;
        URIBuilder uriBuilder = this.brokerUrl(resolver);
        try {
            void $this$mapTo$iv$iv;
            Result result2;
            URI uRI = uriBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uriBuilder.build()");
            IPactBrokerClient pactBrokerClient = this.newPactBrokerClient(uRI, resolver);
            Result bl2 = result2 = pactBrokerClient.fetchConsumersWithSelectors(providerName, selectors, providerTags, pending, wipSinceDate);
            if (!(bl2 instanceof Ok)) {
                if (bl2 instanceof Err) {
                    throw (Throwable)((Err)result2).getError();
                }
                throw new NoWhenBranchMatchedException();
            }
            List consumers = (List)((Ok)result2).getValue();
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                throw (Throwable)new NoPactsFoundException("No consumer pacts were found for provider '" + providerName + "' and consumer " + "version selectors '" + selectors + "'. (URL " + this.getUrlForProvider(providerName, pactBrokerClient) + ")");
            }
            if (KotlinLanguageSupportKt.isNotEmpty(this.pactBrokerConsumers)) {
                void $this$filterTo$iv$iv2;
                String it3;
                Iterable $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2 = this.pactBrokerConsumers;
                boolean $i$f$flatMap2 = false;
                Iterable bl = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    it3 = (String)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = ExpressionParser.parseListExpression((String)it3, (ValueResolver)resolver);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List consumerInclusions = (List)destination$iv$iv2;
                Iterable $this$filter$iv2 = consumers;
                boolean $i$f$filter2 = false;
                $this$flatMapTo$iv$iv2 = $this$filter$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it3 = (PactBrokerResult)element$iv$iv;
                    boolean bl4 = false;
                    if (!(it3.getUsedNewEndpoint() || consumerInclusions.isEmpty() || consumerInclusions.contains(it3.getName()))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                consumers = (List)destination$iv$iv2;
            }
            Iterable $this$map$iv = consumers;
            boolean $i$f$map = false;
            Iterable $i$f$filter2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                Object element$iv$iv;
                element$iv$iv = (PactBrokerResult)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                Pact pact2 = this.pactReader.loadPact((Object)it4, pactBrokerClient.getOptions());
                collection.add(pact2);
            }
            return (List)destination$iv$iv3;
        }
        catch (URISyntaxException e) {
            throw (Throwable)new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final URIBuilder brokerUrl(ValueResolver resolver) {
        void port;
        void host;
        PactBrokerSource<Interaction> pactBrokerSource = this.getPactBrokerSource(resolver);
        String string = pactBrokerSource.component1();
        String string2 = pactBrokerSource.component2();
        String scheme = pactBrokerSource.component3();
        URIBuilder uriBuilder = new URIBuilder().setScheme(scheme).setHost((String)host);
        if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
            URIBuilder uRIBuilder = uriBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRIBuilder, (String)"uriBuilder");
            uRIBuilder.setPort(Integer.parseInt((String)port));
        }
        URIBuilder uRIBuilder = uriBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRIBuilder, (String)"uriBuilder");
        return uRIBuilder;
    }

    private final PactBrokerSource<Interaction> getPactBrokerSource(ValueResolver resolver) {
        Object object;
        boolean bl;
        CharSequence charSequence;
        String port;
        String host;
        String scheme;
        block7: {
            String string;
            block6: {
                Object object2 = ExpressionParser.parseExpression((String)this.pactBrokerScheme, (DataType)DataType.RAW, (ValueResolver)resolver);
                scheme = object2 != null ? object2.toString() : null;
                Object object3 = ExpressionParser.parseExpression((String)this.pactBrokerHost, (DataType)DataType.RAW, (ValueResolver)resolver);
                host = object3 != null ? object3.toString() : null;
                Object object4 = ExpressionParser.parseExpression((String)this.pactBrokerPort, (DataType)DataType.RAW, (ValueResolver)resolver);
                port = object4 != null ? object4.toString() : null;
                charSequence = host;
                boolean bl2 = false;
                bl = false;
                if (charSequence == null || charSequence.length() == 0) break block6;
                charSequence = host;
                object = new Regex("[0-9a-zA-Z\\-.]+");
                bl = false;
                if (object.matches(charSequence)) break block7;
            }
            charSequence = StringCompanionObject.INSTANCE;
            String string2 = "Invalid pact broker host specified ('%s'). Please provide a valid host or specify the system property 'pactbroker.host'.";
            Object[] objectArray = new Object[]{this.pactBrokerHost};
            boolean bl3 = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)port)) {
            String string = port;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSequence = string;
            object = new Regex("^[0-9]+");
            bl = false;
            if (!object.matches(charSequence)) {
                String string5;
                charSequence = StringCompanionObject.INSTANCE;
                object = "Invalid pact broker port specified ('%s'). Please provide a valid port number or specify the system property 'pactbroker.port'.";
                Object[] objectArray = new Object[]{this.pactBrokerPort};
                boolean bl4 = false;
                String string6 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
                String string7 = string5 = string6;
                throw (Throwable)new IllegalArgumentException(string7);
            }
        }
        return scheme == null ? new PactBrokerSource(host, port, null, null, 12, null) : new PactBrokerSource(host, port, scheme, null, 8, null);
    }

    private final String getUrlForProvider(String providerName, IPactBrokerClient pactBrokerClient) {
        String string;
        try {
            String string2 = pactBrokerClient.getUrlForProvider(providerName, "");
            if (string2 == null) {
                string2 = "Unknown";
            }
            string = string2;
        }
        catch (Exception e) {
            Companion.getLogger().debug((Throwable)e, (Function0)getUrlForProvider.1.INSTANCE);
            string = "Unknown";
        }
        return string;
    }

    @NotNull
    public IPactBrokerClient newPactBrokerClient(@NotNull URI url, @NotNull ValueResolver resolver) {
        String token;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        if (this.authentication == null) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.1.INSTANCE);
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            String string2 = string;
            boolean bl = false;
            Map map = new LinkedHashMap();
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            PactBrokerClientConfig pactBrokerClientConfig = null;
            Map map2 = map;
            String string3 = string2;
            return (IPactBrokerClient)new PactBrokerClient(string3, map2, pactBrokerClientConfig, n, defaultConstructorMarker);
        }
        PactBrokerAuth pactBrokerAuth = this.authentication;
        if (pactBrokerAuth == null) {
            Intrinsics.throwNpe();
        }
        Object object = ExpressionParser.parseExpression((String)pactBrokerAuth.username(), (DataType)DataType.RAW, (ValueResolver)resolver);
        String username = object != null ? object.toString() : null;
        PactBrokerAuth pactBrokerAuth2 = this.authentication;
        if (pactBrokerAuth2 == null) {
            Intrinsics.throwNpe();
        }
        Object object2 = ExpressionParser.parseExpression((String)pactBrokerAuth2.token(), (DataType)DataType.RAW, (ValueResolver)resolver);
        String string = token = object2 != null ? object2.toString() : null;
        if (KotlinLanguageSupportKt.isNotEmpty((String)username)) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.2.INSTANCE);
            Object[] objectArray = new Object[3];
            objectArray[0] = "basic";
            objectArray[1] = username;
            PactBrokerAuth pactBrokerAuth3 = this.authentication;
            if (pactBrokerAuth3 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[2] = ExpressionParser.parseExpression((String)pactBrokerAuth3.password(), (DataType)DataType.RAW, (ValueResolver)resolver);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])objectArray)));
            String string4 = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"url.toString()");
            return (IPactBrokerClient)new PactBrokerClient(string4, MapsKt.toMutableMap((Map)options), null, 4, null);
        }
        if (KotlinLanguageSupportKt.isNotEmpty((String)token)) {
            Companion.getLogger().debug((Function0)newPactBrokerClient.3.INSTANCE);
            Map options = MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication", (Object)CollectionsKt.listOf((Object[])new String[]{"bearer", token})));
            String string5 = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"url.toString()");
            return (IPactBrokerClient)new PactBrokerClient(string5, MapsKt.toMutableMap((Map)options), null, 4, null);
        }
        Companion.getLogger().debug((Function0)newPactBrokerClient.4.INSTANCE);
        String string6 = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"url.toString()");
        String string7 = string6;
        boolean bl = false;
        Map map = new LinkedHashMap();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        PactBrokerClientConfig pactBrokerClientConfig = null;
        Map map3 = map;
        String string8 = string7;
        return (IPactBrokerClient)new PactBrokerClient(string8, map3, pactBrokerClientConfig, n, defaultConstructorMarker);
    }

    @NotNull
    public final String getPactBrokerHost() {
        return this.pactBrokerHost;
    }

    @Nullable
    public final String getPactBrokerPort() {
        return this.pactBrokerPort;
    }

    @NotNull
    public final String getPactBrokerScheme() {
        return this.pactBrokerScheme;
    }

    @Deprecated(message="Use Consumer version selectors instead", replaceWith=@ReplaceWith(imports={}, expression="pactBrokerConsumerVersionSelectors"))
    public static /* synthetic */ void pactBrokerTags$annotations() {
    }

    @Nullable
    public final List<String> getPactBrokerTags() {
        return this.pactBrokerTags;
    }

    @NotNull
    public final List<VersionSelector> getPactBrokerConsumerVersionSelectors() {
        return this.pactBrokerConsumerVersionSelectors;
    }

    @NotNull
    public final List<String> getPactBrokerConsumers() {
        return this.pactBrokerConsumers;
    }

    public final boolean getFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public final void setFailIfNoPactsFound(boolean bl) {
        this.failIfNoPactsFound = bl;
    }

    @Nullable
    public final PactBrokerAuth getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(@Nullable PactBrokerAuth pactBrokerAuth) {
        this.authentication = pactBrokerAuth;
    }

    @Nullable
    public final KClass<? extends ValueResolver> getValueResolverClass() {
        return this.valueResolverClass;
    }

    public final void setValueResolverClass(@Nullable KClass<? extends ValueResolver> kClass) {
        this.valueResolverClass = kClass;
    }

    @NotNull
    public final String getEnablePendingPacts() {
        return this.enablePendingPacts;
    }

    @NotNull
    public final List<String> getProviderTags() {
        return this.providerTags;
    }

    @NotNull
    public final String getIncludeWipPactsSince() {
        return this.includeWipPactsSince;
    }

    public PactBrokerLoader(@NotNull String pactBrokerHost, @Nullable String pactBrokerPort, @NotNull String pactBrokerScheme, @Nullable List<String> pactBrokerTags, @NotNull List<VersionSelector> pactBrokerConsumerVersionSelectors, @NotNull List<String> pactBrokerConsumers, boolean failIfNoPactsFound, @Nullable PactBrokerAuth authentication, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver, @NotNull String enablePendingPacts, @NotNull List<String> providerTags, @NotNull String includeWipPactsSince) {
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerHost, (String)"pactBrokerHost");
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerScheme, (String)"pactBrokerScheme");
        Intrinsics.checkParameterIsNotNull(pactBrokerConsumerVersionSelectors, (String)"pactBrokerConsumerVersionSelectors");
        Intrinsics.checkParameterIsNotNull(pactBrokerConsumers, (String)"pactBrokerConsumers");
        Intrinsics.checkParameterIsNotNull((Object)enablePendingPacts, (String)"enablePendingPacts");
        Intrinsics.checkParameterIsNotNull(providerTags, (String)"providerTags");
        Intrinsics.checkParameterIsNotNull((Object)includeWipPactsSince, (String)"includeWipPactsSince");
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerScheme = pactBrokerScheme;
        this.pactBrokerTags = pactBrokerTags;
        this.pactBrokerConsumerVersionSelectors = pactBrokerConsumerVersionSelectors;
        this.pactBrokerConsumers = pactBrokerConsumers;
        this.failIfNoPactsFound = failIfNoPactsFound;
        this.authentication = authentication;
        this.valueResolverClass = valueResolverClass;
        this.enablePendingPacts = enablePendingPacts;
        this.providerTags = providerTags;
        this.includeWipPactsSince = includeWipPactsSince;
        this.resolver = valueResolver;
        this.pactReader = (PactReader)DefaultPactReader.INSTANCE;
    }

    public /* synthetic */ PactBrokerLoader(String string, String string2, String string3, List list, List list2, List list3, boolean bl, PactBrokerAuth pactBrokerAuth, KClass kClass, ValueResolver valueResolver, String string4, List list4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)"latest");
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x200) != 0) {
            valueResolver = null;
        }
        if ((n & 0x400) != 0) {
            string4 = "false";
        }
        if ((n & 0x800) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x1000) != 0) {
            string5 = "";
        }
        this(string, string2, string3, list, list2, list3, bl, pactBrokerAuth, (KClass<? extends ValueResolver>)kClass, valueResolver, string4, list4, string5);
    }

    public PactBrokerLoader(@NotNull PactBroker pactBroker) {
        Intrinsics.checkParameterIsNotNull((Object)pactBroker, (String)"pactBroker");
        this(pactBroker.host(), pactBroker.port(), pactBroker.scheme(), ArraysKt.toList((Object[])pactBroker.tags()), ArraysKt.toList((Object[])pactBroker.consumerVersionSelectors()), ArraysKt.toList((Object[])pactBroker.consumers()), true, pactBroker.authentication(), (KClass<? extends ValueResolver>)Reflection.getOrCreateKotlinClass(pactBroker.valueResolver()), null, pactBroker.enablePendingPacts(), ArraysKt.toList((Object[])pactBroker.providerTags()), pactBroker.includeWipPactsSince());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactBrokerLoader$Companion;", "Lmu/KLogging;", "()V", "provider"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

