/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.provider.DefaultTestResultAccumulator;
import au.com.dius.pact.provider.DefaultVerificationReporter;
import au.com.dius.pact.provider.ProviderVersion;
import au.com.dius.pact.provider.TestResultAccumulator;
import au.com.dius.pact.provider.VerificationReporter;
import au.com.dius.pact.provider.VerificationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00062\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\"\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J2\u0010 \u001a\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010 \u001a\u00020\u00192\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lau/com/dius/pact/provider/DefaultTestResultAccumulator;", "Lau/com/dius/pact/provider/TestResultAccumulator;", "Lmu/KLogging;", "()V", "testResults", "", "", "Lau/com/dius/pact/core/pactbroker/TestResult;", "getTestResults", "()Ljava/util/Map;", "verificationReporter", "Lau/com/dius/pact/provider/VerificationReporter;", "getVerificationReporter", "()Lau/com/dius/pact/provider/VerificationReporter;", "setVerificationReporter", "(Lau/com/dius/pact/provider/VerificationReporter;)V", "calculateInteractionHash", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "calculatePactHash", "pact", "Lau/com/dius/pact/core/model/Pact;", "source", "Lau/com/dius/pact/core/model/PactSource;", "clearTestResult", "", "lookupProviderTags", "", "", "lookupProviderVersion", "unverifiedInteractions", "results", "updateTestResult", "testExecutionResult", "Lau/com/dius/pact/provider/VerificationResult$Failed;", "provider"})
public final class DefaultTestResultAccumulator
extends KLogging
implements TestResultAccumulator {
    @NotNull
    private static final Map<Integer, Map<Integer, TestResult>> testResults;
    @NotNull
    private static VerificationReporter verificationReporter;
    public static final DefaultTestResultAccumulator INSTANCE;

    @NotNull
    public final Map<Integer, Map<Integer, TestResult>> getTestResults() {
        return testResults;
    }

    @NotNull
    public final VerificationReporter getVerificationReporter() {
        return verificationReporter;
    }

    public final void setVerificationReporter(@NotNull VerificationReporter verificationReporter) {
        Intrinsics.checkParameterIsNotNull((Object)verificationReporter, (String)"<set-?>");
        DefaultTestResultAccumulator.verificationReporter = verificationReporter;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTestResult(@NotNull Pact<Interaction> pact2, @NotNull Interaction interaction, @NotNull List<VerificationResult.Failed> testExecutionResult, @NotNull PactSource source) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull(testExecutionResult, (String)"testExecutionResult");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Iterable iterable = testExecutionResult;
        TestResult.Ok ok = TestResult.Ok.INSTANCE;
        Interaction interaction2 = interaction;
        Pact<Interaction> pact3 = pact2;
        DefaultTestResultAccumulator defaultTestResultAccumulator = this;
        boolean $i$f$fold = false;
        TestResult accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void r;
            VerificationResult.Failed failed = (VerificationResult.Failed)element$iv;
            TestResult acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.merge(r.toTestResult());
        }
        void var17_17 = accumulator$iv;
        defaultTestResultAccumulator.updateTestResult(pact3, interaction2, (TestResult)var17_17, source);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTestResult(@NotNull Pact<? extends Interaction> pact2, @NotNull Interaction interaction, @NotNull TestResult testExecutionResult, @Nullable PactSource source) {
        int interactionHash;
        Map interactionResults;
        TestResult testResult;
        Object object;
        Map answer$iv;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)testExecutionResult, (String)"testExecutionResult");
        this.getLogger().debug((Function0)new Function0<String>(testExecutionResult, pact2, interaction, source){
            final /* synthetic */ TestResult $testExecutionResult;
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Interaction $interaction;
            final /* synthetic */ PactSource $source;

            @NotNull
            public final String invoke() {
                PactSource pactSource = this.$source;
                return "Received test result '" + this.$testExecutionResult + "' for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + ' ' + "and " + this.$interaction.getDescription() + " (" + (pactSource != null ? pactSource.description() : null) + ')';
            }
            {
                this.$testExecutionResult = testResult;
                this.$pact = pact2;
                this.$interaction = interaction;
                this.$source = pactSource;
                super(0);
            }
        });
        int pactHash = this.calculatePactHash(pact2, source);
        Map<Integer, Map<Integer, TestResult>> map = testResults;
        Integer key$iv = pactHash;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((testResult = (TestResult)(interactionResults = (Map)object).get(interactionHash = this.calculateInteractionHash(interaction))) == null) {
            interactionResults.put(interactionHash, testExecutionResult);
        } else {
            interactionResults.put(interactionHash, testResult.merge(testExecutionResult));
        }
        List<Interaction> unverifiedInteractions2 = this.unverifiedInteractions(pact2, interactionResults);
        if (unverifiedInteractions2.isEmpty()) {
            this.getLogger().debug((Function0)new Function0<String>(pact2){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "All interactions for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + " have a verification result";
                }
                {
                    this.$pact = pact2;
                    super(0);
                }
            });
            if (verificationReporter.publishingResultsDisabled()) {
                this.getLogger().warn((Function0)updateTestResult.4.INSTANCE);
            } else {
                void $this$fold$iv;
                void initial$iv;
                value$iv = interactionResults.values();
                answer$iv = TestResult.Ok.INSTANCE;
                Pact<? extends Interaction> pact3 = pact2;
                VerificationReporter verificationReporter = DefaultTestResultAccumulator.verificationReporter;
                boolean $i$f$fold = false;
                TestResult accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void result2;
                    TestResult testResult2 = (TestResult)element$iv;
                    TestResult acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.merge((TestResult)result2);
                }
                void var21_29 = accumulator$iv;
                verificationReporter.reportResults(pact3, (TestResult)var21_29, this.lookupProviderVersion(), null, this.lookupProviderTags());
            }
            testResults.remove(pactHash);
        } else {
            this.getLogger().warn((Function0)new Function0<String>(pact2){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "Not all of the " + this.$pact.getInteractions().size() + " were verified. The following were missing:";
                }
                {
                    this.$pact = pact2;
                    super(0);
                }
            });
            Iterable $this$forEach$iv = unverifiedInteractions2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Interaction it = (Interaction)element$iv;
                boolean bl = false;
                INSTANCE.getLogger().warn((Function0)new Function0<String>(it){
                    final /* synthetic */ Interaction $it;

                    @NotNull
                    public final String invoke() {
                        return "    " + this.$it.getDescription();
                    }
                    {
                        this.$it = interaction;
                        super(0);
                    }
                });
            }
        }
    }

    public final int calculateInteractionHash(@NotNull Interaction interaction) {
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)interaction.getDescription());
        Iterable $this$forEach$iv = interaction.getProviderStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProviderState it = (ProviderState)element$iv;
            boolean bl = false;
            builder.append((Object)it.getName());
        }
        return builder.toHashCode();
    }

    public final int calculatePactHash(@NotNull Pact<? extends Interaction> pact2, @Nullable PactSource source) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)pact2.getConsumer().getName()).append((Object)pact2.getProvider().getName());
        if (source instanceof BrokerUrlSource && KotlinLanguageSupportKt.isNotEmpty((String)((BrokerUrlSource)source).getTag())) {
            builder.append((Object)((BrokerUrlSource)source).getTag());
        }
        return builder.toHashCode();
    }

    @NotNull
    public final String lookupProviderVersion() {
        String string;
        String version2 = new ProviderVersion((Function0<String>)((Function0)lookupProviderVersion.version.1.INSTANCE)).get();
        CharSequence charSequence = version2;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.getLogger().warn((Function0)lookupProviderVersion.1.INSTANCE);
            string = "0.0.0";
        } else {
            string = version2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> lookupProviderTags() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("pact.provider.tag");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var10_10 = it;
            boolean bl3 = false;
            void v1 = var10_10;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
            collection.add(string4);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Interaction> unverifiedInteractions(@NotNull Pact<? extends Interaction> pact2, @NotNull Map<Integer, TestResult> results) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        this.getLogger().debug((Function0)new Function0<String>(pact2, results){
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Map $results;

            @NotNull
            public final String invoke() {
                return "Number of interactions #" + this.$pact.getInteractions().size() + " and results: " + this.$results.values();
            }
            {
                this.$pact = pact2;
                this.$results = map;
                super(0);
            }
        });
        Iterable $this$filter$iv = pact2.getInteractions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Interaction it = (Interaction)element$iv$iv;
            boolean bl = false;
            if (!(!results.containsKey(INSTANCE.calculateInteractionHash(it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void clearTestResult(@NotNull Pact<? extends Interaction> pact2, @Nullable PactSource source) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        int pactHash = this.calculatePactHash(pact2, source);
        testResults.remove(pactHash);
    }

    private DefaultTestResultAccumulator() {
    }

    static {
        DefaultTestResultAccumulator defaultTestResultAccumulator;
        INSTANCE = defaultTestResultAccumulator = new DefaultTestResultAccumulator();
        boolean bl = false;
        testResults = new LinkedHashMap();
        verificationReporter = DefaultVerificationReporter.INSTANCE;
    }
}

