/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.generators.RegexGenerator;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.support.Json;
import com.mifmif.common.regex.Generex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006."}, d2={"Lau/com/dius/pact/consumer/dsl/ArrayOfPrimitivesBuilder;", "", "()V", "examples", "", "getExamples", "()I", "setExamples", "(I)V", "generator", "Lau/com/dius/pact/core/model/generators/Generator;", "getGenerator", "()Lau/com/dius/pact/core/model/generators/Generator;", "setGenerator", "(Lau/com/dius/pact/core/model/generators/Generator;)V", "matcher", "Lau/com/dius/pact/core/model/matchingrules/MatchingRule;", "getMatcher", "()Lau/com/dius/pact/core/model/matchingrules/MatchingRule;", "setMatcher", "(Lau/com/dius/pact/core/model/matchingrules/MatchingRule;)V", "maxLength", "getMaxLength", "()Ljava/lang/Integer;", "setMaxLength", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "minLength", "getMinLength", "setMinLength", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "build", "Lau/com/dius/pact/consumer/dsl/DslPart;", "thatMatchRegex", "regex", "", "example", "withMaxLength", "max", "withMinLength", "min", "withNumberOfExamples", "consumer"})
public final class ArrayOfPrimitivesBuilder {
    @Nullable
    private Integer minLength;
    @Nullable
    private Integer maxLength;
    private int examples = 1;
    @Nullable
    private MatchingRule matcher;
    @Nullable
    private Object value;
    @Nullable
    private Generator generator;

    @Nullable
    public final Integer getMinLength() {
        return this.minLength;
    }

    public final void setMinLength(@Nullable Integer n) {
        this.minLength = n;
    }

    @Nullable
    public final Integer getMaxLength() {
        return this.maxLength;
    }

    public final void setMaxLength(@Nullable Integer n) {
        this.maxLength = n;
    }

    public final int getExamples() {
        return this.examples;
    }

    public final void setExamples(int n) {
        this.examples = n;
    }

    @Nullable
    public final MatchingRule getMatcher() {
        return this.matcher;
    }

    public final void setMatcher(@Nullable MatchingRule matchingRule) {
        this.matcher = matchingRule;
    }

    @Nullable
    public final Object getValue() {
        return this.value;
    }

    public final void setValue(@Nullable Object object) {
        this.value = object;
    }

    @Nullable
    public final Generator getGenerator() {
        return this.generator;
    }

    public final void setGenerator(@Nullable Generator generator) {
        this.generator = generator;
    }

    @NotNull
    public final ArrayOfPrimitivesBuilder withMinLength(int min) {
        this.minLength = min;
        return this;
    }

    @NotNull
    public final ArrayOfPrimitivesBuilder withMaxLength(int max) {
        this.maxLength = max;
        return this;
    }

    @NotNull
    public final ArrayOfPrimitivesBuilder withNumberOfExamples(int examples) {
        if (this.minLength != null) {
            Integer n = this.minLength;
            Intrinsics.checkNotNull((Object)n);
            if (examples < n) {
                throw new IllegalArgumentException("Number of example " + examples + " is less than the minimum size of " + this.minLength);
            }
        }
        if (this.maxLength != null) {
            Integer n = this.maxLength;
            Intrinsics.checkNotNull((Object)n);
            if (examples > n) {
                throw new IllegalArgumentException("Number of example " + examples + " is more than the maximum size of " + this.maxLength);
            }
        }
        this.examples = examples;
        return this;
    }

    @NotNull
    public final ArrayOfPrimitivesBuilder thatMatchRegex(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.matcher = (MatchingRule)new RegexMatcher(regex, null, 2, null);
        this.generator = (Generator)new RegexGenerator(regex);
        this.value = new Generex(regex).random();
        return this;
    }

    @NotNull
    public final ArrayOfPrimitivesBuilder thatMatchRegex(@NotNull String regex, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        CharSequence charSequence = example;
        if (!new Regex(regex).matches(charSequence)) {
            throw new InvalidMatcherException("example \"" + this.value + "\" does not match regular expression \"" + regex + "\"");
        }
        this.matcher = (MatchingRule)new RegexMatcher(regex, example);
        this.value = example;
        return this;
    }

    @NotNull
    public final DslPart build() {
        PactDslJsonArray array = new PactDslJsonArray("", "", null, true);
        array.setNumberExamples(this.examples);
        if (this.minLength != null && this.maxLength != null) {
            MatchingRuleCategory matchingRuleCategory = array.getMatchers();
            Integer n = this.minLength;
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = this.maxLength;
            Intrinsics.checkNotNull((Object)n3);
            MatchingRuleCategory.addRule$default((MatchingRuleCategory)matchingRuleCategory, (String)"", (MatchingRule)((MatchingRule)new MinMaxTypeMatcher(n2, n3.intValue())), null, (int)4, null);
        } else if (this.minLength != null) {
            MatchingRuleCategory matchingRuleCategory = array.getMatchers();
            Integer n = this.minLength;
            Intrinsics.checkNotNull((Object)n);
            MatchingRuleCategory.addRule$default((MatchingRuleCategory)matchingRuleCategory, (String)"", (MatchingRule)((MatchingRule)new MinTypeMatcher(n.intValue())), null, (int)4, null);
        } else if (this.maxLength != null) {
            MatchingRuleCategory matchingRuleCategory = array.getMatchers();
            Integer n = this.maxLength;
            Intrinsics.checkNotNull((Object)n);
            MatchingRuleCategory.addRule$default((MatchingRuleCategory)matchingRuleCategory, (String)"", (MatchingRule)((MatchingRule)new MaxTypeMatcher(n.intValue())), null, (int)4, null);
        }
        if (this.matcher != null) {
            MatchingRuleCategory matchingRuleCategory = array.getMatchers();
            MatchingRule matchingRule = this.matcher;
            Intrinsics.checkNotNull((Object)matchingRule);
            MatchingRuleCategory.addRule$default((MatchingRuleCategory)matchingRuleCategory, (String)"[*]", (MatchingRule)matchingRule, null, (int)4, null);
        }
        if (this.generator != null) {
            Generators generators = array.getGenerators();
            Generator generator = this.generator;
            Intrinsics.checkNotNull((Object)generator);
            generators.addGenerator(Category.BODY, "[*]", generator);
        }
        int n = this.examples;
        for (int i = 0; i < n; ++i) {
            array.getBody().add(Json.toJson((Object)this.value));
        }
        return array;
    }
}

