/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.InvalidPactException;
import au.com.dius.pact.model.MergeResult;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactMerge;
import au.com.dius.pact.model.PactSpecVersion;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J2\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J0\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0013"}, d2={"Lau/com/dius/pact/model/PactWriter;", "Lmu/KLogging;", "()V", "readLines", "", "file", "Ljava/io/RandomAccessFile;", "writePact", "", "I", "Lau/com/dius/pact/model/Interaction;", "pact", "Lau/com/dius/pact/model/Pact;", "writer", "Ljava/io/PrintWriter;", "pactSpecVersion", "Lau/com/dius/pact/model/PactSpecVersion;", "pactFile", "Ljava/io/File;", "pact-jvm-model"})
public final class PactWriter
extends KLogging {
    public static final PactWriter INSTANCE;

    @JvmStatic
    @JvmOverloads
    public static final <I extends Interaction> void writePact(@NotNull Pact<I> pact, @NotNull PrintWriter writer, @NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        pact.sortInteractions();
        Map<String, ?> jsonData = pact.toMap(pactSpecVersion);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson(jsonData, (Appendable)writer);
    }

    @JvmStatic
    @JvmOverloads
    public static /* synthetic */ void writePact$default(Pact pact, PrintWriter printWriter, PactSpecVersion pactSpecVersion, int n, Object object) {
        if ((n & 4) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        PactWriter.writePact(pact, printWriter, pactSpecVersion);
    }

    @JvmStatic
    @JvmOverloads
    public static final <I extends Interaction> void writePact(@NotNull Pact<I> pact, @NotNull PrintWriter writer) {
        PactWriter.writePact$default(pact, writer, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final synchronized <I extends Interaction> void writePact(@NotNull File pactFile, @NotNull Pact<I> pact, @NotNull PactSpecVersion pactSpecVersion) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)pactFile, (String)"pactFile");
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (pactFile.exists() && pactFile.length() > 0L) {
            RandomAccessFile raf = new RandomAccessFile(pactFile, "rw");
            FileLock lock = raf.getChannel().lock();
            try {
                Class<?> pactReaderClass = Class.forName("au.com.dius.pact.model.PactReader");
                Method loadPact = pactReaderClass.getDeclaredMethod("loadPact", Class.forName("java.lang.Object"));
                Object object2 = loadPact.invoke(null, INSTANCE.readLines(raf));
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.model.Pact<I>");
                }
                Pact existingPact = (Pact)object2;
                MergeResult<I> result = PactMerge.merge(existingPact, pact);
                if (!result.getOk()) {
                    throw (Throwable)new InvalidPactException(result.getMessage());
                }
                raf.seek(0L);
                StringWriter swriter = new StringWriter();
                PrintWriter writer = new PrintWriter(swriter);
                PactWriter.writePact(pact, writer, pactSpecVersion);
                String string = swriter.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"swriter.toString()");
                String string2 = string;
                Charset charset2 = Charsets.UTF_8;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] bytes = byArray;
                raf.setLength(bytes.length);
                raf.write(bytes);
            }
            finally {
                lock.release();
                raf.close();
            }
        }
        pactFile.getParentFile().mkdirs();
        Object object3 = pactFile;
        Object object4 = Charsets.UTF_8;
        File loadPact = object3;
        int n = 8192;
        Object object5 = object = loadPact;
        object5 = new FileOutputStream((File)object5);
        object = new OutputStreamWriter((OutputStream)object5, (Charset)object4);
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        object3 = new PrintWriter(writer);
        object4 = null;
        try {
            PrintWriter it = (PrintWriter)object3;
            boolean bl = false;
            PactWriter.writePact(pact, it, pactSpecVersion);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
        }
    }

    private final String readLines(RandomAccessFile file) {
        StringBuilder data = new StringBuilder();
        String line = file.readLine();
        while (line != null) {
            data.append(line);
            line = file.readLine();
        }
        String string = data.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.toString()");
        return string;
    }

    private PactWriter() {
    }

    static {
        PactWriter pactWriter;
        INSTANCE = pactWriter = new PactWriter();
    }
}

