/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.InvalidHttpResponseException;
import au.com.dius.pact.model.PactReaderKt;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.UrlPactSource;
import groovy.json.JsonSlurper;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.RESTClient;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a4\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002\"&\u0010\u0000\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"ACCEPT_JSON", "", "", "logger", "Lmu/KLogger;", "loadPactFromUrl", "Lkotlin/Pair;", "", "Lau/com/dius/pact/model/PactSource;", "source", "Lau/com/dius/pact/model/UrlPactSource;", "options", "", "http", "Lgroovyx/net/http/RESTClient;", "setupHttpAuthentication", "", "auth", "", "pact-jvm-model_main"})
public final class PactReaderKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final Map<String, Map<String, String>> ACCEPT_JSON = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"requestProperties", (Object)MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json")}))});

    @NotNull
    public static final Pair<Object, PactSource> loadPactFromUrl(@NotNull UrlPactSource source, @NotNull Map<String, ?> options, @NotNull RESTClient http) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        if (options.containsKey("authentication")) {
            Object auth = options.get("authentication");
            if (auth instanceof List) {
                PactReaderKt.setupHttpAuthentication((List)auth, http);
            } else {
                logger.warn((Function0)new Function0<String>(auth){
                    final /* synthetic */ Object $auth;

                    @NotNull
                    public final String invoke() {
                        return "Ignoring invalid authentication values '" + this.$auth + "' - it should be a list";
                    }
                    {
                        this.$auth = object;
                        super(0);
                    }
                });
            }
            Object response = http.get(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"headers", (Object)MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json")}))}));
            if (response instanceof HttpResponseDecorator) {
                Object object = ((HttpResponseDecorator)response).getData();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                return TuplesKt.to((Object)object, (Object)source);
            }
            throw (Throwable)new InvalidHttpResponseException("Received an invalid response from the HTTP client: " + response);
        }
        return TuplesKt.to((Object)new JsonSlurper().parse(new URL(source.getUrl()), ACCEPT_JSON), (Object)source);
    }

    private static final void setupHttpAuthentication(List<?> auth, RESTClient http) {
        String string;
        String string2 = string = String.valueOf(CollectionsKt.first(auth));
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        switch (string4.hashCode()) {
            case 93508654: {
                if (string4.equals("basic")) {
                    if (auth.size() > 2) {
                        http.getAuth().basic(String.valueOf(auth.get(1)), String.valueOf(auth.get(2)));
                        break;
                    }
                    logger.warn((Function0)setupHttpAuthentication.1.INSTANCE);
                    break;
                }
            }
            default: {
                logger.warn((Function0)new Function0<String>(auth){
                    final /* synthetic */ List $auth;

                    @NotNull
                    public final String invoke() {
                        return "Unrecognised authentication scheme: " + this.$auth;
                    }
                    {
                        this.$auth = list;
                        super(0);
                    }
                });
            }
        }
    }
}

