/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.full;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.full.ACrashDetailView;
import at.favre.lib.planb.full.R;
import at.favre.lib.planb.parser.BugReportPlaceholderHandler;
import at.favre.lib.planb.parser.GenericMLParser;
import at.favre.lib.planb.parser.MarkupRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class CrashDetailActivity
extends ACrashDetailView {
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.planblib_activity_crashdetail);
        this.vibrate(savedInstanceState);
        CrashData cd = (CrashData)this.getIntent().getParcelableExtra("CRASHDATA");
        this.setCrashDataToView(cd);
        this.configurePrimaryButton(cd, (Button)this.findViewById(R.id.btn_log));
        this.configureSecondaryButton(cd, (Button)this.findViewById(R.id.btn_restart));
    }

    protected void vibrate(Bundle savedInstanceState) {
        Vibrator vibrator;
        if (savedInstanceState == null && ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.VIBRATE") == 0 && (vibrator = (Vibrator)this.getSystemService("vibrator")).hasVibrator()) {
            vibrator.vibrate(200L);
        }
    }

    protected void configurePrimaryButton(final CrashData cd, Button button) {
        button.setText(R.string.planb_crashdetail_btn_primary);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BugReportPlaceholderHandler handler = new BugReportPlaceholderHandler(cd);
                InputStream inputStream = CrashDetailActivity.this.getResources().openRawResource(R.raw.bugreport);
                Scanner s = new Scanner(inputStream).useDelimiter("\\A");
                String result = s.hasNext() ? s.next() : "";
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int syntaxId = CrashDetailActivity.this.getIntent().getIntExtra("BUGREPORT_SYNTAX", 0);
                GenericMLParser parser = new GenericMLParser();
                Log.w((String)"", (String)("==BUGREPORT START==\n\n" + parser.render(result, MarkupRenderer.Util.getById((int)syntaxId), handler.getPlaceHolderMap()) + "\n\n==BUGREPORT END=="));
                Toast.makeText((Context)v.getContext(), (int)R.string.planb_crashexplorer_toast_log, (int)0).show();
            }
        });
    }

    protected void configureSecondaryButton(CrashData cd, Button button) {
        button.setText(R.string.planb_crashdetail_btn_secondary);
        this.findViewById(R.id.btn_restart).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = v.getContext().getPackageManager().getLaunchIntentForPackage(v.getContext().getPackageName());
                intent.addFlags(0x10008000);
                CrashDetailActivity.this.startActivity(intent);
            }
        });
    }
}

