/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.full;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.v7.app.AppCompatActivity;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.full.R;
import at.favre.lib.planb.util.CrashDataUtil;
import java.util.Map;

public abstract class ACrashDetailView
extends AppCompatActivity {
    protected void setCrashDataToView(CrashData cd) {
        if (cd != null) {
            ((TextView)this.findViewById(R.id.title)).setText((CharSequence)CrashDataUtil.getClassNameForException((String)cd.throwableClassName));
            this.setKeyValueString("Thread: ", cd.threadName, R.id.tv_thread);
            this.setKeyValueString("Version: ", cd.versionString + " [" + cd.applicationVariant + "]", R.id.tv_state_version);
            this.setKeyValueString("SCM: ", cd.scmString, R.id.tv_state_scm);
            this.setKeyValueString("CI: ", cd.ciString, R.id.tv_state_ci);
            this.setAdditionalVersionTextView((TextView)this.findViewById(R.id.tv_additional_version_info));
            SpannableStringBuilder throwableClassName = new SpannableStringBuilder((CharSequence)cd.throwableClassName);
            throwableClassName.setSpan((Object)new StyleSpan(1), 0, throwableClassName.length(), 33);
            SpannableStringBuilder causeFileNameAndNum = new SpannableStringBuilder((CharSequence)(cd.causeFileName + ":" + cd.causeLineNum));
            causeFileNameAndNum.setSpan((Object)new UnderlineSpan(), 0, causeFileNameAndNum.length(), 33);
            ((TextView)this.findViewById(R.id.timestamp)).setText((CharSequence)CrashDataUtil.parseDate((long)cd.timestamp));
            ((TextView)this.findViewById(R.id.tv_ex_msg)).setText((CharSequence)cd.message);
            ((TextView)this.findViewById(R.id.tv_stacktrace)).setText((CharSequence)cd.fullStacktrace);
            if (!cd.customData.isEmpty()) {
                this.findViewById(R.id.header_additional).setVisibility(0);
                LinearLayout viewGroup = (LinearLayout)this.findViewById(R.id.container_additional);
                viewGroup.setVisibility(0);
                for (Map.Entry entry : cd.customData.entrySet()) {
                    TextView tv = (TextView)LayoutInflater.from((Context)this).inflate(R.layout.planblib_inc_text_prop, (ViewGroup)viewGroup, false);
                    this.setKeyValueString((String)entry.getKey() + ": ", (String)entry.getValue(), tv);
                    viewGroup.addView((View)tv);
                }
            }
        }
    }

    private void setKeyValueString(String label, String content, @IdRes int id2) {
        this.setKeyValueString(label, content, (TextView)this.findViewById(id2));
    }

    private void setKeyValueString(String label, String content, TextView textView) {
        if (content != null && !content.isEmpty()) {
            SpannableStringBuilder titleVersion = new SpannableStringBuilder((CharSequence)label);
            titleVersion.setSpan((Object)new StyleSpan(1), 0, titleVersion.length(), 33);
            textView.setText((CharSequence)new SpannableStringBuilder((CharSequence)titleVersion).append((CharSequence)content));
        } else {
            textView.setVisibility(8);
        }
    }

    protected void setAdditionalVersionTextView(TextView textView) {
        textView.setVisibility(8);
    }
}

