/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.recover;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import at.favre.lib.planb.PlanBConfig;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.interfaces.CrashRecoverBehaviour;
import at.favre.lib.planb.recover.BaseCrashBehaviour;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StartActivityBehaviour
extends BaseCrashBehaviour {
    private static final String TAG = StartActivityBehaviour.class.getName();
    private static final int DEFAULT_ACTIVITY_FLAGS = 0x10808000;
    public static final int FOREGROUND_ACTIVITY = 0;
    public static final int LAUNCHER_ACTIVTY = 1;
    public static final String KEY_CRASHDATA = "CRASHDATA";
    public static final String KEY_BUGREPORT_SYNTAX = "BUGREPORT_SYNTAX";
    private Intent intent;
    private Integer activityType;

    private StartActivityBehaviour(Intent intent, Integer activityType, @Nullable CrashRecoverBehaviour.CrashAction preCrashAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
        super(true, false, true, preCrashAction, postCrashAction);
        this.intent = intent;
        this.activityType = activityType;
    }

    public StartActivityBehaviour(Intent intent, @Nullable CrashRecoverBehaviour.CrashAction preCrashAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
        this(intent, null, preCrashAction, postCrashAction);
    }

    public StartActivityBehaviour(Intent intent) {
        this(intent, (CrashRecoverBehaviour.CrashAction)new CrashRecoverBehaviour.CrashAction.Noop(), (CrashRecoverBehaviour.CrashAction)new CrashRecoverBehaviour.CrashAction.Noop());
    }

    public StartActivityBehaviour(int activityType, @Nullable CrashRecoverBehaviour.CrashAction preCrashAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
        this(null, activityType, preCrashAction, postCrashAction);
    }

    public StartActivityBehaviour(int activityType) {
        this(activityType, null, null);
    }

    @Override
    public void handleCrash(@NonNull Context context, @NonNull Thread thread, @NonNull Throwable throwable, @NonNull CrashData crashData, @NonNull PlanBConfig config) {
        if (this.intent == null) {
            try {
                if (this.activityType == 0) {
                    this.intent = this.getForegroundActivityIntent(context);
                } else if (this.activityType == 1) {
                    this.intent = this.getLauncherIntent(context);
                }
                if (this.intent == null) {
                    this.intent = this.getLauncherIntent(context);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Could not get intent for current foreground activity", (Throwable)e);
                return;
            }
        }
        this.intent.putExtra(KEY_CRASHDATA, (Parcelable)crashData);
        this.intent.putExtra(KEY_BUGREPORT_SYNTAX, config.bugReportMarkupLanguage);
        this.intent.addFlags(0x10808000);
        context.startActivity(this.intent);
    }

    private Intent getLauncherIntent(Context context) {
        return context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
    }

    private Intent getForegroundActivityIntent(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.GET_TASKS") != 0) {
            throw new IllegalStateException("Checking the current activity requires 'android.permission.GET_TASKS' permisison. See http://stackoverflow.com/questions/3873659");
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ComponentName componentName = Build.VERSION.SDK_INT >= 23 ? ((ActivityManager.AppTask)am.getAppTasks().get((int)0)).getTaskInfo().topActivity : ((ActivityManager.RunningTaskInfo)am.getRunningTasks((int)1).get((int)0)).topActivity;
        if (componentName == null) {
            throw new IllegalStateException("Could not find componentName for current foreground activity");
        }
        try {
            this.intent = new Intent(context, Class.forName(componentName.getClassName()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not create current foreground activity, could not find " + componentName.getPackageName());
        }
        return this.intent;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActivityType {
    }
}

