/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.parser;

import android.support.annotation.NonNull;
import at.favre.lib.planb.parser.MarkupRenderer;

public class HTML5Renderer
implements MarkupRenderer {
    @Override
    @NonNull
    public String renderHeader() {
        return "<!doctype html><html><head></head><body>\n";
    }

    @Override
    public String render(String content, int tokenType) {
        switch (tokenType) {
            case 0: {
                return "<h1>" + content + "<h1>\n";
            }
            case 1: {
                return "<h2>" + content + "<h2>\n";
            }
            case 2: {
                return "<h3>" + content + "<h3>\n";
            }
            case 3: {
                return "<strong>" + content + "</strong>";
            }
            case 4: {
                return "<em>" + content + "</em>";
            }
            case 5: {
                return "<code>" + content + "<code>";
            }
            case 6: {
                return "<pre>" + content + "</pre>\n";
            }
            case 7: {
                return "<blockquote>" + content + "</blockquote>\n";
            }
        }
        return "unknown command (" + content + ")";
    }

    @Override
    @NonNull
    public String renderFooter() {
        return "\n</body></html>";
    }

    @Override
    public int getType() {
        return 3;
    }
}

