/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.parser;

import android.support.annotation.VisibleForTesting;
import at.favre.lib.planb.parser.MarkupRenderer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class GenericMLParser {
    public static final int TOKEN_HEADER1 = 0;
    public static final int TOKEN_HEADER2 = 1;
    public static final int TOKEN_HEADER3 = 2;
    public static final int TOKEN_STRONG = 3;
    public static final int TOKEN_ITALIC = 4;
    public static final int TOKEN_CODE = 5;
    public static final int TOKEN_CODEBLOCK = 6;
    public static final int TOKEN_QUOTE = 7;
    public static final Map<String, Integer> genericTokens = new HashMap<String, Integer>();

    public String render(String template, MarkupRenderer renderer, Map<String, String> placeHolderValues) {
        StringBuilder out = new StringBuilder();
        out.append(renderer.renderHeader());
        out.append(this.fillPlaceholder(this.renderTemplate(template, renderer), placeHolderValues));
        out.append(renderer.renderFooter());
        return out.toString();
    }

    @VisibleForTesting(otherwise=2)
    String fillPlaceholder(String text, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            System.out.println(entry.getKey() + " replace with " + entry.getValue());
            text = text.replace("{{" + entry.getKey() + "}}", entry.getValue());
        }
        return text;
    }

    public String renderTemplate(String template, MarkupRenderer renderer) {
        StringBuilder out = new StringBuilder();
        char[] chars = template.toCharArray();
        boolean commandMode = false;
        boolean contentMode = false;
        StringBuilder command = new StringBuilder();
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (contentMode) {
                if (chars[i] == ')') {
                    out.append(renderer.render(content.toString(), genericTokens.get(command.toString())));
                    command.setLength(0);
                    content.setLength(0);
                    commandMode = false;
                    contentMode = false;
                    continue;
                }
                content.append(chars[i]);
                continue;
            }
            if (commandMode) {
                if (chars[i] == '(') {
                    contentMode = true;
                    continue;
                }
                command.append(chars[i]);
                continue;
            }
            if (chars[i] == '_' && i + 1 < chars.length && chars[i + 1] == '_') {
                commandMode = true;
                ++i;
                continue;
            }
            out.append(chars[i]);
        }
        return out.toString();
    }

    static {
        genericTokens.put("header1", 0);
        genericTokens.put("header2", 1);
        genericTokens.put("header3", 2);
        genericTokens.put("strong", 3);
        genericTokens.put("italic", 4);
        genericTokens.put("code", 5);
        genericTokens.put("codeBlock", 6);
        genericTokens.put("quote", 7);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MarkupToken {
    }
}

